/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.bd.model;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.bd.model.ModelF7ParamContext;
import kd.epm.epbs.business.bd.model.UserDistributeServiceHelper;
import kd.epm.epbs.business.mservice.AppBizServiceEnum;
import kd.epm.epbs.business.mservice.AppBizServiceHelper;
import kd.epm.epbs.business.permission.model.ModelPermHelper;
import kd.epm.epbs.common.bean.EpbsContext;
import kd.epm.epbs.common.enums.AppModelEnum;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.util.ModelUtil;

public class TempModelF7ParamContext
extends ModelF7ParamContext {
    protected Collection<Long> getLimitedModelIds(AppModelEnum appModel) {
        try {
            long userId = RequestContext.get().getCurrUserId();
            String entityId = appModel.getModelPermEntity();
            if (StringUtils.isNotEmpty((String)entityId)) {
                return (Collection)ThreadCache.get((Object)("limit_model_" + userId + "_" + appModel.getAppType().getAppNum()), () -> {
                    Set<Object> modelIds = new HashSet();
                    Set<Long> groupIds = UserDistributeServiceHelper.queryGroupIdsWithUser2UserId(userId);
                    QFilter filter = new QFilter("modelpermentry.eusers", "in", (Object)groupIds.toArray());
                    filter.and("model.reporttype", "=", (Object)appModel.getReportType());
                    DynamicObjectCollection dys = QueryServiceHelper.query((String)entityId, (String)"model.id", (QFilter[])new QFilter[]{filter});
                    if (!CollectionUtils.isEmpty((Collection)dys)) {
                        modelIds = dys.stream().filter(dy -> dy.getLong("model.id") != 0L).map(dy -> dy.getLong("model.id")).collect(Collectors.toSet());
                    }
                    return modelIds;
                });
            }
        }
        catch (Exception e) {
            throw new KDException(String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u5f02\u5e38:%s", (String)"TempModelF7ParamContext_1", (String)"epm-epbs-business", (Object[])new Object[0]), e.getMessage()));
        }
        return Collections.emptySet();
    }

    @Override
    public Collection<Long> getLimitedModelIds() {
        HashSet<Long> modelIds = new HashSet<Long>(16);
        for (AppModelEnum appModel : ModelUtil.getAppModelByEnum(this.getQueryAppTypes())) {
            modelIds.addAll(this.getLimitedModelIds(appModel));
        }
        if (this.getSrcAppType() == AppTypeEnum.EPBS) {
            modelIds.addAll(ModelPermHelper.getLimitedModelListByUser(this.getQueryAppTypes() == null ? null : this.getQueryAppTypes().toArray(new AppTypeEnum[0])));
        }
        return modelIds;
    }

    @Override
    public Collection<Long> getEffectiveModelIds() {
        Collection<Long> limitModelIds = this.getLimitedModelIds();
        if (this.isOnlyManager()) {
            return limitModelIds;
        }
        if (this.getEntityNumber().endsWith("_olap_log_inh")) {
            for (AppModelEnum appModel : ModelUtil.getAppModelByEnum(this.getQueryAppTypes())) {
                String entityId = AppTypeEnum.isEbApp((String)appModel.getAppType().getAppNum()) ? "eb_olapdataauditlog" : "bcm_audit_log";
                limitModelIds.addAll(TempModelF7ParamContext.getModelPermByUser(appModel.getAppType(), entityId, "47150e89000000ac"));
            }
        }
        return limitModelIds;
    }

    public static Set<Long> getModelPermByUser(AppTypeEnum appType, String entityNum, String permItemId) {
        try {
            HashMap param = Maps.newHashMapWithExpectedSize((int)4);
            param.put("userId", RequestContext.get().getCurrUserId());
            param.put("entityNum", entityNum);
            param.put("permItemId", permItemId);
            EpbsContext result = AppBizServiceHelper.invokeBizService(appType, (EpbsContext<Object>)new EpbsContext(AppBizServiceEnum.QueryModelPerm.name(), (Object)param));
            if (result != null && result.getData() != null) {
                return (Set)result.getData();
            }
        }
        catch (Exception e) {
            throw new KDException(String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u5f02\u5e38:%s", (String)"TempModelF7ParamContext_1", (String)"epm-epbs-business", (Object[])new Object[0]), e.getMessage()));
        }
        return Collections.emptySet();
    }
}

