/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.bd.model;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.enums.ModelUserTypeEnum;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.QFBuilder;

public class UserDistributeServiceHelper {
    private static final String USER = "user.id";
    private static final String USER_GROUP_ID = "usergroup.id";

    public static Set<Long> queryAllGroupByUserId(long userId) {
        if (ThreadCache.exists((Object)("usergroup" + userId))) {
            return (Set)ThreadCache.get((Object)("usergroup" + userId));
        }
        HashSet<Long> usergroupIdList = new HashSet<Long>();
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        BusinessDataServiceHelper.loadFromCache((String)"bos_usergroupstaff", (String)USER_GROUP_ID, (QFilter[])new QFilter[]{userFilter}).values().forEach(e -> usergroupIdList.add(e.getLong(USER_GROUP_ID)));
        ThreadCache.put((Object)"usergroup", usergroupIdList);
        return usergroupIdList;
    }

    public static Set<Long> queryAllGroupByUserId(Set<Long> userGrpIds) {
        HashSet userGroupIdList = Sets.newHashSetWithExpectedSize((int)userGrpIds.size());
        QFBuilder userQFBuilder = new QFBuilder(USER_GROUP_ID, "in", userGrpIds);
        BusinessDataServiceHelper.loadFromCache((String)"bos_usergroupstaff", (String)USER, (QFilter[])userQFBuilder.toArray()).values().forEach(e -> userGroupIdList.add(e.getLong(USER)));
        return userGroupIdList;
    }

    public static DynamicObjectCollection queryAllUsersByGroup(QFilter filter) {
        return QueryServiceHelper.query((String)"bos_usergroupstaff", (String)"user,user.name as name,user.phone as phone,user.email as email,user.number as number", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObjectCollection queryAllUsersByGroupIds(List<Long> userGroupIds) {
        QFilter userGroupFilter = new QFilter("usergroup", "in", userGroupIds);
        return UserDistributeServiceHelper.queryAllUsersByGroup(userGroupFilter);
    }

    public static Set<Long> queryGroupIdsWithUser2UserId(long currUserId) {
        return (Set)ThreadCache.get((Object)("query-user" + currUserId), () -> {
            Set<Long> groupByUserId = UserDistributeServiceHelper.queryAllGroupByUserId(currUserId);
            HashSet<Long> t = new HashSet<Long>(groupByUserId);
            t.add(currUserId);
            return t;
        });
    }

    public static Set<Long> queryGroupIdsWithUser2UserId() {
        return UserDistributeServiceHelper.queryGroupIdsWithUser2UserId(RequestContext.get().getCurrUserId());
    }

    public static String getUsernameByUserid(Object userid) {
        QFilter filter = new QFilter("id", "=", (Object)IDUtils.toLong((Object)userid));
        return BusinessDataServiceHelper.loadSingleFromCache((String)ModelUserTypeEnum.USER.getType(), (String)"name", (QFilter[])new QFilter[]{filter}).getString("name");
    }

    public static String getUserOrUserGroup2Name(ModelUserTypeEnum userType, Long id) {
        DynamicObject dy = QueryServiceHelper.queryOne((String)userType.getType(), (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        return dy != null ? dy.getString("name") : "";
    }

    public static String getUserOrUserGroup2Number(ModelUserTypeEnum userType, Long id) {
        DynamicObject dy = QueryServiceHelper.queryOne((String)userType.getType(), (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        return dy != null ? dy.getString("number") : "";
    }
}

