/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.dataimport;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.CreaterProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class FileResourceImportHelper {
    private static final Map<String, List<String>> ENTITY_UN_FIELDS_MAP = new HashMap<String, List<String>>(16);

    public static IDataEntityProperty getCreatedByProperty(BasedataEntityType dataEntityType) {
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof CreaterProp)) continue;
            return property;
        }
        return null;
    }

    public static DynamicObject getLocalDynamicObject(String entityname, String numberProperty, Object number, DynamicObject importObj) {
        String pkKey;
        DynamicObject dynamicObject;
        MainEntityType dataEntityType;
        List<String> unFields = ENTITY_UN_FIELDS_MAP.get(entityname);
        QFilter qFilter = null;
        if (unFields != null) {
            for (String unField : unFields) {
                Object value = importObj.get(unField);
                QFilter qFilter1 = new QFilter(unField, "=", value);
                if (qFilter == null) {
                    qFilter = qFilter1;
                    continue;
                }
                qFilter.and(qFilter1);
            }
        } else {
            qFilter = new QFilter(numberProperty, "=", number);
        }
        Object pk = null;
        if (qFilter != null && (dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityname)).getPrimaryKey() != null && (dynamicObject = QueryServiceHelper.queryOne((String)entityname, (String)(pkKey = dataEntityType.getPrimaryKey().getName()), (QFilter[])qFilter.toArray())) != null) {
            pk = dynamicObject.get(pkKey);
        }
        if (pk != null) {
            return BusinessDataServiceHelper.loadSingle(pk, (String)entityname);
        }
        return null;
    }

    static {
        ENTITY_UN_FIELDS_MAP.put("epdm_dm_preset", Arrays.asList("datamodel.number", "field"));
        ENTITY_UN_FIELDS_MAP.put("epdm_dm", Arrays.asList("catalog.number", "number"));
    }
}

