/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.licence;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.licence.VersionService;
import kd.epm.epbs.common.configuration.enums.AppConfigPropEnum;
import kd.epm.epbs.common.configuration.enums.IAppConfigProp;
import kd.epm.epbs.common.configuration.factory.ConfigurationContext;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.common.util.AppUtils;

public class LicenceControl {
    protected static final WatchLogger log = EpbsLogFactory.getWatchLogInstance(LicenceControl.class);
    private static final String PLATFORM_VERSION = "4.0.000.0";
    private static final String SHOW_LOCK_VERSION = "6.0.0";
    private static final String TREE_IMAGE_VERSION = "6.0.2";
    private static boolean isFormShow;
    private static Method setCancelFormShowParameter;
    private static Method getCancelFormShowParameter;

    public static void setCancelFormShowParameter(PreOpenFormEventArgs eventArgs, LicenseCheckResult licenseCheckResult) {
        if (!isFormShow) {
            return;
        }
        Object msg = null;
        try {
            msg = getCancelFormShowParameter.invoke((Object)licenseCheckResult, new Object[0]);
            setCancelFormShowParameter.invoke((Object)eventArgs, msg);
        }
        catch (Exception e) {
            log.error("setCancelFormShowParameter error:" + msg, (Throwable)e);
        }
    }

    public static LicenceControl getInstance(String appId) {
        return new LicenceControl();
    }

    protected Map<String, Set<String>> getFormLicence() {
        return null;
    }

    protected Map<String, Set<String>> getFormLicenceByAppId(String appId) {
        if (StringUtils.isEmpty((String)appId) || !LicenceControl.checkAppId(appId)) {
            return null;
        }
        HashMap objToFormIds = null;
        String config = ConfigurationContext.INSTANCE.loadProp(appId, (IAppConfigProp)AppConfigPropEnum.LICENCE_CONTROL_OBJID);
        if (StringUtils.isEmpty((String)config) && AppTypeEnum.EMR.getAppNum().equals(appId)) {
            config = ConfigurationContext.INSTANCE.loadProp(AppTypeEnum.EPBS.getAppNum(), (IAppConfigProp)AppConfigPropEnum.LICENCE_CONTROL_OBJID);
        }
        if (StringUtils.isNotEmpty((String)config)) {
            objToFormIds = new HashMap(16);
            String[] objid = config.split(":");
            HashSet<String> set = new HashSet<String>(16);
            if (objid.length > 1) {
                for (String formid : objid[1].split(",")) {
                    set.add(formid);
                }
            }
            objToFormIds.put(objid[0], set);
        }
        return objToFormIds;
    }

    protected Map<String, Set<String>> getSpecialLicence() {
        return null;
    }

    protected final Map.Entry<String, Set<String>> getFormLicence(String formId) {
        if (null == this.getFormLicence()) {
            return null;
        }
        Map.Entry entry = this.getFormLicence().entrySet().stream().filter(e -> ((Set)e.getValue()).contains(formId)).findFirst().orElseGet(() -> null);
        return entry;
    }

    protected final Map.Entry<String, Set<String>> getFormLicence(String appId, String formId) {
        Map<String, Set<String>> objids = this.getFormLicenceByAppId(appId);
        if (null == objids) {
            return null;
        }
        Map.Entry entry = objids.entrySet().stream().filter(e -> ((Set)e.getValue()).contains(formId)).findFirst().orElseGet(() -> null);
        return entry;
    }

    protected final Map.Entry<String, Set<String>> getSpecialLicence(String formId) {
        if (null == this.getSpecialLicence()) {
            return null;
        }
        Map.Entry entry = this.getSpecialLicence().entrySet().stream().filter(e -> ((Set)e.getValue()).contains(formId)).findFirst().orElseGet(() -> null);
        return entry;
    }

    public final LicenseCheckResult check(String appId, String formId) {
        Map.Entry<String, Set<String>> formLicence = this.getFormLicence(appId, formId);
        if (null != formLicence) {
            log.info(String.format("license_result:appId=%s,formId=%s", appId, formId));
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            if (StringUtils.isEmpty((String)appId)) {
                return new LicenseCheckResult(Boolean.valueOf(false), ResManager.loadKDString((String)"\u8bb8\u53ef\u6821\u9a8c\u5931\u8d25\uff1aappid\u4e3a\u7a7a\u3002", (String)"LicenceControl_1", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            String platFormVersion = VersionService.getPlatFormVersion();
            if (StringUtils.isNotEmpty((String)platFormVersion) && platFormVersion.compareToIgnoreCase(PLATFORM_VERSION) > 0) {
                return this.checkByAppAndBizObj(appId, formLicence.getKey(), userId);
            }
            return new LicenseCheckResult(Boolean.valueOf(true), "1");
        }
        Map.Entry<String, Set<String>> specialLicence = this.getSpecialLicence(formId);
        if (specialLicence != null) {
            return this.checkSpecialLicense(specialLicence.getKey());
        }
        return null;
    }

    protected final LicenseCheckResult checkSpecialLicense(String groupNumber) {
        LicenseCheckResult re = null;
        String productVersion = LicenseServiceHelper.getProductVersion();
        BigDecimal licenseVersion = new BigDecimal(productVersion.trim());
        if (licenseVersion.compareTo(new BigDecimal("1.0")) > 0) {
            re = LicenseServiceHelper.checkPerformGroup((String)groupNumber);
        }
        return re;
    }

    public boolean lessThanV6() {
        return (Boolean)ThreadCache.get((Object)"lessThanV6", () -> {
            String version = VersionService.getPlatFormVersion();
            if (StringUtils.isNotEmpty((String)version) && version.compareToIgnoreCase(SHOW_LOCK_VERSION) >= 0) {
                return false;
            }
            return true;
        });
    }

    public boolean lessThan602() {
        return (Boolean)ThreadCache.get((Object)"lessThan602", () -> {
            try {
                String version = VersionService.getPlatFormCorrectVersion();
                Comparator<String> comparator = VersionService.getVersionComparetor();
                if (StringUtils.isNotEmpty((String)version) && comparator.compare(version, TREE_IMAGE_VERSION) >= 0) {
                    return false;
                }
                return true;
            }
            catch (Exception e) {
                return true;
            }
        });
    }

    public LicenseCheckResult checkByAppAndBizObj(String appId, String bizObjID, Long userId) {
        LicenseCheckResult result = LicenseServiceHelper.checkByAppAndBizObj((String)AppMetadataCache.getAppInfo((String)appId).getId(), (String)bizObjID, (Long)userId);
        if (result != null) {
            log.info(String.format("license_result:appid=%s,bizobjid=%s,userId=%s;%s,%s", appId, bizObjID, userId, result.getHasLicense(), result.getMsg()));
        }
        return result;
    }

    public boolean checkByAppAndBizObj2(String appId, String bizObjID, Long userId) {
        LicenseCheckResult result = this.checkByAppAndBizObj(appId, bizObjID, userId);
        return null != result ? result.getHasLicense() : false;
    }

    public boolean checkLicenseModules(String appId) {
        LicenseCheckResult result = LicenseServiceHelper.checkLicenseModules((String)AppMetadataCache.getAppInfo((String)appId).getId());
        return null != result ? result.getHasLicense() : false;
    }

    public static boolean checkAppId(String appId) {
        boolean check = false;
        try {
            check = AppUtils.getAppNumsCache().contains(appId);
            if (check) {
                AppMetadataCache.getAppInfo((String)appId);
            }
        }
        catch (Exception e) {
            check = false;
        }
        return check;
    }

    static {
        try {
            setCancelFormShowParameter = PreOpenFormEventArgs.class.getDeclaredMethod("setCancelFormShowParameter", String.class);
            getCancelFormShowParameter = LicenseCheckResult.class.getDeclaredMethod("getCancelFormShowParameter", new Class[0]);
            isFormShow = true;
        }
        catch (NoSuchMethodException e) {
            log.error("isFormShow is false", (Throwable)e);
        }
    }
}

