/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.licence;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.service.bo.Version;

public class VersionService {
    private static Log logger = LogFactory.getLog(VersionService.class);

    public static List<Version> getVersionInfos() {
        return kd.bos.portal.service.VersionService.getVersionInfos();
    }

    public static List<Version> getVersionCorrectInfos() {
        String sql = "select fid, fproductnumber, fversion, fupgradetime from t_bas_industry_version where fproductnumber = 'cosmic_bos' or fproductnumber like 'constellation_%';";
        List<Object> versions = Lists.newArrayList();
        try {
            List allVersion = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, resultSet -> {
                ArrayList<Version> result = new ArrayList<Version>(resultSet.getRow());
                while (resultSet.next()) {
                    Version version = new Version();
                    version.setId(resultSet.getString("fid"));
                    version.setVersion(resultSet.getString("fversion"));
                    version.setProductNumber(resultSet.getString("fproductnumber"));
                    version.setUpgradeTime((Date)resultSet.getDate("fupgradetime"));
                    result.add(version);
                }
                return result;
            });
            for (Version version : allVersion) {
                if (!"cosmic_bos".equals(version.getProductNumber())) continue;
                versions.add(version);
                break;
            }
            allVersion.removeAll(versions);
            Comparator comparator = (c1, c2) -> {
                String[] str2s;
                String[] str1s = c1.getVersion().split("\\.");
                int size = str1s.length > (str2s = c2.getVersion().split("\\.")).length ? str2s.length : str1s.length;
                for (int i = 0; i < size; ++i) {
                    if (Integer.valueOf(str1s[i]).compareTo(Integer.valueOf(str2s[i])) > 0) {
                        return 1;
                    }
                    if (Integer.valueOf(str1s[i]).compareTo(Integer.valueOf(str2s[i])) >= 0) continue;
                    return -1;
                }
                if (str1s.length > str2s.length) {
                    return 1;
                }
                if (str1s.length < str2s.length) {
                    return -1;
                }
                return 0;
            };
            allVersion.stream().max(comparator).ifPresent(versions::add);
        }
        catch (Exception var5) {
            versions = VersionService.getVersionInfos();
            logger.error("\u67e5\u8be2\u53d1\u5e03\u7248\u672c\u4fe1\u606f\u5f02\u5e38...", (Throwable)var5);
        }
        return versions;
    }

    public static Comparator<String> getVersionComparetor() {
        return (c1, c2) -> {
            String[] str2s;
            String[] str1s = c1.split("\\.");
            int size = str1s.length > (str2s = c2.split("\\.")).length ? str2s.length : str1s.length;
            for (int i = 0; i < size; ++i) {
                if (Integer.valueOf(str1s[i]).compareTo(Integer.valueOf(str2s[i])) > 0) {
                    return 1;
                }
                if (Integer.valueOf(str1s[i]).compareTo(Integer.valueOf(str2s[i])) >= 0) continue;
                return -1;
            }
            if (str1s.length > str2s.length) {
                return 1;
            }
            if (str1s.length < str2s.length) {
                return -1;
            }
            return 0;
        };
    }

    public static String getPlatFormVersion() {
        List<Version> versions = VersionService.getVersionInfos();
        Version versionInfo = versions.stream().filter(x -> Objects.equals(x.getProductNumber(), "cosmic_bos")).findAny().orElse(null);
        if (null != versionInfo) {
            return versionInfo.getVersion();
        }
        return "";
    }

    public static String getPlatFormCorrectVersion() {
        List<Version> versions = VersionService.getVersionCorrectInfos();
        Version versionInfo = versions.stream().filter(x -> Objects.equals(x.getProductNumber(), "cosmic_bos")).findAny().orElse(null);
        if (null != versionInfo) {
            return versionInfo.getVersion();
        }
        return "";
    }
}

