/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.log.audit;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kd.epm.epbs.common.elasticsearch.ESUtils;
import kd.epm.epbs.common.enums.AppTypeEnum;
import org.apache.commons.lang3.time.DateUtils;
import org.jetbrains.annotations.NotNull;

public class OlapAuditESIndexStrategy {
    private static final String DATE_YEAR_MONTH_FORMATTER = "yyyy-MM";
    public static final String AuditIndexNameFmt = "audit-%s-%s.%s";

    public static final String getAuditIndexNameFmt(AppTypeEnum appTypeEnum) {
        return Joiner.on((String)"-").join((Object)appTypeEnum.getAppNum(), (Object)AuditIndexNameFmt, new Object[0]);
    }

    public static String buildSummaryIndexName(String modelNumber, AppTypeEnum appTypeEnum) {
        return OlapAuditESIndexStrategy.buildAuditIndexName(modelNumber, AuditIndexType.summary.name(), new Date(), OlapAuditESIndexStrategy.getAuditIndexNameFmt(appTypeEnum));
    }

    public static String buildDataIndexName(String modelNumber, AppTypeEnum appTypeEnum) {
        return OlapAuditESIndexStrategy.buildAuditIndexName(modelNumber, AuditIndexType.data.name(), new Date(), OlapAuditESIndexStrategy.getAuditIndexNameFmt(appTypeEnum));
    }

    private static String buildAuditIndexName(String modelNumber, String type, Date dataDate, String indexNameFmt) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"param AuditLogIndexType can not be null");
        if (Objects.isNull(dataDate)) {
            dataDate = new Date();
        }
        String dateString = OlapAuditESIndexStrategy.formatDate(dataDate);
        return OlapAuditESIndexStrategy.buildAuditIndexName(modelNumber, type, dateString, indexNameFmt);
    }

    private static String formatDate(Date dataDate) {
        return ESUtils.formatUTCDateFormat((Date)dataDate, (String)DATE_YEAR_MONTH_FORMATTER);
    }

    private static String buildAuditIndexName(String modelNumber, String type, String date, String indexNameFmt) {
        return String.format(indexNameFmt, modelNumber.toLowerCase(Locale.ENGLISH), type, date);
    }

    public static String decideSearchIndexName(String modelNumber, String type, Date startDate, Date endDate, String indexNameFmt) {
        List<String> availableMonthIndexes = OlapAuditESIndexStrategy.listIndexNames(modelNumber, type, startDate, endDate, indexNameFmt);
        if (availableMonthIndexes.size() > 5) {
            Date now = new Date();
            String thisMonthIndex = OlapAuditESIndexStrategy.buildAuditIndexName(modelNumber, type, now, indexNameFmt);
            return thisMonthIndex.replace(OlapAuditESIndexStrategy.formatDate(now), "*");
        }
        return String.join((CharSequence)",", availableMonthIndexes);
    }

    private static List<String> listIndexNames(String modelNumber, String type, @NotNull Date startDate, @NotNull Date endDate, String indexNameFmt) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"param AuditLogIndexType can not be null");
        Preconditions.checkArgument((startDate.getTime() <= endDate.getTime() ? 1 : 0) != 0, (Object)"param startDate can not exceed endDate");
        ArrayList<String> indexes = new ArrayList<String>(10);
        String startDateIndex = OlapAuditESIndexStrategy.buildAuditIndexName(modelNumber, type, startDate, indexNameFmt);
        indexes.add(startDateIndex);
        while (startDate.getTime() < endDate.getTime()) {
            String oneMonthIndex = OlapAuditESIndexStrategy.buildAuditIndexName(modelNumber, type, startDate = DateUtils.addMonths((Date)startDate, (int)1), indexNameFmt);
            if (indexes.contains(oneMonthIndex)) continue;
            indexes.add(oneMonthIndex);
        }
        String endDateIndex = OlapAuditESIndexStrategy.buildAuditIndexName(modelNumber, type, endDate, indexNameFmt);
        if (!indexes.contains(endDateIndex)) {
            indexes.add(endDateIndex);
        }
        return indexes;
    }

    public static enum AuditIndexType {
        summary,
        data;

    }
}

