/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.log.audit;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.epbs.business.configuration.register.OlapAuditEsmappingRegister;
import kd.epm.epbs.business.log.IOlapLogListFunction;
import kd.epm.epbs.business.log.audit.AuditLogBill;
import kd.epm.epbs.business.log.audit.AuditLogQueryParam;
import kd.epm.epbs.business.log.audit.OlapAuditContext;
import kd.epm.epbs.business.log.audit.OlapAuditESIndexStrategy;
import kd.epm.epbs.business.log.audit.OldAuditIndex;
import kd.epm.epbs.business.log.trace.OlapOpInfo;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import kd.epm.epbs.common.bean.Page;
import kd.epm.epbs.common.cache.model.Dimension;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.configuration.enums.AppConfigPropEnum;
import kd.epm.epbs.common.configuration.register.PropRegisterFactory;
import kd.epm.epbs.common.elasticsearch.ESUtils;
import kd.epm.epbs.common.elasticsearch.ElasticSearchService;
import kd.epm.epbs.common.elasticsearch.LocalDateFormat;
import kd.epm.epbs.common.elasticsearch.bean.OlapAuditSummaryEvent;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.enums.UserTypeEnum;
import kd.epm.epbs.common.thread.EpbsThreadPools;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epbs.common.util.JSONUtils;
import kd.epm.epbs.common.util.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.jetbrains.annotations.NotNull;

public class OlapAuditService {
    private static final Log LOG = LogFactory.getLog(OlapAuditService.class);
    public static final String FIELD_OperateType = "operateType";
    private static final String DATA_INDEX_DATE_FIELD = "created";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    public static final String EVENT_ID = "eventId";
    public static final String CACHE_EVENTID = "OlapAuditService.eventId";

    public static OlapAuditService getInstance() {
        return InnerClass.instance;
    }

    public void enhanceCommandWithAuditReal(OlapAuditContext auditContext) {
        AppTypeEnum appType = ModelUtil.getAppType((Long)auditContext.getModelId());
        String appnum = appType.getAppNum();
        String cubeNumber = auditContext.getCubeNumber();
        List<CommandInfo> commandInfos = auditContext.getCommandInfos();
        String summmaryEsIndex = OlapAuditESIndexStrategy.buildSummaryIndexName(cubeNumber, appType);
        String dataEsIndex = OlapAuditESIndexStrategy.buildDataIndexName(cubeNumber, appType);
        OlapAuditEsmappingRegister instance = (OlapAuditEsmappingRegister)PropRegisterFactory.createInstance(OlapAuditEsmappingRegister.class);
        Map indexMap = (Map)instance.getResult(appnum);
        ESUtils.checkAndCreateIndex((String)summmaryEsIndex, (String)((String)indexMap.get(AppConfigPropEnum.OLAP_AUDIT_ESMAPPING_SUMMARY.getKey())));
        ESUtils.checkAndCreateIndex((String)dataEsIndex, (String)((String)indexMap.get(AppConfigPropEnum.OLAP_AUDIT_ESMAPPING_DATA.getKey())));
        RequestContext context = RequestContext.get();
        String eventId = GlobalIdUtil.genStringId();
        ThreadCache.put((Object)CACHE_EVENTID, (Object)eventId);
        ArrayList logList = Lists.newArrayListWithCapacity((int)commandInfos.size());
        commandInfos.forEach(e -> {
            OlapAuditSummaryEvent olapDataBusinessEvent = this.buildBusinessEsDoc(summmaryEsIndex, cubeNumber, context.getTraceId(), eventId, context.getLoginIP(), e.toString(), context.getUserId(), context.getUserName());
            logList.add(olapDataBusinessEvent);
        });
        EpbsThreadPools.commonExecute(() -> logList.forEach(e -> ElasticSearchService.getInstance().insertDoc(summmaryEsIndex, JSONUtils.toJson((Object)e, (DateFormat)new LocalDateFormat()))));
        commandInfos.forEach(e -> this.setExtendPropOnCommand((CommandInfo)e, eventId, dataEsIndex));
    }

    private void setExtendPropOnCommand(CommandInfo commandInfo, String eventId, String dataIndexName) {
        HashMap<String, String> extendProps = new HashMap<String, String>(2);
        extendProps.put(EVENT_ID, eventId);
        extendProps.put("auditIndex", dataIndexName);
        Map configMap = ElasticSearchService.getInstance().getServerConfig("audit");
        String httpport = (String)configMap.get("httpport");
        String port = httpport == null ? (String)configMap.get("port") : httpport;
        extendProps.put("audit.ip", (String)configMap.get("ip"));
        extendProps.put("audit.port", port);
        extendProps.put("audit.username", (String)configMap.get("username"));
        extendProps.put("audit.password", configMap.get("password") == null ? null : Encrypters.decode((String)((String)configMap.get("password"))));
        extendProps.put("audit.batchSize", (String)configMap.get("batchSize"));
        LOG.info("auditIndex: {}, ip: {},  port: {},  username: {},  batchSize: {}", new Object[]{dataIndexName, configMap.get("ip"), port, configMap.get("username"), configMap.get("batchSize")});
        Map extProperties = commandInfo.getExtProperties();
        if (MapUtils.isEmpty((Map)extProperties)) {
            commandInfo.setExtProperties(extendProps);
        } else {
            extendProps.putAll(extProperties);
            commandInfo.setExtProperties(extendProps);
        }
    }

    private OlapAuditSummaryEvent buildBusinessEsDoc(String esIndex, String cubeNumber, String traceId, String eventId, String hostIp, String operateData, String userId, String userName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)eventId));
        OlapOpInfo olapOpInfo = OlapTraceServiceHelper.getOlapOpInfo();
        OlapAuditSummaryEvent olapDataBusinessEvent = new OlapAuditSummaryEvent();
        olapDataBusinessEvent.setEsIndex(esIndex);
        olapDataBusinessEvent.setCubeNumber(cubeNumber);
        olapDataBusinessEvent.setTraceId(traceId);
        olapDataBusinessEvent.setEventId(eventId);
        olapDataBusinessEvent.setIp("[0:0:0:0:0:0:0:1]".equals(hostIp) ? "127.0.0.1" : hostIp);
        if (olapOpInfo != null && olapOpInfo.getOpType() != null) {
            olapDataBusinessEvent.setOperateType(olapOpInfo.getOpType().getCode());
        }
        olapDataBusinessEvent.setOperateData(operateData);
        olapDataBusinessEvent.setOperateTime(new Date());
        olapDataBusinessEvent.setUserId(userId);
        olapDataBusinessEvent.setUserName(userName);
        OperationContext context = OperationContext.get();
        if (Objects.nonNull(context)) {
            olapDataBusinessEvent.setAppId(context.getAppId());
            olapDataBusinessEvent.setFormId(context.getFormId());
            olapDataBusinessEvent.setOpMethod(context.getOpMethod());
            olapDataBusinessEvent.setOpKey(context.getOpKey());
        }
        return olapDataBusinessEvent;
    }

    public Page<AuditLogBill> search(long modelId, @NotNull AuditLogQueryParam queryParam, @NotNull Integer page, @NotNull Integer pageSize, boolean history) {
        String modelCubeId = queryParam.getCubeNumber();
        String indexNameFmt = OlapAuditESIndexStrategy.getAuditIndexNameFmt(ModelUtil.getAppType((Long)modelId));
        String summary = OlapAuditESIndexStrategy.AuditIndexType.summary.name();
        String data = OlapAuditESIndexStrategy.AuditIndexType.data.name();
        if (history) {
            String appnum = ModelCacheHelper.getModel((long)modelId).getSrcAppNum();
            OldAuditIndex oldIndex = OldAuditIndex.getByAppNum(appnum);
            if (null == oldIndex) {
                return new Page();
            }
            indexNameFmt = oldIndex.getIndexFmt();
            summary = oldIndex.getSummary();
            data = oldIndex.getData();
            modelCubeId = oldIndex.isShowNumber() ? ModelCacheHelper.getModel((long)modelId).getShowNumber() : modelCubeId;
            queryParam.setFilterCube(oldIndex.isFilterCube());
            queryParam.setHistory(history);
        }
        boolean hasMemberFilter = MapUtils.isNotEmpty(queryParam.getDimMemberMap());
        String message = "";
        LinkedHashMap eventIdSummaryDocDict = Maps.newLinkedHashMapWithExpectedSize((int)1000);
        List<Map<String, Object>> dataDocs = this.getDataDocs(eventIdSummaryDocDict, queryParam, page, pageSize, modelCubeId, indexNameFmt, summary, data, hasMemberFilter);
        if (dataDocs == null || CollectionUtils.isEmpty(dataDocs)) {
            Page pageResult = new Page((long)page.intValue(), (long)pageSize.intValue(), 0L);
            return pageResult;
        }
        if (dataDocs.size() == pageSize.intValue()) {
            message = ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u8d85\u8fc710000\u6761\uff0c\u8bf7\u9009\u62e9\u5177\u4f53\u7ef4\u5ea6\u6210\u5458\u67e5\u8be2\uff0c\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002\u6bd4\u5982\u9009\u62e9\u201c\u7ec4\u7ec7\u6210\u5458\u3001\u79d1\u76ee\u6210\u5458\u3001\u9884\u7b97\u671f\u95f4\u6210\u5458\u3001\u7248\u672c\u6210\u5458\u7b49\u201d\u3002", (String)"OlapAuditService_1", (String)"epm-epbs-business", (Object[])new Object[0]);
        }
        List<AuditLogBill> billList = this.convertAuditLogToBill(modelId, dataDocs, eventIdSummaryDocDict, queryParam);
        Page pageResult = new Page((long)page.intValue(), (long)pageSize.intValue(), (long)billList.size());
        pageResult.setRecords(billList);
        pageResult.setMessage(message);
        return pageResult;
    }

    private SearchHits getSummarySearchHit(Set<String> filterEventIds, AuditLogQueryParam queryParam, Integer page, Integer pageSize, String modelCubeId, String indexNameFmt, String summary) {
        long businessSearchTick = System.currentTimeMillis();
        SearchSourceBuilder businessSearchBuilder = this.buildAuditBusinessSearch(filterEventIds, queryParam, pageSize);
        ElasticSearchService.getInstance().timeoutSeconds(businessSearchBuilder, 3L);
        String businessIndexName = OlapAuditESIndexStrategy.decideSearchIndexName(modelCubeId, summary, queryParam.getStartTime(), queryParam.getEndTime(), indexNameFmt);
        SearchHits businessHits = this.doQuery(businessIndexName, businessSearchBuilder);
        LOG.info("audit_log_search_summary cost time: " + (System.currentTimeMillis() - businessSearchTick));
        return businessHits;
    }

    private SearchHits getDataSearchHit(Set<String> filterEventIds, AuditLogQueryParam queryParam, Integer page, Integer pageSize, String modelCubeId, String indexNameFmt, String data) {
        long olapSearchTick = System.currentTimeMillis();
        SearchSourceBuilder olapSearchBuilder = this.buildAuditDataSearch(filterEventIds, queryParam);
        olapSearchBuilder.from((page - 1) * pageSize);
        olapSearchBuilder.size(page * pageSize);
        ElasticSearchService.getInstance().timeoutSeconds(olapSearchBuilder, 10L);
        String olapIndexName = OlapAuditESIndexStrategy.decideSearchIndexName(modelCubeId, data, queryParam.getStartTime(), queryParam.getEndTime(), indexNameFmt);
        SearchHits dataHits = this.doQuery(olapIndexName, olapSearchBuilder);
        LOG.info("audit_log_search_data cost time: " + (System.currentTimeMillis() - olapSearchTick));
        LOG.info("audit_log_search_data,allHits:" + dataHits.getTotalHits());
        return dataHits;
    }

    private List<Map<String, Object>> getDataDocs(Map<String, OlapAuditSummaryEvent> eventIdSummaryDocDict, AuditLogQueryParam queryParam, Integer page, Integer pageSize, String modelCubeId, String indexNameFmt, String summary, String data, boolean hasMemberFilter) {
        List<Map<String, Object>> dataDocs;
        if (hasMemberFilter) {
            LinkedHashMap eventIdDataDocDict = Maps.newLinkedHashMapWithExpectedSize((int)1000);
            SearchHits dataHits = this.getDataSearchHit(null, queryParam, page, pageSize, modelCubeId, indexNameFmt, data);
            if (dataHits.getTotalHits() == 0L) {
                return null;
            }
            dataDocs = this.convertHits(dataHits, new TypeReference<Map<String, Object>>(){});
            for (Map<String, Object> x : dataDocs) {
                eventIdDataDocDict.put((String)x.get(EVENT_ID), x);
            }
            SearchHits summeryHits = this.getSummarySearchHit(eventIdDataDocDict.keySet(), queryParam, page, pageSize, modelCubeId, indexNameFmt, summary);
            if (summeryHits.getTotalHits() == 0L) {
                return null;
            }
            this.toSummaryMap(summeryHits, eventIdSummaryDocDict);
            dataDocs = dataDocs.stream().filter(dataDoc -> {
                Object eventId = dataDoc.get(EVENT_ID);
                return eventIdSummaryDocDict.containsKey(eventId);
            }).collect(Collectors.toList());
        } else {
            SearchHits summeryHits = this.getSummarySearchHit(null, queryParam, page, pageSize, modelCubeId, indexNameFmt, summary);
            if (summeryHits.getTotalHits() == 0L) {
                return null;
            }
            this.toSummaryMap(summeryHits, eventIdSummaryDocDict);
            SearchHits dataHits = this.getDataSearchHit(eventIdSummaryDocDict.keySet(), queryParam, page, pageSize, modelCubeId, indexNameFmt, data);
            if (dataHits.getTotalHits() == 0L) {
                return null;
            }
            dataDocs = this.convertHits(dataHits, new TypeReference<Map<String, Object>>(){});
        }
        return dataDocs;
    }

    private <T> List<T> convertHits(SearchHits searchHits, TypeReference<T> typeReference) {
        List docs = ElasticSearchService.getInstance().convertHits(searchHits.getHits(), typeReference);
        return docs;
    }

    private Map<String, OlapAuditSummaryEvent> toSummaryMap(SearchHits summeryHits, Map<String, OlapAuditSummaryEvent> eventIdSummeryDocDict) {
        List<OlapAuditSummaryEvent> summaryDocs = this.convertHits(summeryHits, new TypeReference<OlapAuditSummaryEvent>(){});
        int maxCount = 100000;
        for (OlapAuditSummaryEvent event : summaryDocs.subList(0, Math.min(summaryDocs.size(), maxCount))) {
            eventIdSummeryDocDict.put(event.getEventId(), event);
        }
        LOG.info("audit_log_search_summary all event ids: {}", (Object)String.join((CharSequence)",", eventIdSummeryDocDict.keySet()));
        return eventIdSummeryDocDict;
    }

    private SearchHits doQuery(String indexName, SearchSourceBuilder sourceBuilder) {
        return ElasticSearchService.getInstance().search(indexName, sourceBuilder);
    }

    private SearchSourceBuilder buildAuditBusinessSearch(Set<String> filterEventIds, AuditLogQueryParam qp, int pageSize) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder conditionBuilder = QueryBuilders.boolQuery();
        RangeQueryBuilder rangeQueryBuilder = new RangeQueryBuilder("operateTime");
        rangeQueryBuilder.from((Object)ESUtils.formatUTCDateFormat((Date)qp.getStartTime()));
        rangeQueryBuilder.to((Object)ESUtils.formatUTCDateFormat((Date)qp.getEndTime()));
        conditionBuilder.filter((QueryBuilder)rangeQueryBuilder);
        if (!CollectionUtils.isEmpty(filterEventIds)) {
            conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)EVENT_ID, filterEventIds));
        }
        if (Objects.nonNull(qp.getCubeNumber()) && qp.isFilterCube()) {
            conditionBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"cubeNumber", (String)qp.getCubeNumber()));
        }
        if (Objects.nonNull(qp.getUserIds())) {
            conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"userId", (Object[])qp.getUserIds()));
        }
        if (StringUtils.isNotEmpty((CharSequence)qp.getTransactionTag())) {
            if (null == qp.getFunction()) {
                this.buildOperateType(conditionBuilder, qp.getTransactionTag());
            } else {
                qp.getFunction().buildOperateType(conditionBuilder, qp);
            }
        }
        searchSourceBuilder.sort("operateTime", qp.isSortByTimeAsc() ? SortOrder.ASC : SortOrder.DESC);
        searchSourceBuilder.query((QueryBuilder)conditionBuilder);
        searchSourceBuilder.from(0);
        searchSourceBuilder.size(pageSize);
        return searchSourceBuilder;
    }

    private SearchSourceBuilder buildAuditDataSearch(Set<String> filterEventIds, AuditLogQueryParam qp) {
        Map<String, Set<String>> dimMemberMap;
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder conditionBuilder = QueryBuilders.boolQuery();
        RangeQueryBuilder rangeQueryBuilder = new RangeQueryBuilder(DATA_INDEX_DATE_FIELD);
        rangeQueryBuilder.from((Object)ESUtils.formatUTCDateFormat((Date)qp.getStartTime()));
        rangeQueryBuilder.to((Object)ESUtils.formatUTCDateFormat((Date)qp.getEndTime()));
        conditionBuilder.filter((QueryBuilder)rangeQueryBuilder);
        if (!CollectionUtils.isEmpty(filterEventIds)) {
            conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)EVENT_ID, filterEventIds));
        }
        if (MapUtils.isNotEmpty(dimMemberMap = qp.getDimMemberMap())) {
            for (Map.Entry<String, Set<String>> entry : dimMemberMap.entrySet()) {
                if (!CollectionUtils.isNotEmpty((Collection)entry.getValue())) continue;
                conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)entry.getKey(), (Collection)entry.getValue()));
            }
        }
        searchSourceBuilder.sort(DATA_INDEX_DATE_FIELD, qp.isSortByTimeAsc() ? SortOrder.ASC : SortOrder.DESC);
        searchSourceBuilder.query((QueryBuilder)conditionBuilder);
        if (LOG.isDebugEnabled()) {
            LOG.debug("audit_log_query condition:" + conditionBuilder);
        }
        return searchSourceBuilder;
    }

    private List<AuditLogBill> convertAuditLogToBill(long modelId, List<Map<String, Object>> dataDocs, Map<String, OlapAuditSummaryEvent> eventIdBusinessDocDict, AuditLogQueryParam queryParam) {
        IOlapLogListFunction function = queryParam.getFunction();
        List<Dimension> dimensionList = queryParam.getDimensionList();
        Map<String, Map<String, DynamicObject>> dimMemberDojMap = this.convertNumToDoj(dataDocs, modelId, queryParam);
        Object[] userIds = (Long[])eventIdBusinessDocDict.values().stream().map(OlapAuditSummaryEvent::getUserId).filter(StringUtils::isNotEmpty).map(Long::parseLong).distinct().toArray(Long[]::new);
        Map userCache = BusinessDataServiceHelper.loadFromCache((Object[])userIds, (String)UserTypeEnum.USER.getEntityNum());
        boolean isShowAuditLogData = Boolean.parseBoolean(System.getProperty("epm.auditlog.islog", "false"));
        return dataDocs.stream().map(dataDoc -> {
            AuditLogBill logBill = new AuditLogBill();
            String eventId = (String)dataDoc.get(EVENT_ID);
            if (isShowAuditLogData) {
                LOG.info("audit_log_search_log: eventId:{} {}", (Object)eventId, (Object)JSONUtils.toString((Object)dataDoc));
            }
            logBill.setEventId(eventId);
            logBill.setDataDocId((String)dataDoc.get("_id"));
            OlapAuditSummaryEvent businessDoc = (OlapAuditSummaryEvent)eventIdBusinessDocDict.get(eventId);
            if (Objects.nonNull(businessDoc)) {
                logBill.setTraceId(businessDoc.getTraceId());
                String userId = businessDoc.getUserId();
                if (StringUtils.isNotEmpty((CharSequence)userId)) {
                    logBill.setUserDy(((DynamicObject)userCache.get(Long.parseLong(userId))).getString(NAME));
                }
                logBill.setIp(businessDoc.getIp());
                logBill.setOperateType(businessDoc.getOperateType());
                logBill.setTransactionType(businessDoc.getFormId());
                if (Objects.isNull(logBill.getUserDy())) {
                    LOG.info("audit_log_search_blank business: {}", (Object)JSONUtils.toString((Object)businessDoc));
                }
            } else {
                LOG.info("audit_log_search_without_business: eventID[{}], is involved into filter event ids: {}", (Object)eventId, (Object)eventIdBusinessDocDict.containsKey(eventId));
            }
            try {
                logBill.setOperateTime(ESUtils.parseUTCDate((String)((String)dataDoc.get(DATA_INDEX_DATE_FIELD))));
            }
            catch (Exception e) {
                LOG.error("failed_to_parse_es_dat_formate: " + dataDoc.get(DATA_INDEX_DATE_FIELD), (Throwable)e);
                logBill.setOperateTime(null);
            }
            HashMap dimMemberToDojMap = Maps.newHashMapWithExpectedSize((int)dimensionList.size());
            logBill.setDimMemberToDojMap(dimMemberToDojMap);
            for (Dimension dimension : dimensionList) {
                String dimNumber = dimension.getNumber();
                Map memberDojMap = (Map)dimMemberDojMap.get(dimNumber);
                String memberNumber = (String)dataDoc.get(dimNumber);
                memberNumber = null != function ? function.dealMemberNumber(dimNumber, memberNumber) : memberNumber;
                dimMemberToDojMap.put(dimNumber.toLowerCase(), ModelUtil.getMemberInfoStr((String)memberNumber, (DynamicObject)((DynamicObject)memberDojMap.get(memberNumber))));
            }
            logBill.setOldValue(Objects.isNull(dataDoc.get("oldValue")) ? "" : String.valueOf(dataDoc.get("oldValue")));
            logBill.setNewValue(Objects.isNull(dataDoc.get("newValue")) ? "" : String.valueOf(dataDoc.get("newValue")));
            logBill.setTypeChange((String)dataDoc.get("typeChange"));
            return logBill;
        }).collect(Collectors.toList());
    }

    private Map<String, Map<String, DynamicObject>> convertNumToDoj(List<Map<String, Object>> dataDocs, long modelId, AuditLogQueryParam queryParam) {
        IOlapLogListFunction function = queryParam.getFunction();
        List<Dimension> dimensionList = queryParam.getDimensionList();
        HashMap dimMemberDojMap = Maps.newHashMapWithExpectedSize((int)dimensionList.size());
        for (Dimension dimension : dimensionList) {
            String dimNumber = dimension.getNumber();
            Set memberNums = dataDocs.stream().filter(x -> x.containsKey(dimNumber)).map(x -> null != function ? function.dealMemberNumber(dimNumber, (String)x.get(dimNumber)) : (String)x.get(dimNumber)).collect(Collectors.toSet());
            if (memberNums.isEmpty()) {
                dimMemberDojMap.put(dimNumber, Collections.emptyMap());
                continue;
            }
            dimMemberDojMap.put(dimNumber, ModelUtil.getDimMemberDyn((Long)modelId, (Dimension)dimension, memberNums));
        }
        return dimMemberDojMap;
    }

    public void buildOperateType(BoolQueryBuilder conditionBuilder, String transactionTag) {
        if (StringUtils.isNotEmpty((CharSequence)transactionTag)) {
            List trans = Arrays.stream(transactionTag.split(",")).filter(e -> StringUtils.isNotEmpty((CharSequence)e)).collect(Collectors.toList());
            conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)FIELD_OperateType, trans));
        }
    }

    private static class InnerClass {
        private static OlapAuditService instance = new OlapAuditService();

        private InnerClass() {
        }
    }
}

