/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.log.audit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.log.audit.AuditLogBill;
import kd.epm.epbs.business.log.audit.AuditLogQueryParam;
import kd.epm.epbs.business.log.audit.OlapAuditContext;
import kd.epm.epbs.business.log.audit.OlapAuditService;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.epm.epbs.common.apitest.ApiTest;
import kd.epm.epbs.common.apitest.ApiTestMethod;
import kd.epm.epbs.common.apitest.ApiTestModel;
import kd.epm.epbs.common.apitest.ApiTestParam;
import kd.epm.epbs.common.apitest.enums.ApiTestFeatureEnum;
import kd.epm.epbs.common.bean.Page;
import kd.epm.epbs.common.util.IDUtils;
import org.apache.commons.collections4.CollectionUtils;

@ApiTest(value="\u591a\u7ef4\u5ba1\u8ba1\u65e5\u5fd7\u63a5\u53e3", feature=ApiTestFeatureEnum.LOG)
public class OlapAuditServiceHelper {
    private static final Log LOG = LogFactory.getLog(OlapAuditServiceHelper.class);
    public static final String VISIBLE_FALSE = "visible_false";
    public static final String ENABLE_FALSE = "enable_false";
    public static final String CUSTOM_MEMBER = "custom_member";
    public static final String START_TIME = "start_time";
    public static final String NEED_VALID_AUDIT = "need_valid_audit";

    @ApiTestMethod(value="\u5ba1\u8ba1\u65e5\u5fd7\u662f\u5426\u5f00\u542f\uff08\u53c2\u6570\uff1aEPM001\uff09")
    public static boolean isOpenAudit(@ApiTestParam(value="\u4f53\u7cfbID") Long modelId) {
        boolean isOpenAudit = ParamSettingServiceHelper.getBooleanWithChild(modelId, "EPM001", "opendatalog");
        return isOpenAudit;
    }

    @ApiTestMethod(value="\u4fdd\u5b58\u5ba1\u8ba1\u65e5\u5fd7", test=false)
    public static void enhanceCommandWithAudit(@ApiTestParam(value="\u4f53\u7cfbID") Long modelId, @ApiTestParam(value="Cube\u7f16\u7801") String cubeNumber, @ApiTestParam(value="\u591a\u7ef4\u6307\u4ee4\u96c6\u5408") Collection<CommandInfo> commandInfos) {
        OlapAuditServiceHelper.enhanceCommandWithAudit(new OlapAuditContext(modelId, cubeNumber, new ArrayList<CommandInfo>(commandInfos)));
    }

    @ApiTestMethod(value="\u4fdd\u5b58\u5ba1\u8ba1\u65e5\u5fd7", test=false)
    public static void enhanceCommandWithAudit(@ApiTestParam(value="\u5ba1\u8ba1\u65e5\u5fd7\u4e0a\u4e0b\u6587") OlapAuditContext auditContext) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(auditContext.getCommandInfos()), (Object)"parameter commandInfo can not be null");
        if (OlapAuditServiceHelper.isOpenAudit(auditContext.getModelId())) {
            try {
                OlapAuditService.getInstance().enhanceCommandWithAuditReal(auditContext);
            }
            catch (Exception e) {
                LOG.info("enhanceCommandWithAudit failed:" + e.getMessage(), (Object)e);
            }
        }
    }

    @ApiTestMethod(value="\u67e5\u8be2\u5ba1\u8ba1\u65e5\u5fd7", test=false)
    public static Page<AuditLogBill> search(@ApiTestParam(value="\u67e5\u8be2\u6761\u4ef6") AuditLogQueryParam queryParam, @ApiTestParam(value="\u5f53\u524d\u9875\u6570") Integer page, @ApiTestParam(value="\u6bcf\u9875\u8bb0\u5f55\u6570") Integer pageSize) {
        Page<AuditLogBill> list = OlapAuditService.getInstance().search(queryParam.getModelId(), queryParam, page, pageSize, false);
        List historyList = OlapAuditService.getInstance().search(queryParam.getModelId(), queryParam, page, pageSize, true).getRecords();
        if (CollectionUtils.isNotEmpty((Collection)historyList)) {
            if (CollectionUtils.isEmpty((Collection)list.getRecords())) {
                list.setRecords(historyList);
            } else {
                list.getRecords().addAll(historyList);
            }
            list.setTotal((long)list.getRecords().size());
        }
        return list;
    }

    @ApiTestMethod(value="\u6253\u5f00\u5ba1\u8ba1\u65e5\u5fd7/\u591a\u7ef4\u6570\u636e\u53d8\u52a8\u65e5\u5fd7\u9875\u9762", test=false)
    public static void openOpLogPage(@ApiTestParam(value="\u5f53\u524dFormView") IFormView formView, @ApiTestParam(value="\u4f53\u7cfbID") Long modelId, @ApiTestParam(value="\u7ef4\u5ea6\u6210\u5458\u7f16\u7801") Map<String, String> memberMap, @ApiTestParam(value="\u6269\u5c55\u53c2\u6570") LogPageParam logPageParam) {
        if (IDUtils.isNull((Long)modelId)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"OlapAuditServiceHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]));
            return;
        }
        if (null == memberMap || memberMap.isEmpty()) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b8c\u6574\u7ef4\u5ea6\u3002", (String)"OlapAuditServiceHelper_2", (String)"epm-epbs-business", (Object[])new Object[0]));
            return;
        }
        if (null == logPageParam) {
            logPageParam = new LogPageParam();
        }
        HashMap params = Maps.newHashMap();
        params.put(CUSTOM_MEMBER, memberMap);
        params.put("KEY_MODEL_ID", String.valueOf(modelId));
        if (IDUtils.isNotNull((Long)logPageParam.getDatasetId())) {
            params.put("KEY_DATASET_ID", String.valueOf(logPageParam.getDatasetId()));
        }
        if (CollectionUtils.isNotEmpty(logPageParam.getVisibleFalse())) {
            params.put(VISIBLE_FALSE, logPageParam.getVisibleFalse());
        }
        if (CollectionUtils.isNotEmpty(logPageParam.getEnableFalse())) {
            params.put(ENABLE_FALSE, logPageParam.getEnableFalse());
        }
        if (null != logPageParam.getStartTime()) {
            params.put(START_TIME, logPageParam.getStartTime());
        }
        if (logPageParam.isAudit()) {
            params.put(NEED_VALID_AUDIT, Boolean.FALSE.toString());
        }
        FormShowParameter formparam = new FormShowParameter();
        formparam.setFormId(logPageParam.isAudit() ? "epbs_olap_log" : "epbs_olap_log_trace");
        formparam.setParentPageId(formView.getPageId());
        formparam.setHasRight(true);
        formparam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formparam.getCustomParams().putAll(params);
        if (StringUtils.isNotEmpty((String)logPageParam.getCaption())) {
            formparam.setCaption(logPageParam.getCaption());
        }
        formView.showForm(formparam);
    }

    @ApiTestModel(value="\u6269\u5c55\u53c2\u6570")
    public static class LogPageParam {
        @ApiTestParam(value="\u662f\u5426\u5ba1\u8ba1\u65e5\u5fd7")
        private boolean audit;
        @ApiTestParam(value="\u6570\u636e\u96c6ID\uff08\u9884\u7b97\u4f53\u7cfb\uff09")
        private Long datasetId;
        @ApiTestParam(value="\u6807\u9898")
        private String caption;
        @ApiTestParam(value="\u5f00\u59cb\u65f6\u95f4")
        private Date startTime;
        @ApiTestParam(value="\u9690\u85cf\u63a7\u4ef6")
        private List<String> visibleFalse;
        @ApiTestParam(value="\u9501\u5b9a\u63a7\u4ef6")
        private List<String> enableFalse;

        public Long getDatasetId() {
            return this.datasetId;
        }

        public void setDatasetId(Long datasetId) {
            this.datasetId = datasetId;
        }

        public String getCaption() {
            return this.caption;
        }

        public void setCaption(String caption) {
            this.caption = caption;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public boolean isAudit() {
            return this.audit;
        }

        public void setAudit(boolean audit) {
            this.audit = audit;
        }

        public List<String> getVisibleFalse() {
            return this.visibleFalse;
        }

        public void setVisibleFalse(List<String> visibleFalse) {
            this.visibleFalse = visibleFalse;
        }

        public List<String> getEnableFalse() {
            return this.enableFalse;
        }

        public void setEnableFalse(List<String> enableFalse) {
            this.enableFalse = enableFalse;
        }
    }
}

