/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.log.audit;

import com.google.common.collect.Lists;
import java.util.List;
import kd.epm.epbs.common.enums.AppTypeEnum;

public enum OldAuditIndex {
    CM("audit-%s-%s.%s", "summary", "data", false, false, Lists.newArrayList((Object[])new String[]{AppTypeEnum.CM.getAppNum(), AppTypeEnum.RPT.getAppNum()})),
    EB("epm-audit-%s-%s.%s", "business", "olap", true, true, Lists.newArrayList((Object[])new String[]{AppTypeEnum.BGMD.getAppNum(), AppTypeEnum.EB.getAppNum(), AppTypeEnum.BG.getAppNum()}));

    private String indexFmt;
    private String summary;
    private String data;
    private boolean showNumber;
    private boolean filterCube;
    List<String> appNums;

    private OldAuditIndex(String indexFmt, String summary, String data, boolean showNumber, boolean filterCube, List<String> appNums) {
        this.indexFmt = indexFmt;
        this.summary = summary;
        this.data = data;
        this.showNumber = showNumber;
        this.filterCube = filterCube;
        this.appNums = appNums;
    }

    public static OldAuditIndex getByAppNum(String appNum) {
        for (OldAuditIndex value : OldAuditIndex.values()) {
            if (!value.appNums.contains(appNum)) continue;
            return value;
        }
        return null;
    }

    public String getIndexFmt() {
        return this.indexFmt;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getData() {
        return this.data;
    }

    public boolean isFilterCube() {
        return this.filterCube;
    }

    public boolean isShowNumber() {
        return this.showNumber;
    }
}

