/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.log.funperm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.log.funperm.FunctionPermLogMultiLangEnum;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import org.apache.commons.collections.CollectionUtils;

public class FunctionPermLogHelper {
    private static WatchLogger log = EpbsLogFactory.getWatchLogInstance((boolean)true, FunctionPermLogHelper.class);
    public static final String BEFORESAVE_ORGSPERMITEMS = "beforeSaveUserOrgsPermItems";

    public static DynamicObject newFunctionPermLog(Long modelId, String userNumber, String userName, String permEntity, String permName, String isUnioPerm, String operateName, Long createUserId, String clientType, String clientAddress, String appNumber) {
        DynamicObject dataPermLog = BusinessDataServiceHelper.newDynamicObject((String)"epbs_functionpermlog");
        dataPermLog.set("modelid", (Object)modelId);
        dataPermLog.set("usernumber", (Object)userNumber);
        dataPermLog.set("username", (Object)userName);
        dataPermLog.set("permentity", (Object)permEntity);
        dataPermLog.set("permname", (Object)permName);
        dataPermLog.set("operation", (Object)operateName);
        dataPermLog.set("isunionperm", (Object)isUnioPerm);
        dataPermLog.set("modifierid", (Object)createUserId);
        dataPermLog.set("modifytime", (Object)TimeServiceHelper.now());
        dataPermLog.set("clienttype", (Object)clientType);
        dataPermLog.set("clientaddress", (Object)clientAddress);
        dataPermLog.set("appnumber", (Object)appNumber);
        return dataPermLog;
    }

    public static DynamicObject newFunctionPermLog(Long modelId, String userNumber, String userName, String permEntity, String permName, String isUnioPerm, String operateName, String appNumber) {
        return FunctionPermLogHelper.newFunctionPermLog(modelId, userNumber, userName, permEntity, permName, isUnioPerm, operateName, RequestContext.get().getCurrUserId(), RequestContext.get().getClient(), RequestContext.get().getLoginIP(), appNumber);
    }

    public static DynamicObject newRolePermLog(Long modelId, String userNumber, String userName, String operateName, String appNumber) {
        return FunctionPermLogHelper.newFunctionPermLog(modelId, userNumber, userName, null, null, null, operateName, RequestContext.get().getCurrUserId(), RequestContext.get().getClient(), RequestContext.get().getLoginIP(), appNumber);
    }

    public static void batchInsertFunctionPermLog(List<DynamicObject> logs) {
        if (logs.size() > 0) {
            DynamicObjectType objectType = logs.get(0).getDynamicObjectType();
            int batchSize = 999;
            if (logs.size() < batchSize) {
                BusinessDataWriter.save((IDataEntityType)objectType, (Object[])logs.toArray(new DynamicObject[0]));
            } else {
                ArrayList<DynamicObject> batch = new ArrayList<DynamicObject>(batchSize);
                for (DynamicObject log : logs) {
                    batch.add(log);
                    if (batch.size() < batchSize) continue;
                    BusinessDataWriter.save((IDataEntityType)objectType, (Object[])batch.toArray(new DynamicObject[0]));
                    batch.clear();
                }
                if (!batch.isEmpty()) {
                    BusinessDataWriter.save((IDataEntityType)objectType, (Object[])batch.toArray(new DynamicObject[0]));
                    batch.clear();
                }
            }
        }
    }

    public static void writeUserDirectAssignPermLog(IFormView view) {
        DynamicObject user = (DynamicObject)view.getModel().getValue("user");
        if (user == null) {
            log.info("FunctionPermLogHelper-user == null \u5f53\u524d\u9875\u9762\u7684\u7528\u6237\u4e3a\u7a7a--\u5f02\u5e38");
            return;
        }
        String initAllPermItems = view.getPageCache().get(BEFORESAVE_ORGSPERMITEMS);
        if (StringUtils.isEmpty((String)initAllPermItems)) {
            log.info("FunctionPermLogHelper-writeFunPermLog()-initAllPermItems == null (BEFORESAVE_ORGSPERMITEMS)\u521d\u59cb\u5316\u67e5\u5e93\u5931\u8d25\uff01");
            return;
        }
        Map beforeSaveOrgPermItems = (Map)SerializationUtils.fromJsonString((String)initAllPermItems, Map.class);
        Map beforeSaveOrgPermItemsBAK = (Map)SerializationUtils.fromJsonString((String)initAllPermItems, Map.class);
        Map beforeSaveOrgPermItemsBAK1 = (Map)SerializationUtils.fromJsonString((String)initAllPermItems, Map.class);
        Map<String, List<String>> afterSaveOrgPermItems = FunctionPermLogHelper.getAfterSaveOrgPermItems(view);
        String afterSaveOrgPermItemsJsonStr = SerializationUtils.toJsonString(afterSaveOrgPermItems);
        Map afterSaveOrgPermItemsBAK = (Map)SerializationUtils.fromJsonString((String)afterSaveOrgPermItemsJsonStr, Map.class);
        beforeSaveOrgPermItems.keySet().removeAll(afterSaveOrgPermItems.keySet());
        afterSaveOrgPermItems.keySet().removeAll(beforeSaveOrgPermItemsBAK.keySet());
        beforeSaveOrgPermItemsBAK.keySet().removeAll(beforeSaveOrgPermItems.keySet());
        beforeSaveOrgPermItemsBAK1.keySet().removeAll(beforeSaveOrgPermItems.keySet());
        afterSaveOrgPermItemsBAK.keySet().removeAll(afterSaveOrgPermItems.keySet());
        for (Map.Entry entry : beforeSaveOrgPermItemsBAK.entrySet()) {
            ((List)entry.getValue()).removeAll((Collection)afterSaveOrgPermItemsBAK.get(entry.getKey()));
        }
        for (Map.Entry entry : afterSaveOrgPermItemsBAK.entrySet()) {
            ((List)entry.getValue()).removeAll((Collection)beforeSaveOrgPermItemsBAK1.get(entry.getKey()));
        }
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>();
        FunctionPermLogHelper.addPermLogs(beforeSaveOrgPermItems, logs, 1, view);
        FunctionPermLogHelper.addPermLogs(afterSaveOrgPermItems, logs, 0, view);
        FunctionPermLogHelper.addPermLogs(beforeSaveOrgPermItemsBAK, logs, 1, view);
        FunctionPermLogHelper.addPermLogs(afterSaveOrgPermItemsBAK, logs, 0, view);
        if (logs.size() > 0) {
            view.getPageCache().put(BEFORESAVE_ORGSPERMITEMS, afterSaveOrgPermItemsJsonStr);
            try {
                FunctionPermLogHelper.batchInsertFunctionPermLog(logs);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                log.info("FunctionPermLogHelper.batchInsertFunctionPermLog \u6267\u884c\u5f02\u5e38");
            }
        }
    }

    private static void addPermLogs(Map<String, List<String>> userFuncPermModels, List<DynamicObject> logs, int logType, IFormView view) {
        if (userFuncPermModels.values().isEmpty()) {
            return;
        }
        DynamicObject dy = (DynamicObject)view.getModel().getValue("user");
        String usernumber = dy.getString("number");
        String username = dy.getString("name");
        String operationName = FunctionPermLogMultiLangEnum.DIRECT_Distribute.getOperateName();
        if (logType == 1) {
            operationName = FunctionPermLogMultiLangEnum.DIRECT_DelDistribute.getOperateName();
        }
        for (Map.Entry<String, List<String>> entry : userFuncPermModels.entrySet()) {
            List<String> permItemsList = entry.getValue();
            for (String permItem : permItemsList) {
                String[] permItems = permItem.split("@");
                String entityname = permItems.length < 5 ? null : permItems[4];
                String permitemname = permItems.length < 6 ? null : permItems[5];
                String appnum = permItems[permItems.length - 1];
                String appId = view.getFormShowParameter().getAppId();
                DynamicObject funcLog = FunctionPermLogHelper.newFunctionPermLog(Long.parseLong(entry.getKey()), usernumber, username, entityname, permitemname, "", operationName, appId);
                logs.add(funcLog);
            }
        }
    }

    public static Map<String, List<String>> getAfterSaveOrgPermItems(IFormView view) {
        DynamicObjectCollection orgsAllPermItems = FunctionPermLogHelper.getUserOrgsAllPermItems(view);
        Map<String, List<String>> afterSaveMap = FunctionPermLogHelper.getPermItemsMap(orgsAllPermItems);
        return afterSaveMap;
    }

    private static DynamicObjectCollection getUserOrgsAllPermItems(IFormView view) {
        QFilter directPermFilter = new QFilter("dimtype", "=", (Object)"DIM_EPBS_MODEL");
        DynamicObject user = (DynamicObject)view.getModel().getValue("user");
        directPermFilter.and("user.id", "=", (Object)user.getLong("id"));
        String userPermSelectFields = "id,org.id as modelid,user.id as userid,user.name as username,user.number as usernumber,entryentity.entitytype.name as entityname,entryentity.permitem.name as permitemname,entryentity.entitytype.number as entitynumber,entryentity.permitem.id as permitemid,entryentity.bizapp as appnum";
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        try {
            DataSet perm_userperm = QueryServiceHelper.queryDataSet((String)"epbs-permlog", (String)"perm_userperm", (String)userPermSelectFields, (QFilter[])new QFilter[]{directPermFilter}, (String)"").distinct();
            ORMImpl orm = new ORMImpl();
            dynamicObjects = orm.toPlainDynamicObjectCollection(perm_userperm);
        }
        catch (Exception e) {
            log.info("FunctionPermLogHelper-DataSet perm_userperm \u6267\u884c\u67e5\u5e93\u5f02\u5e38");
        }
        return dynamicObjects;
    }

    private static Map<String, List<String>> getPermItemsMap(DynamicObjectCollection initAllPermItem) {
        if (CollectionUtils.isEmpty((Collection)initAllPermItem)) {
            return Collections.emptyMap();
        }
        Map<String, List<DynamicObject>> modelMap = initAllPermItem.stream().collect(Collectors.groupingBy(t -> t.getString("modelid")));
        Set<String> keySet = modelMap.keySet();
        HashMap<String, List<String>> permMaps = new HashMap<String, List<String>>(keySet.size());
        for (Map.Entry<String, List<DynamicObject>> entry : modelMap.entrySet()) {
            List collect = entry.getValue().stream().map(t -> t.getString("modelid") + "@" + t.getString("userid") + "@" + t.getString("entitynumber") + "@" + t.getString("permitemid") + "@" + t.getString("entityname") + "@" + t.getString("permitemname") + "@" + t.getString("appnum")).collect(Collectors.toList());
            permMaps.put(entry.getKey(), collect);
        }
        return permMaps;
    }
}

