/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.log.funperm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.log.funperm.FunctionPermLogHelper;
import kd.epm.epbs.business.log.funperm.FunctionPermLogMultiLangEnum;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import org.apache.commons.lang3.tuple.Pair;

public class RoleStatusChangeHandler {
    public static final Long RoleModelId = 17299999999L;
    private static final WatchLogger log = EpbsLogFactory.getWatchLogInstance(RoleStatusChangeHandler.class);

    public static void logHandler(String appId, Collection<Pair<String, String>> numberAndNames, boolean isEnable) {
        if (CollectionUtils.isEmpty(numberAndNames)) {
            return;
        }
        ArrayList logs = Lists.newArrayListWithCapacity((int)numberAndNames.size());
        String operateName = isEnable ? FunctionPermLogMultiLangEnum.ROLE_ENABLE.getOperateName() : FunctionPermLogMultiLangEnum.ROLE_DISABLE.getOperateName();
        for (Pair<String, String> pair : numberAndNames) {
            DynamicObject log = FunctionPermLogHelper.newRolePermLog(RoleModelId, (String)pair.getKey(), (String)pair.getValue(), operateName, appId);
            logs.add(log);
        }
        try {
            FunctionPermLogHelper.batchInsertFunctionPermLog(logs);
        }
        catch (KDException e) {
            log.error((Throwable)e);
        }
    }

    public static void logHandler(Collection<Object> roleIds, boolean isEnable, String appId) {
        if (!CollectionUtils.isEmpty(roleIds)) {
            List<Pair<String, String>> s = QueryServiceHelper.query((String)"perm_role", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", roleIds)}).stream().map(e -> Pair.of((Object)e.getString("number"), (Object)e.getString("name"))).collect(Collectors.toList());
            RoleStatusChangeHandler.logHandler(appId, s, isEnable);
        }
    }
}

