/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.log.olap;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JavaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.olap.common.PropertyBag;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.FunctionCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.epm.epbs.business.log.olap.OlapTraceResult;
import kd.epm.epbs.business.log.olap.TransactionTraceInfo;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.common.util.JSONUtils;
import kd.epm.epbs.common.util.OlapManagerHelper;
import kd.epm.epbs.common.util.ThrowableHelper;
import org.apache.commons.collections4.CollectionUtils;

public class OlapOpLogHelper {
    private static final WatchLogger logger = EpbsLogFactory.getWatchLogInstance(OlapOpLogHelper.class);
    private static final String queryTransactionTraceInfo = "queryTransactionTraceInfo";
    private static final String queryTransactionCommandInfo = "queryTransactionCommandInfo";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OlapTraceResult queryTransactionTraceInfo(Long modelId, String cube, Map<String, String> comb, String deadlineTime, int pageSize, String nextToken) {
        OlapTraceResult olapTraceResult;
        logger.startWatch();
        try {
            PropertyBag bag = new PropertyBag();
            bag.set("cellKey", JSONObject.toJSON(comb).toString());
            bag.set("deadlineTime", deadlineTime);
            bag.set("limit", String.valueOf(pageSize));
            bag.set("nextToken", nextToken);
            bag.set("measureName", "FMONEY");
            OlapConnection olapConn = OlapManagerHelper.getOlapConnection((String)cube, (Long)modelId);
            OlapCommand olapCommand = new OlapCommand(olapConn, (CommandInfo)new FunctionCommandInfo(queryTransactionTraceInfo, bag));
            PropertyBag result = olapCommand.executeFunction();
            String rows = result.get("history");
            JavaType javaType = JSONUtils.getMapper().getTypeFactory().constructParametricType(ArrayList.class, new Class[]{TransactionTraceInfo.class});
            List infoList = (List)JSONUtils.parse((String)rows, (JavaType)javaType);
            nextToken = result.get("nextToken");
            OlapTraceResult otc = new OlapTraceResult();
            otc.setInfoList(infoList);
            otc.setNextToken(nextToken);
            olapTraceResult = otc;
        }
        catch (Exception e) {
            OlapTraceResult olapTraceResult2;
            try {
                OlapTraceResult otc = new OlapTraceResult();
                otc.setError(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)10));
                olapTraceResult2 = otc;
            }
            catch (Throwable throwable) {
                logger.infoEnd(String.format("olap\u8017\u65f6, \u7ef4\u5ea6\u7ec4\u5408=%s", comb));
                throw throwable;
            }
            logger.infoEnd(String.format("olap\u8017\u65f6, \u7ef4\u5ea6\u7ec4\u5408=%s", comb));
            return olapTraceResult2;
        }
        logger.infoEnd(String.format("olap\u8017\u65f6, \u7ef4\u5ea6\u7ec4\u5408=%s", comb));
        return olapTraceResult;
    }

    public static String queryTransactionCommandInfo(String cube, String transactionId) {
        logger.startWatch();
        OlapConnection olapConn = OlapManagerHelper.getOlapConnection((String)cube);
        PropertyBag bag = new PropertyBag();
        bag.set("transactionIds", "[" + transactionId + "]");
        OlapCommand olapCommand = new OlapCommand(olapConn, (CommandInfo)new FunctionCommandInfo(queryTransactionCommandInfo, bag));
        PropertyBag result = olapCommand.executeFunction();
        String commands = result.get("commands");
        logger.infoEnd("olap\u8017\u65f6, transactionId=" + transactionId);
        JavaType javaType = JSONUtils.getMapper().getTypeFactory().constructParametricType(ArrayList.class, new Class[]{String.class});
        List commandList = (List)JSONUtils.parse((String)commands, (JavaType)javaType);
        return CollectionUtils.isEmpty((Collection)commandList) ? "" : (String)commandList.get(0);
    }

    public static boolean queryTraceError(OlapTraceResult res, IFormView formView) {
        if (res.getError() != null) {
            if (res.getError().contains("FuntionManager_200")) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5347\u7ea7\u591a\u7ef4\u5e93\u52308.8.4\u4ee5\u4e0a\uff0c\u624d\u652f\u6301\u8ffd\u6eaf\u529f\u80fd\u3002", (String)"OlapOpLogHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]));
            } else {
                formView.showTipNotification(res.getError());
            }
            return true;
        }
        return false;
    }
}

