/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.log.trace;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.CacheLoader;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.util.ThreadLocals;
import kd.epm.epbs.business.log.trace.OlapTraceLog;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import kd.epm.epbs.business.log.trace.TraceOpLog;
import kd.epm.epbs.business.log.trace.TraceOpLogService;
import kd.epm.epbs.common.util.RequestContextUtil;

public class OlapTraceLogCache
implements AutoCloseable {
    private static final Log logger = LogFactory.getLog(OlapTraceLogCache.class);
    private static final ThreadLocal<OlapTraceLogCache> logThreadLocals = ThreadLocals.create(OlapTraceLogCache::new);
    private final Map<Object, Object> map = new ConcurrentHashMap<Object, Object>();
    private final RequestContext ctx = RequestContext.get();

    public static OlapTraceLogCache current() {
        return logThreadLocals.get();
    }

    public static Object get(Object key) {
        return OlapTraceLogCache.current().map.get(key);
    }

    public static void put(Object key, Object value) {
        OlapTraceLogCache.current().map.put(key, value);
    }

    public static boolean exists(Object key) {
        return OlapTraceLogCache.current().map.containsKey(key);
    }

    @Override
    public void close() throws Exception {
        this.saveBeforeDestoryCache();
    }

    public static <T> T get(Object key, CacheLoader<T> loader) {
        return OlapTraceLogCache.get(key, loader, true);
    }

    public static <T> T get(Object key, CacheLoader<T> loader, boolean putToCache) {
        Object value = OlapTraceLogCache.current().map.get(key);
        if (value == null && (value = loader.load()) != null && putToCache) {
            OlapTraceLogCache.put(key, value);
        }
        return (T)value;
    }

    public static void remove(Object key) {
        OlapTraceLogCache.current().map.remove(key);
    }

    private void saveBeforeDestoryCache() {
        TraceOpLog log = new TraceOpLog();
        log.setUsername(this.ctx.getUserName());
        log.setTraceid(this.ctx.getTraceId());
        log.setUserid(this.ctx.getCurrUserId());
        boolean hasOp = this.map.containsKey(OlapTraceServiceHelper.getOpCacheKey(this.ctx));
        if (hasOp) {
            TraceOpLog info = (TraceOpLog)this.map.get(OlapTraceServiceHelper.getOpCacheKey(this.ctx));
            log.setOpname(info.getOpname());
            log.setOpdesc(info.getOpdesc());
            log.setOpdate(info.getOpdate());
        } else {
            OperationContext op = OperationContext.get();
            if (op != null) {
                log.setOpname(op.getOpMethod());
                log.setOpdesc(op.getFormId() + " " + op.getFormName() + " " + op.getOpKey());
            }
        }
        if (this.map.containsKey(OlapTraceServiceHelper.getOlapCacheKey(this.ctx))) {
            OlapTraceLog traceLog = (OlapTraceLog)this.map.get(OlapTraceServiceHelper.getOlapCacheKey(this.ctx));
            if (!hasOp) {
                log.setDetail(traceLog.getThreadTrace());
            }
            if (StringUtils.isEmpty((String)log.getOpdesc())) {
                log.setOpdate(TimeServiceHelper.now());
            }
            log.setUniqueid(traceLog.getUniqueId());
            log.setExtinfo(traceLog.getExtInfo());
            OlapTraceLog traceOpInfo = (OlapTraceLog)this.map.get(OlapTraceServiceHelper.getOlapOpInfoCacheKey(this.ctx));
            if (null != traceOpInfo && null != traceOpInfo.getOlapOpInfo().getOpType()) {
                log.setOptype(traceOpInfo.getOlapOpInfo().getOpType().getCode());
            }
            if (null != traceOpInfo && null != traceOpInfo.getOlapOpInfo().getOpTarget()) {
                log.setOptarget(traceOpInfo.getOlapOpInfo().getOpTarget().getCode());
            }
            if (null != traceOpInfo) {
                log.setOptargetnum(traceOpInfo.getOlapOpInfo().getOpTargetNum());
            }
            RequestContextUtil.runWithCtx((RequestContext)this.ctx, c -> {
                try {
                    TraceOpLogService.getInstance().saveTraceOpLog(log);
                }
                catch (Exception e) {
                    logger.error("OlapTraceLog save error", (Throwable)e);
                }
            });
        }
    }
}

