/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.log.trace;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.log.api.AppLogInfo;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.log.IOlapOpTarget;
import kd.epm.epbs.business.log.IOlapOpType;
import kd.epm.epbs.business.log.trace.OlapOpInfo;
import kd.epm.epbs.business.log.trace.OlapTraceLog;
import kd.epm.epbs.business.log.trace.OlapTraceLogCache;
import kd.epm.epbs.business.log.trace.TraceOpLog;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.epm.epbs.common.apitest.ApiTest;
import kd.epm.epbs.common.apitest.ApiTestMethod;
import kd.epm.epbs.common.apitest.ApiTestParam;
import kd.epm.epbs.common.apitest.enums.ApiTestFeatureEnum;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.OperationLogUtil;
import org.apache.commons.collections4.CollectionUtils;

@ApiTest(value="\u591a\u7ef4\u8ffd\u6eaf\u65e5\u5fd7\u63a5\u53e3", feature=ApiTestFeatureEnum.LOG)
public class OlapTraceServiceHelper {
    public static final String TraceOlapCache = "toc";
    public static final String TraceOpCache = "topc";
    public static final String TraceId = "traceId";
    public static final String ComCommand = "00000000";
    public static final String RuleId = "ruleid";
    public static final String Uniqueid = "uniqueid";
    public static final String TraceOlapOpInfoCache = "tooic";

    @ApiTestMethod(value="\u7f13\u5b58\u64cd\u4f5c\u7c7b\u578b\u7b49\u4fe1\u606f\uff08\u64cd\u4f5c\u3001\u64cd\u4f5c\u5bf9\u8c61\u3001\u64cd\u4f5c\u5bf9\u8c61\u8bb0\u5f55\u7f16\u7801\uff09", test=false)
    public static void setTraceOpInfo(@ApiTestParam(value="\u64cd\u4f5c") IOlapOpType opType, @ApiTestParam(value="\u64cd\u4f5c\u5bf9\u8c61") IOlapOpTarget opTarget, @ApiTestParam(value="\u64cd\u4f5c\u5bf9\u8c61\u8bb0\u5f55\u7f16\u7801") String opTargetNum) {
        String key = OlapTraceServiceHelper.getOlapOpInfoCacheKey(RequestContext.get());
        if (!OlapTraceLogCache.exists(key)) {
            OlapTraceLogCache.put(key, new OlapTraceLog(opType, opTarget, opTargetNum));
        } else {
            OlapTraceLog traceLog = (OlapTraceLog)OlapTraceLogCache.get(key);
            if (null != traceLog.getOlapOpInfo()) {
                if (null != opType) {
                    traceLog.getOlapOpInfo().setOpType(opType);
                }
                if (null != opTarget) {
                    traceLog.getOlapOpInfo().setOpTarget(opTarget);
                }
                if (StringUtils.isNotEmpty((String)opTargetNum)) {
                    traceLog.getOlapOpInfo().setOpTargetNum(opTargetNum);
                }
            } else {
                traceLog.setOlapOpInfo(new OlapOpInfo(opType, opTarget, opTargetNum));
            }
        }
    }

    @ApiTestMethod(value="\u7f13\u5b58\u64cd\u4f5c\u7c7b\u578b\u7b49\u4fe1\u606f\uff08\u64cd\u4f5c\u3001\u64cd\u4f5c\u5bf9\u8c61\uff09", test=false)
    public static void setTraceOpInfo(@ApiTestParam(value="\u64cd\u4f5c") IOlapOpType opType, @ApiTestParam(value="\u64cd\u4f5c\u5bf9\u8c61") IOlapOpTarget opTarget) {
        OlapTraceServiceHelper.setTraceOpInfo(opType, opTarget, null);
    }

    @ApiTestMethod(value="\u7f13\u5b58\u64cd\u4f5c\u7c7b\u578b\u7b49\u4fe1\u606f\uff08\u64cd\u4f5c\u5bf9\u8c61\u8bb0\u5f55\u7f16\u7801\uff09", test=false)
    public static void setTraceOpInfo(@ApiTestParam(value="\u64cd\u4f5c\u5bf9\u8c61\u8bb0\u5f55\u7f16\u7801") String opTargetNum) {
        OlapTraceServiceHelper.setTraceOpInfo(null, null, opTargetNum);
    }

    @ApiTestMethod(value="\u7f13\u5b58\u8ffd\u6eaf\u65e5\u5fd7\u552f\u4e00\u6807\u8bc6", test=false)
    public static void setTraceLog(@ApiTestParam(value="\u65e5\u5fd7\u552f\u4e00\u6807\u8bc6") Long uniqueId, @ApiTestParam(value="\u65e5\u5fd7\u4e1a\u52a1\u6269\u5c55\u4fe1\u606f") String extInfo) {
        OlapTraceLog traceLog = new OlapTraceLog();
        traceLog.setUniqueId(uniqueId);
        traceLog.setExtInfo(extInfo);
        traceLog.setThreadTrace(OlapTraceServiceHelper.getThreadTrace());
        OlapTraceServiceHelper.cacheOlapTraceLog(traceLog);
    }

    @ApiTestMethod(value="\u7f13\u5b58\u754c\u9762\u64cd\u4f5c\u65e5\u5fd7\u96c6\u5408", test=false)
    public static void setTraceLog(@ApiTestParam(value="\u64cd\u4f5c\u65e5\u5fd7\u96c6\u5408") List<AppLogInfo> applogInfos) {
        if (CollectionUtils.isEmpty(applogInfos)) {
            return;
        }
        applogInfos.forEach(e -> OlapTraceServiceHelper.setTraceLog(e));
    }

    @ApiTestMethod(value="\u7f13\u5b58\u754c\u9762\u64cd\u4f5c\u65e5\u5fd7", test=false)
    public static void setTraceLog(@ApiTestParam(value="\u64cd\u4f5c\u65e5\u5fd7") AppLogInfo applogInfo) {
        if (null == applogInfo) {
            return;
        }
        String key = OlapTraceServiceHelper.getOpCacheKey(RequestContext.get());
        TraceOpLog log = new TraceOpLog();
        if (OlapTraceLogCache.exists(key)) {
            TraceOpLog info = (TraceOpLog)OlapTraceLogCache.get(key);
            info.setOpdesc(info.getOpdesc() + ";" + applogInfo.getOpName());
            log = info;
        } else {
            String opDescription = OperationLogUtil.getOpDescription((AppLogInfo)applogInfo);
            log.setOpname(applogInfo.getOpName());
            log.setOpdesc(opDescription);
            log.setOpdate(applogInfo.getOpTime());
        }
        OlapTraceLogCache.put(key, log);
    }

    private static void cacheOlapTraceLog(OlapTraceLog traceLog) {
        String key = OlapTraceServiceHelper.getOlapCacheKey(RequestContext.get());
        if (!OlapTraceLogCache.exists(key)) {
            if (null == traceLog) {
                traceLog = new OlapTraceLog();
            }
            if (IDUtils.isNull((Long)traceLog.getUniqueId())) {
                traceLog.setUniqueId(TraceIdUtil.hexToId((String)RequestContext.get().getTraceId()));
            }
            OlapTraceLogCache.put(key, traceLog);
        }
    }

    static String getOlapCacheKey(RequestContext ctx) {
        return TraceOlapCache + ctx.getTraceId();
    }

    static String getOpCacheKey(RequestContext ctx) {
        return TraceOpCache + ctx.getTraceId();
    }

    static String getOlapOpInfoCacheKey(RequestContext ctx) {
        return TraceOlapOpInfoCache + ctx.getTraceId();
    }

    private static String getThreadTrace() {
        StringBuilder traceInfo = new StringBuilder(500);
        StackTraceElement[] lvStacks = Thread.currentThread().getStackTrace();
        String appPackagePath = "";
        int size = lvStacks.length;
        for (int i = 2; i < size; ++i) {
            String msg = lvStacks[i].toString();
            if (msg.contains(OlapTraceServiceHelper.class.getSimpleName())) continue;
            if (StringUtils.isEmpty((String)appPackagePath)) {
                appPackagePath = msg.substring(0, msg.indexOf(".", 3) + 1);
            }
            if (!msg.contains(appPackagePath)) continue;
            String[] ss = msg.split("\\.");
            msg = ss[ss.length - 2] + "." + ss[ss.length - 1];
            traceInfo.append(i == 0 ? msg : "  " + msg);
            if (i < size - 1) {
                traceInfo.append("\n");
            }
            if (traceInfo.length() > 500) break;
        }
        return traceInfo.toString();
    }

    @ApiTestMethod(value="\u8ffd\u6eaf\u65e5\u5fd7\u662f\u5426\u5f00\u542f\uff08\u53c2\u6570\uff1aP004\uff09")
    public static boolean isTrace() {
        return ParamSettingServiceHelper.getBoolean(0L, "P004");
    }

    public static OlapOpInfo getOlapOpInfo() {
        OlapTraceLog traceOpInfo = (OlapTraceLog)OlapTraceLogCache.get(OlapTraceServiceHelper.getOlapOpInfoCacheKey(RequestContext.get()));
        return null != traceOpInfo ? traceOpInfo.getOlapOpInfo() : null;
    }
}

