/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.log.trace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.log.olap.TransactionTraceInfo;
import kd.epm.epbs.business.log.trace.TraceOpLog;
import org.apache.commons.collections4.CollectionUtils;

public class TraceOpLogService {
    private static final Log log = LogFactory.getLog(TraceOpLogService.class);
    protected static final String DETAIL_FIELDS = "uniqueid,username,optype,optarget,optargetnum,opname,opdesc,detail,opdate,traceid,extinfo";
    protected static final TraceOpLog EMPTY_LOG = new TraceOpLog();

    public static TraceOpLogService getInstance() {
        return InnerClass.instance;
    }

    public void fillTracemsg(List<TransactionTraceInfo> tis, List<Long> userDojs, String transactiontype) {
        Set<Long> uniqueIds = tis.stream().map(e -> this.convertUniqueid(e.getTraceId())).collect(Collectors.toSet());
        boolean isFilter = false;
        if (CollectionUtils.isNotEmpty(userDojs) || StringUtils.isNotEmpty((String)transactiontype)) {
            isFilter = true;
        }
        Map<Long, DynamicObject> dyns = this.queryTraceOpLog(uniqueIds, userDojs, transactiontype);
        if (isFilter && dyns.isEmpty()) {
            tis.clear();
            return;
        }
        if (isFilter) {
            tis.removeIf(e -> !dyns.containsKey(this.convertUniqueid(e.getTraceId())));
        }
        for (TransactionTraceInfo tti : tis) {
            DynamicObject trace = dyns.get(this.convertUniqueid(tti.getTraceId()));
            if (null == trace) {
                tti.setOpLog(EMPTY_LOG);
                continue;
            }
            tti.setOpLog(this.buildTraceOpLog(trace));
        }
    }

    public Long convertUniqueid(Long traceId) {
        return traceId;
    }

    public TraceOpLog buildTraceOpLog(DynamicObject trace) {
        TraceOpLog log = new TraceOpLog();
        log.setUsername(trace.getString("username"));
        log.setOptype(trace.getString("optype"));
        log.setOptarget(trace.getString("optarget"));
        log.setOptargetnum(trace.getString("optargetnum"));
        return log;
    }

    public Map<Long, DynamicObject> queryTraceOpLog(Collection<Long> uniqueIds, Collection<Long> userIds, String opType) {
        if (CollectionUtils.isEmpty(uniqueIds)) {
            return Collections.emptyMap();
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(4);
        List uniqueIds_1 = uniqueIds.stream().filter(e -> this.isInteger((Long)e)).collect(Collectors.toList());
        List uniqueIds_2 = uniqueIds.stream().filter(e -> !this.isInteger((Long)e)).collect(Collectors.toList());
        QFilter qFilter_1 = null;
        if (CollectionUtils.isNotEmpty(uniqueIds_1)) {
            qFilter_1 = new QFilter("uniqueid", "in", uniqueIds_1);
        }
        if (CollectionUtils.isNotEmpty(uniqueIds_2)) {
            QFilter qFilter_2 = new QFilter("uniqueid", "in", uniqueIds_2);
            if (null != qFilter_1) {
                qFilter_1.or(qFilter_2);
            } else {
                qFilter_1 = qFilter_2;
            }
        }
        filterList.add(qFilter_1);
        if (CollectionUtils.isNotEmpty(userIds)) {
            List userIds_1 = userIds.stream().filter(e -> this.isInteger((Long)e)).collect(Collectors.toList());
            List userIds_2 = userIds.stream().filter(e -> !this.isInteger((Long)e)).collect(Collectors.toList());
            QFilter qFilter_user_1 = null;
            if (CollectionUtils.isNotEmpty(userIds_1)) {
                qFilter_user_1 = new QFilter("userid", "in", userIds_1);
            }
            if (CollectionUtils.isNotEmpty(userIds_2)) {
                QFilter qFilter_user_2 = new QFilter("userid", "in", userIds_2);
                if (null != qFilter_user_1) {
                    qFilter_user_1.or(qFilter_user_2);
                } else {
                    qFilter_user_1 = qFilter_user_2;
                }
            }
            filterList.add(qFilter_user_1);
        }
        if (StringUtils.isNotEmpty((String)opType)) {
            QFilter qFilter_opType = new QFilter("optype", "in", Arrays.stream(opType.split(",")).filter(e -> StringUtils.isNotEmpty((String)e)).collect(Collectors.toList()));
            filterList.add(qFilter_opType);
        }
        Map<Long, DynamicObject> dyns = this.logORMQuery("epbs_traceoplog", "traceid,uniqueid,username,optype,optarget,optargetnum", filterList.toArray(new QFilter[filterList.size()])).stream().collect(Collectors.toMap(e -> e.getLong("uniqueid"), e -> e, (k1, k2) -> k1));
        return dyns;
    }

    public DynamicObjectCollection queryTraceOpLogByTraceid(String traceid) {
        long uniqueid = this.convertUniqueid(TraceIdUtil.hexToId((String)traceid));
        DynamicObjectCollection doc = LogORM.create().query("epbs_traceoplog", DETAIL_FIELDS, this.getFilterByUniqueid(uniqueid).toArray(), 100, 0);
        return doc;
    }

    public QFilter getFilterByUniqueid(long uniqueid) {
        QFilter qFilter = new QFilter("uniqueid", "=", (Object)uniqueid);
        return qFilter;
    }

    public final void saveTraceOpLog(TraceOpLog logMsg) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"epbs_traceoplog");
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entityType);
        dynamicObject.set("username", (Object)logMsg.getUsername());
        dynamicObject.set("opname", (Object)logMsg.getOpname());
        dynamicObject.set("opdesc", (Object)logMsg.getOpdesc());
        dynamicObject.set("opdate", (Object)logMsg.getOpdate());
        dynamicObject.set("traceid", (Object)logMsg.getTraceid());
        dynamicObject.set("detail", (Object)logMsg.getDetail());
        dynamicObject.set("uniqueid", (Object)logMsg.getUniqueid());
        dynamicObject.set("userid", (Object)logMsg.getUserid());
        dynamicObject.set("optype", (Object)logMsg.getOptype());
        dynamicObject.set("optarget", (Object)logMsg.getOptarget());
        dynamicObject.set("optargetnum", (Object)logMsg.getOptargetnum());
        dynamicObject.set("extinfo", (Object)logMsg.getExtinfo());
        ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>();
        objects.add(dynamicObject);
        LogORM logORM = LogORM.create();
        logORM.insert(objects);
    }

    public List<DynamicObject> logORMQuery(String entityNumber, String selects, QFilter[] qFilters) {
        LogORM logORM = LogORM.create();
        int limit = 10000;
        int maxSize = 100000;
        int start = 0;
        int size = 0;
        List<DynamicObject> list = logORM.query(entityNumber, selects, qFilters, limit, start).stream().collect(Collectors.toList());
        size = list.size();
        while (size >= limit) {
            List tmp = logORM.query(entityNumber, selects, qFilters, limit, start += limit).stream().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(tmp)) {
                list.addAll(tmp);
            }
            size = tmp.size();
            if (list.size() < maxSize) continue;
            break;
        }
        return list;
    }

    protected boolean isInteger(Long value) {
        return value <= Integer.MAX_VALUE;
    }

    private static class InnerClass {
        private static TraceOpLogService instance = new TraceOpLogService();

        private InnerClass() {
        }
    }
}

