/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.member.f7;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.epm.epbs.business.member.f7.NewF7FuzzySearchListener;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.util.IDUtils;
import org.jetbrains.annotations.NotNull;

public abstract class NewF7Utils {
    private static final Log log = LogFactory.getLog(NewF7Utils.class);
    private static final String F7_LOOKUP_LIST = "getLookUpList";
    private static final String F7_SET_BY_ID = "setItemByIdFromClient";
    private static final String F7_SET_BY_NUM = "setItemByNumber";
    protected static final F7 F7 = new F7();
    protected static final F8 F8 = new F8();
    protected static final F8Float F8Float = new F8Float();

    public static void openF7(@NotNull BeforeF7SelectEvent evt, @NotNull AbstractMemberF7Parameter f7Param) {
        F7.open(evt, f7Param, null);
    }

    public static void openF7(@NotNull BeforeF7SelectEvent evt, @NotNull AbstractMemberF7Parameter f7Param, CloseCallBack closeCallBack) {
        F7.open(evt, f7Param, closeCallBack);
    }

    public static void openF7(@NotNull IFormView view, @NotNull AbstractMemberF7Parameter f7Param, @NotNull CloseCallBack closeCallBack) {
        F7.open(view, f7Param, closeCallBack);
    }

    public static void openF8(@NotNull BeforeF7SelectEvent evt, @NotNull AbstractMemberF7Parameter f7Param) {
        f7Param.initF8();
        F8.open(evt, f7Param, null);
    }

    public static void openF8(@NotNull IFormView view, @NotNull AbstractMemberF7Parameter f7Param, @NotNull CloseCallBack closeCallBack) {
        f7Param.initF8();
        f7Param.setFunctionType(1);
        F8.open(view, f7Param, closeCallBack);
    }

    public static void openF8Float(@NotNull IFormView view, @NotNull AbstractMemberF7Parameter f7Param, @NotNull CloseCallBack closeCallBack) {
        f7Param.initF8();
        f7Param.setFunctionType(1);
        F8Float.open(view, f7Param, closeCallBack);
    }

    private static void dealListShowParameter(@NotNull FormShowParameter showParameter, @NotNull AbstractMemberF7Parameter f7Param, CloseCallBack closeCallBack) {
        if (showParameter instanceof ListShowParameter) {
            NewF7Utils.dealSelectRows((ListShowParameter)showParameter, f7Param);
        }
        String _f7ParamStr = JSON.toJSONString((Object)f7Param);
        log.info("f7Parameter-" + _f7ParamStr);
        showParameter.setCustomParam("Member_F7_Param", (Object)_f7ParamStr);
        showParameter.setCustomParam("Member_F7_Param_ClassName", (Object)f7Param.getClass().getTypeName());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(false);
        if (showParameter instanceof ListShowParameter) {
            ((ListShowParameter)showParameter).setLookUp(true);
            ((ListShowParameter)showParameter).setShowUsed(false);
            ((ListShowParameter)showParameter).setShowApproved(false);
            ((ListShowParameter)showParameter).setMultiSelect(f7Param.isMultiSelect());
        }
        if (closeCallBack != null) {
            showParameter.setCloseCallBack(closeCallBack);
        }
        StyleCss css = new StyleCss();
        css.setWidth("1200px");
        css.setHeight("750px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
    }

    public static void dealListShowParameter(@NotNull FormShowParameter parameter) {
        parameter.setShowTitle(false);
        StyleCss css = new StyleCss();
        css.setWidth("1200px");
        css.setHeight("750px");
        parameter.getOpenStyle().setInlineStyleCss(css);
    }

    private static void dealSelectRows(ListShowParameter showParameter, AbstractMemberF7Parameter f7Param) {
        ListSelectedRowCollection selectedRows = showParameter.getListSelectedRowCollection();
        selectedRows.clear();
        ListSelectedRowCollection listSelectedRows = f7Param.selectedListRows();
        if (CollectionUtils.isNotEmpty((Collection)listSelectedRows)) {
            if (f7Param.isMultiSelect()) {
                selectedRows.addAll((Collection)listSelectedRows);
            } else {
                selectedRows.add((Object)listSelectedRows.get(0));
            }
        }
    }

    public static void dealSelectRows(ListShowParameter showParameter, BeforeF7SelectEvent event) {
        ListSelectedRowCollection selectedRows = showParameter.getListSelectedRowCollection();
        selectedRows.clear();
        if (event.getOriginalValue() instanceof DynamicObject) {
            DynamicObject _obj = (DynamicObject)event.getOriginalValue();
            selectedRows.add((Object)new ListSelectedRow((Object)_obj.getLong("id")));
        }
    }

    public static void cantSelectRoot(@NotNull List<QFilter> filters, @NotNull AbstractMemberF7Parameter f7Param) {
        if (!f7Param.isCanSelectRoot()) {
            filters.add(new QFilter("number", "!=", (Object)f7Param.getDimensionNumber()).or("level", ">", (Object)1));
        }
    }

    public static CloseCallBack closeCallBack(IFormPlugin plugin, String actionId) {
        return new CloseCallBack(plugin, actionId);
    }

    private static void loadFromBaseDataEdit(AbstractMemberF7Parameter f7Param, Object value) {
        if (f7Param == null || value == null) {
            return;
        }
        LinkedHashSet ids = Sets.newLinkedHashSet();
        if (value instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection _rows = (ListSelectedRowCollection)value;
            for (ListSelectedRow _row : _rows) {
                ids.add(IDUtils.toLong((Object)_row.getPrimaryKeyValue()));
            }
        } else if (value instanceof DynamicObject) {
            ids.add(((DynamicObject)value).getLong("id"));
        } else if (value instanceof DynamicObjectCollection) {
            DynamicObjectCollection _objs = (DynamicObjectCollection)value;
            for (DynamicObject _obj : _objs) {
                ids.add(_obj.getLong("fbasedataid_id"));
            }
        } else if (value instanceof Long) {
            ids.add((Long)value);
        }
        if (!ids.isEmpty()) {
            f7Param.setSelectIds((Set)ids);
        }
    }

    public static class F8Float
    extends F8 {
        @Override
        protected String getShowFormId(AbstractMemberF7Parameter f7Param) {
            return f7Param.getF8FloatFormId();
        }
    }

    public static class F8
    extends F7 {
        @Override
        protected FormShowParameter getShowParameter() {
            return new FormShowParameter();
        }

        @Override
        protected String getShowFormId(AbstractMemberF7Parameter f7Param) {
            return f7Param.getF8FormId();
        }
    }

    public static class F7 {
        public void open(@NotNull BeforeF7SelectEvent evt, @NotNull AbstractMemberF7Parameter f7Param) {
            this.open(evt, f7Param, null);
        }

        public void open(@NotNull BeforeF7SelectEvent evt, @NotNull AbstractMemberF7Parameter f7Param, CloseCallBack closeCallBack) {
            f7Param.check();
            if (evt.getSource() instanceof BasedataEdit) {
                BasedataEdit basedataEdit = (BasedataEdit)evt.getSource();
                NewF7Utils.loadFromBaseDataEdit(f7Param, evt.getOriginalValue());
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                showParameter.setFormId(this.getShowFormId(f7Param));
                NewF7Utils.dealListShowParameter((FormShowParameter)showParameter, f7Param, closeCallBack);
                List filters = showParameter.getListFilterParameter().getQFilters();
                filters.clear();
                filters.addAll(f7Param.listFilter().toList());
                if (basedataEdit.getSearchFilter() != null) {
                    filters.add(basedataEdit.getSearchFilter());
                }
                showParameter.getListFilterParameter().setOrderBy(f7Param.getOrderBy());
                if (NewF7Utils.F7_LOOKUP_LIST.equals(evt.getSourceMethod()) || NewF7Utils.F7_SET_BY_ID.equals(evt.getSourceMethod()) || NewF7Utils.F7_SET_BY_NUM.equals(evt.getSourceMethod())) {
                    if (f7Param.isView()) {
                        if (NewF7Utils.F7_LOOKUP_LIST.equals(evt.getSourceMethod())) {
                            filters.clear();
                            filters.add(new QFilter("id", "=", (Object)0L));
                            basedataEdit.addBasedataFuzzySearchListener((BasedataFuzzySearchListener)NewF7FuzzySearchListener.getInstance(f7Param));
                        } else {
                            DynamicObjectCollection query = QueryServiceHelper.query((String)f7Param.getEntityNumber(), (String)"memberid", (QFilter[])filters.toArray(new QFilter[0]), (String)f7Param.getOrderBy(), (int)100);
                            List memberIds = query.stream().map(d -> d.getLong("memberid")).collect(Collectors.toList());
                            if (memberIds.isEmpty()) {
                                memberIds.add(0L);
                            }
                            filters.clear();
                            filters.add(new QFilter("id", "in", memberIds));
                        }
                    } else {
                        NewF7Utils.cantSelectRoot(filters, f7Param);
                    }
                }
            }
        }

        public void open(@NotNull IFormView view, @NotNull AbstractMemberF7Parameter f7Param, @NotNull CloseCallBack closeCallBack) {
            f7Param.check();
            FormShowParameter showParameter = this.getShowParameter();
            String pageId = view.getPageId() + "_" + f7Param.getDimensionId() + "_" + DBServiceHelper.genStringId();
            showParameter.setPageId(pageId);
            NewF7Utils.dealListShowParameter(showParameter, f7Param, closeCallBack);
            showParameter.setFormId(this.getShowFormId(f7Param));
            if (showParameter instanceof ListShowParameter) {
                List filters = ((ListShowParameter)showParameter).getListFilterParameter().getQFilters();
                filters.clear();
                filters.addAll(f7Param.listFilter().toList());
                ((ListShowParameter)showParameter).getListFilterParameter().setOrderBy(f7Param.getOrderBy());
            }
            view.showForm(showParameter);
        }

        protected FormShowParameter getShowParameter() {
            return new ListShowParameter();
        }

        protected String getShowFormId(AbstractMemberF7Parameter f7Param) {
            return f7Param.getF7FormId();
        }
    }
}

