/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.model.bizmodel;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.olap.OlapServiceHelper;
import kd.epm.epbs.common.enums.model.BizModelAggoprtTypeEnum;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.common.model.bean.BizModelBean;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.thread.EpbsThreadPools;
import kd.epm.epbs.common.util.QFBuilder;

public class BizModelInitHelper {
    private static final Integer INTERVAL = 40000;
    protected static final WatchLogger logger = EpbsLogFactory.getWatchLogInstance(BizModelInitHelper.class);

    public static void initOLAPBase(long bizmodelId, EpbsModelCache modelCache) {
        long modelId = modelCache.getModel().getId();
        QFilter qf = new QFilter("id", "=", (Object)bizmodelId);
        DynamicObject modelDy = QueryServiceHelper.queryOne((String)modelCache.getMetaDataEntity("epbs_bizmodel"), (String)"cubenumber as number,number as shownumber, name,businessdomainid", (QFilter[])qf.toArray());
        String cube = modelDy.getString("number");
        if (!OlapServiceHelper.isExistCube(cube, modelId)) {
            OlapServiceHelper.createCubeSchemes(modelDy, modelId);
        }
        DynamicObject[] dimensions = BusinessDataServiceHelper.load((String)modelCache.getMetaDataEntity("epbs_dimmodelref"), (String)"dimension,dimviews.view,aggoprttype", (QFilter[])new QFilter("bizmodel.id", "=", (Object)bizmodelId).toArray());
        Arrays.stream(dimensions).forEach(dim -> BizModelInitHelper.syncDimAndmember(dim, modelCache, modelId, cube));
        OlapServiceHelper.syncDimensionShortNumber2Cube(modelCache.getMetaDataEntity("epbs_dimension"), cube, modelId);
    }

    public static void updateOLAPBase(long modelId, long dimId) {
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
        Map bizModelMap = modelCache.getBizModelMap();
        for (Map.Entry bizModelBeanEntry : bizModelMap.entrySet()) {
            BizModelBean bizModelBean = (BizModelBean)bizModelBeanEntry.getValue();
            Map dimMap = bizModelBean.getDimMap();
            if (!dimMap.containsKey(dimId)) continue;
            BizModelInitHelper.updateOLAPBase(modelCache, bizModelBean.getId(), dimId);
        }
    }

    public static void updateOLAPBase(EpbsModelCache modelCache, long bizmodelId, long dimId) {
        BizModelBean bizModelById;
        Map dimMap;
        long modelId = modelCache.getModel().getId();
        QFilter qf = new QFilter("id", "=", (Object)bizmodelId);
        DynamicObject modelDy = QueryServiceHelper.queryOne((String)modelCache.getMetaDataEntity("epbs_bizmodel"), (String)"cubenumber as number,number as shownumber, name,businessdomainid,enable", (QFilter[])qf.toArray());
        String cube = modelDy.getString("number");
        String enable = modelDy.getString("enable");
        if (!OlapServiceHelper.isExistCube(cube, modelId)) {
            return;
        }
        DimensionBean dimensionBean = modelCache.getDimensionById(dimId);
        if (dimensionBean != null) {
            boolean existDimension = OlapServiceHelper.isExistDimension(cube, modelId, dimensionBean.getNumber());
            if (!"1".equals(enable) && !existDimension) {
                return;
            }
        }
        if (!(dimMap = (bizModelById = modelCache.getBizModelById(bizmodelId)).getDimMap()).containsKey(dimId)) {
            return;
        }
        DynamicObject refDynamicObject = BusinessDataServiceHelper.loadSingle((String)modelCache.getMetaDataEntity("epbs_dimmodelref"), (String)"dimension,dimviews.view,aggoprttype", (QFilter[])new QFilter("bizmodel.id", "=", (Object)bizmodelId).and("dimension", "=", (Object)dimId).toArray());
        if (refDynamicObject != null) {
            BizModelInitHelper.syncDimAndmember(refDynamicObject, modelCache, modelId, cube);
        }
        OlapServiceHelper.syncDimensionShortNumber2Cube(modelCache.getMetaDataEntity("epbs_dimension"), cube, modelId);
    }

    private static void syncDimAndmember(DynamicObject dim, EpbsModelCache modelCache, long modelId, String cube) {
        int totalNumber = 0;
        String aggoprttype = dim.getString("aggoprttype");
        Long dimensionId = dim.getLong("dimension.id");
        String memberTreemodel = modelCache.getMemberTreeModelByDimensionId(dimensionId.longValue());
        List collect = dim.getDynamicObjectCollection("dimviews").stream().map(o -> o.get("view.id")).collect(Collectors.toList());
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("dimension.id", "=", (Object)dimensionId);
        qfBuilder.add("view", "in", collect);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)modelCache.getMetaDataEntity("epbs_dimension"), (String)"id,number,shortnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dimensionId)});
        DynamicObject totalObject = QueryServiceHelper.queryOne((String)modelCache.getMetaDataEntity(memberTreemodel), (String)"count(1) as totalNumber", (QFilter[])qfBuilder.toArray());
        if (!Objects.isNull(totalObject)) {
            totalNumber = totalObject.getInt("totalNumber");
        }
        if (totalNumber > INTERVAL) {
            int count = 1;
            if (totalNumber > INTERVAL) {
                count = totalNumber % INTERVAL > 0 ? totalNumber / INTERVAL + 1 : totalNumber / INTERVAL;
            }
            CountDownLatch latch = new CountDownLatch(count);
            for (int i = 0; i < count; ++i) {
                DynamicObject[] load;
                DynamicObject[] members = load = BusinessDataServiceHelper.load((String)modelCache.getMetaDataEntity(memberTreemodel), (String)"number,aggoprt,parent,parent.number,isleaf", (QFilter[])qfBuilder.toArray(), (String)"", (int)i, (int)INTERVAL);
                EpbsThreadPools.commonExecute(() -> {
                    try {
                        BizModelInitHelper.createMemberData(aggoprttype, dynamicObject, modelId, cube, members);
                    }
                    catch (Exception e) {
                        logger.error("BizModelInitHelper.syncDimAndmember execute  Interrupted", (Throwable)e);
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                logger.error("BizModelInitHelper.syncDimAndmember execute  Interrupted", (Throwable)e);
            }
        } else {
            DynamicObject[] members = BusinessDataServiceHelper.load((String)modelCache.getMetaDataEntity(memberTreemodel), (String)"number,aggoprt,parent,parent.number,isleaf", (QFilter[])qfBuilder.toArray(), (String)"", (int)0, (int)INTERVAL);
            BizModelInitHelper.createMemberData(aggoprttype, dynamicObject, modelId, cube, members);
        }
    }

    private static void createMemberData(String aggoprttype, DynamicObject dynamicObject, long modelId, String cube, DynamicObject[] members) {
        if (members.length > 0) {
            List<List<String>> list = Arrays.stream(members).map(x -> {
                int aggoprt = x.getInt("aggoprt");
                if (BizModelAggoprtTypeEnum.NONE.getValue().equals(aggoprttype)) {
                    aggoprt = 5;
                } else if (BizModelAggoprtTypeEnum.TOTAL.getValue().equals(aggoprttype)) {
                    aggoprt = 1;
                }
                return Arrays.asList(x.getString("number"), String.valueOf(aggoprt), x.getLong("parent.id") == 0L ? "" : x.getString("parent.number"), x.getString("isleaf"));
            }).collect(Collectors.toList());
            if (dynamicObject != null) {
                OlapServiceHelper.batchCreateDimensionSchemes(cube, dynamicObject.getString("number"), dynamicObject.getString("shortnumber"), list, modelId, aggoprttype);
            }
        }
    }

    public static void dropDimensionMember(long modelId, long bizmodelId, String dimNum, String memNum) {
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
        BizModelBean bizModelBean = modelCache.getBizModelById(bizmodelId);
        if (bizModelBean != null) {
            String cubeName = bizModelBean.getCube();
            OlapServiceHelper.dropDimensionMember(cubeName, dimNum, memNum, modelId);
        }
    }

    public static void batchDropDimensionMembers(long modelId, long bizmodelId, String dimNum, Collection<String> members) {
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
        BizModelBean bizModelBean = modelCache.getBizModelById(bizmodelId);
        if (bizModelBean != null) {
            String cubeName = bizModelBean.getCube();
            OlapServiceHelper.batchDropDimensionMembers(cubeName, dimNum, members, modelId);
        }
    }
}

