/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.model.bizmodel;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.model.bizmodel.muitlref.BizModelMuitlEnableRefHelper;
import kd.epm.epbs.business.model.bizmodel.muitlref.BizModelMuitlRefParam;
import kd.epm.epbs.business.model.bizmodel.muitlref.BizModelMuitlRefResult;
import kd.epm.epbs.business.olap.OlapServiceHelper;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.model.DimTypeEnum;
import kd.epm.epbs.common.model.bean.BaseBean;
import kd.epm.epbs.common.model.bean.BizModelBean;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.GZIPUtils;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.NumberRuleUtils;
import org.apache.commons.collections.CollectionUtils;

public class BizModelServiceHelper {
    public static final String PRIORITY_CACHE = "priority_cache";
    public static final String ID_CACHE = "id_cache";
    protected static final String DIM_CACHE_PREFIX = "dim&";
    protected static final String DIMTYPE_CACHE_PREFIX = "dimtype&";
    public static final List<String> excludeDimList = Arrays.asList(DimTypeEnum.Entity.getValue(), DimTypeEnum.Custom.getValue());
    public static final List<String> existCubeTypeList = Arrays.asList(DimTypeEnum.Version.getValue(), DimTypeEnum.Custom.getValue());
    public static final List<String> defaultDimainDimList = Arrays.asList(DimTypeEnum.Entity.getValue(), DimTypeEnum.Year.getValue(), DimTypeEnum.Period.getValue());

    public static void setPriorityValue(AbstractFormPlugin plugin, String value) {
        Object priorityvalue = plugin.getView().getModel().getValue(value);
        if (!ObjectUtils.isEmpty((Object)priorityvalue)) {
            LinkedHashSet<Object> cacheStrSet = new LinkedHashSet();
            if (StringUtils.isNotEmpty((CharSequence)priorityvalue.toString())) {
                cacheStrSet = new LinkedHashSet<String>(Arrays.asList(priorityvalue.toString().split(",")));
            }
            DynamicObjectCollection entryEntity = plugin.getView().getModel().getEntryEntity("dimlist");
            LinkedHashMap<String, List<String>> newSelectDatas = new LinkedHashMap<String, List<String>>();
            int i = 0;
            for (DynamicObject dim : entryEntity) {
                newSelectDatas.put(IDUtils.toString((Object)dim.get("id")), Arrays.asList(IDUtils.toString((Object)dim.get("id")), dim.get("dimname_l").toString(), i + "", null, "1"));
                ++i;
            }
            if (cacheStrSet.size() > 0) {
                if (cacheStrSet.size() > 0) {
                    LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize((int)cacheStrSet.size());
                    cacheStrSet.stream().forEach(c -> {
                        List list = (List)newSelectDatas.get(c);
                        if (list != null && list.size() > 0) {
                            result.put(c, newSelectDatas.get(c));
                        }
                    });
                    String resultData = SerializationUtils.serializeToBase64((Object)GZIPUtils.compress((String)JSON.toJSONString((Object)result)));
                    plugin.getView().getModel().setValue(value, (Object)String.join((CharSequence)",", result.keySet()));
                    plugin.getPageCache().put(PRIORITY_CACHE, resultData);
                }
            } else {
                plugin.getView().getModel().setValue(value, (Object)"");
                plugin.getPageCache().put(PRIORITY_CACHE, "");
            }
        } else {
            plugin.getView().getModel().setValue(value, (Object)"");
            plugin.getPageCache().put(PRIORITY_CACHE, "");
        }
    }

    public static void setPriorityText(AbstractFormPlugin plugin, String name, boolean needNumber) {
        LinkedHashMap selectDatas;
        String _cacheStr = plugin.getPageCache().get(PRIORITY_CACHE);
        if (StringUtils.isNotEmpty((CharSequence)_cacheStr)) {
            _cacheStr = GZIPUtils.uncompressToString((byte[])((byte[])SerializationUtils.deSerializeFromBase64((String)_cacheStr)));
            selectDatas = (LinkedHashMap)JSON.parseObject((String)_cacheStr, LinkedHashMap.class);
        } else {
            selectDatas = new LinkedHashMap();
        }
        StringBuilder builder = new StringBuilder();
        if (selectDatas.size() > 0) {
            int i = 1;
            for (Map.Entry entry : selectDatas.entrySet()) {
                List list = (List)entry.getValue();
                if (needNumber) {
                    builder.append(i).append(":").append((String)list.get(1));
                } else {
                    builder.append((String)list.get(1));
                }
                if (i < selectDatas.size()) {
                    builder.append(";");
                }
                ++i;
            }
        }
        plugin.getView().getModel().setValue(name, (Object)builder.toString());
    }

    public static String setStatus(boolean status, AbstractFormPlugin plugin, String bizModeEntity) {
        Long soucreId = 0L;
        OperationStatus statusData = plugin.getView().getFormShowParameter().getStatus();
        String id = plugin.getPageCache().get(ID_CACHE);
        if (statusData.equals((Object)OperationStatus.ADDNEW)) {
            if (StringUtils.isBlank((CharSequence)id)) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BizModelServiceHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]));
                return "";
            }
            soucreId = Long.parseLong(id);
        } else {
            Object customId = plugin.getView().getFormShowParameter().getCustomParam("id");
            soucreId = Long.parseLong(customId.toString());
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)soucreId, (String)bizModeEntity);
        String enable = "";
        if (dynamicObject != null) {
            dynamicObject.set("enable", (Object)(status ? "1" : "0"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            if (status) {
                plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"BizModelServiceHelper_2", (String)"epm-epbs-business", (Object[])new Object[0]));
            } else {
                plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"BizModelServiceHelper_3", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            enable = dynamicObject.getString("enable");
        }
        return enable;
    }

    public static void clearCubes(DynamicObject[] numbers, Long modelId) {
        for (DynamicObject obj : numbers) {
            String cubeName = obj.getString("cubenumber");
            if (!OlapServiceHelper.isExistCube(cubeName, modelId)) continue;
            OlapServiceHelper.dropCubeSchemes(cubeName, modelId);
        }
    }

    public static Map<String, List<DynamicObject>> getDimRef(long id, String appId, String refEntity) {
        return (Map)ThreadCache.get((Object)(appId + "_" + DIM_CACHE_PREFIX + id), () -> {
            Map<Object, Object> result = new HashMap(16);
            result = Arrays.stream(BusinessDataServiceHelper.load((String)refEntity, (String)"dimension,bizmodel,dimviews.view", (QFilter[])new QFilter("bizmodel.businessdomainid", "=", (Object)id).toArray(), (String)"dseq")).collect(Collectors.groupingBy(k -> k.getString("dimension.id"), Collectors.toList()));
            return result;
        });
    }

    public static Map<String, List<DynamicObject>> getDimTypeRef(long id, String appId, String refEntity, long modelId) {
        return (Map)ThreadCache.get((Object)(appId + "_" + DIMTYPE_CACHE_PREFIX + id), () -> {
            HashMap result = new HashMap(16);
            Map groupMap = Arrays.stream(BusinessDataServiceHelper.load((String)refEntity, (String)"dimension,bizmodel,dimviews.view", (QFilter[])new QFilter("bizmodel.businessdomainid", "=", (Object)id).and(new QFilter("sourcedim", "=", (Object)0L)).toArray(), (String)"dseq")).collect(Collectors.groupingBy(k -> k.get("dimension.id"), Collectors.toList()));
            EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
            if (groupMap.size() > 0) {
                for (Map.Entry entry : groupMap.entrySet()) {
                    DimTypeBean dimType = modelCache.getDimTypeByDimensionId(Long.parseLong(entry.getKey().toString()));
                    String type = dimType.getType();
                    ArrayList dynamicObjects = (ArrayList)result.get(type);
                    if (dynamicObjects == null) {
                        dynamicObjects = new ArrayList(16);
                    }
                    dynamicObjects.addAll(entry.getValue());
                    result.put(type, dynamicObjects);
                }
            }
            return result;
        });
    }

    public static String checkMuitlBizModelData(Long businessdomainid, long modelId, String dimId, Set<String> viewSet, String refEntity) {
        Map<String, List<DynamicObject>> dimRef;
        String str = "";
        String srcAppNum = ModelCacheHelper.getModel((long)modelId).getSrcAppNum();
        if (businessdomainid != 0L && (dimRef = BizModelServiceHelper.getDimRef(businessdomainid, srcAppNum, refEntity)).size() > 0) {
            EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
            DimTypeBean dimType = modelCache.getDimTypeByDimensionId(Long.parseLong(dimId));
            String type = dimType.getType();
            List<DynamicObject> dynamicObjects = dimRef.get(dimId);
            if (dynamicObjects == null || dynamicObjects.size() == 0) {
                return "";
            }
            String returnStr = BizModelServiceHelper.checkDimView(viewSet, dynamicObjects, type);
            if (!StringUtils.isBlank((CharSequence)returnStr)) {
                return returnStr;
            }
        }
        return str;
    }

    public static List<String> queryDimTypeByRemoveList(long modelId, List<String> removieList) {
        ArrayList reslist = Lists.newArrayListWithExpectedSize((int)16);
        if (modelId != 0L) {
            String srcAppNum = ModelCacheHelper.getModel((long)modelId).getSrcAppNum();
            QFilter qFilter2 = new QFilter("appnumber", "=", (Object)srcAppNum).and("status", "=", (Object)"1").and("type", "not in", excludeDimList);
            List allList = QueryServiceHelper.query((String)"epbs_dimtype", (String)"id,type", (QFilter[])qFilter2.toArray()).stream().map(c -> c.getString("type")).collect(Collectors.toList());
            reslist.addAll(allList);
            reslist.removeAll(removieList);
            reslist.addAll(excludeDimList);
        }
        return reslist;
    }

    public static String checkDimTypeData(Long businessdomainid, long modelId, String dimId, Set viewSet, String refEntity) {
        Map<String, List<DynamicObject>> dimTypeRef;
        String str = "";
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
        DimTypeBean dimType = modelCache.getDimTypeByDimensionId(Long.parseLong(dimId));
        String type = dimType.getType();
        if (excludeDimList.contains(type)) {
            return "";
        }
        String srcAppNum = ModelCacheHelper.getModel((long)modelId).getSrcAppNum();
        if (businessdomainid != 0L && (dimTypeRef = BizModelServiceHelper.getDimTypeRef(businessdomainid, srcAppNum, refEntity, modelId)).size() > 0) {
            Object keySet;
            List list;
            String dimtypeName = dimType.getNameString();
            List<DynamicObject> dynamicObjects = dimTypeRef.get(type);
            if (dynamicObjects == null || dynamicObjects.size() == 0) {
                return "";
            }
            Map collect = dynamicObjects.stream().collect(Collectors.groupingBy(k -> k.getString("dimension.id"), Collectors.toList()));
            boolean flag = true;
            if (collect.size() == 0 && (list = (keySet = collect.keySet()).stream().filter(c -> dimId.equals(c)).collect(Collectors.toList())).size() > 0) {
                flag = false;
            }
            if (collect.size() > 1 || flag) {
                for (Map.Entry entry : collect.entrySet()) {
                    List value;
                    String key = (String)entry.getKey();
                    if (key.equals(dimId) || (value = (List)entry.getValue()).size() <= 0) continue;
                    for (int s = 0; s < value.size(); ++s) {
                        DynamicObject bizModelData = (DynamicObject)value.get(s);
                        if (bizModelData == null) continue;
                        String name = bizModelData.getString("bizmodel.name");
                        String dimName = bizModelData.getString("dimension.name");
                        str = String.format(ResManager.loadKDString((String)"\u591a\u7ef4\u6a21\u578b\u201c%1$s\u201d\u5df2\u7ecf\u5b58\u5728%2$s\u7c7b\u578b\u7ef4\u5ea6\u201c%3$s\u201d\uff0c\u540c\u4e00\u4e2a\u591a\u7ef4\u6a21\u578b\u4e0d\u5141\u8bb8\u5b58\u5728\u591a\u4e2a%4$s\u7c7b\u578b\u7684\u7ef4\u5ea6\uff0c\u589e\u52a0\u201c%5$s\u201d\u7ef4\u5ea6\u5931\u8d25\u3002", (String)"BizModelServiceHelper_4", (String)"epm-epbs-business", (Object[])new Object[0]), name, dimtypeName, dimName, dimtypeName, dimtypeName);
                        return str;
                    }
                }
            } else {
                String returnStr = BizModelServiceHelper.checkDimView(viewSet, dynamicObjects, type);
                if (!StringUtils.isBlank((CharSequence)returnStr)) {
                    return returnStr;
                }
            }
        }
        return str;
    }

    public static String checkDimTypeData(Long businessdomainid, long modelId, String refEntity, long dimTypeId) {
        Map<String, List<DynamicObject>> dimTypeRef;
        String str = "";
        String dimtypeName = "";
        String type = "";
        DynamicObject data = QueryServiceHelper.queryOne((String)"epbs_dimtype", (String)"id,name,type", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dimTypeId)});
        if (data == null) {
            return str;
        }
        dimtypeName = data.getString("name");
        type = data.getString("type");
        if (excludeDimList.contains(type)) {
            return str;
        }
        String srcAppNum = ModelCacheHelper.getModel((long)modelId).getSrcAppNum();
        if (businessdomainid != 0L && (dimTypeRef = BizModelServiceHelper.getDimTypeRef(businessdomainid, srcAppNum, refEntity, modelId)).size() > 0) {
            List<DynamicObject> dynamicObjects = dimTypeRef.get(type);
            if (dynamicObjects == null || dynamicObjects.size() == 0) {
                return "";
            }
            Map collect = dynamicObjects.stream().collect(Collectors.groupingBy(k -> k.getString("dimension.id"), Collectors.toList()));
            for (Map.Entry entry : collect.entrySet()) {
                List value = entry.getValue();
                if (value.size() <= 0) continue;
                for (int s = 0; s < value.size(); ++s) {
                    DynamicObject bizModelData = (DynamicObject)value.get(s);
                    if (bizModelData == null) continue;
                    String name = bizModelData.getString("bizmodel.name");
                    String dimName = bizModelData.getString("dimension.name");
                    str = String.format(ResManager.loadKDString((String)"\u591a\u7ef4\u6a21\u578b\u201c%1$s\u201d\u5df2\u7ecf\u5b58\u5728%2$s\u7c7b\u578b\u7ef4\u5ea6\u201c%3$s\u201d\uff0c\u540c\u4e00\u4e2a\u591a\u7ef4\u6a21\u578b\u4e0d\u5141\u8bb8\u5b58\u5728\u591a\u4e2a%4$s\u7c7b\u578b\u7684\u7ef4\u5ea6\uff0c\u589e\u52a0\u201c%5$s\u201d\u7ef4\u5ea6\u5931\u8d25\u3002", (String)"BizModelServiceHelper_4", (String)"epm-epbs-business", (Object[])new Object[0]), name, dimtypeName, dimName, dimtypeName, dimtypeName);
                    return str;
                }
            }
        }
        return str;
    }

    public static String checkDimView(Set viewSet, List<DynamicObject> dynamicObjects, String type) {
        String str = "";
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                DynamicObject dynamicObject = dynamicObjects.get(i);
                Set dimviewsSet = dynamicObject.getDynamicObjectCollection("dimviews").stream().map(o -> o.getString("view.id")).collect(Collectors.toSet());
                boolean contains = viewSet.containsAll(dimviewsSet);
                boolean flag = false;
                if (!DimTypeEnum.Period.getValue().equals(type)) {
                    // empty if block
                }
                if (contains && !flag) continue;
                String name = dynamicObject.getString("bizmodel.name");
                String dimName = dynamicObject.getString("dimension.name");
                Set dimviewsNameSet = dynamicObject.getDynamicObjectCollection("dimviews").stream().map(o -> o.getString("view.name")).collect(Collectors.toSet());
                String viewNameStr = String.join((CharSequence)"\u3001", dimviewsNameSet);
                str = String.format(ResManager.loadKDString((String)"\u591a\u7ef4\u6a21\u578b\u201c%1$s\u201d\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u4e0d\u540c\u89c6\u56fe\u201c%2$s\u201d\uff0c\u540c\u4e00\u4e2a\u591a\u7ef4\u6a21\u578b\u4e0d\u5141\u8bb8\u5b58\u5728\u540c\u4e00\u4e2a\u7ef4\u5ea6\u4e0d\u540c\u89c6\u56fe\uff0c\u589e\u52a0\u201c%3$s\u201d\u7ef4\u5ea6\u5931\u8d25\u3002", (String)"BizModelServiceHelper_5", (String)"epm-epbs-business", (Object[])new Object[0]), name, viewNameStr, dimName);
                return str;
            }
        }
        return str;
    }

    public static String checkRelationNumber(Long businessdomainid, String refEntity, String dimEntity, long dimId) {
        String str = "";
        DynamicObject dimData = QueryServiceHelper.queryOne((String)dimEntity, (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dimId)});
        if (dimData != null) {
            String number = dimData.getString("number");
            DynamicObject data = QueryServiceHelper.queryOne((String)refEntity, (String)"id,bizmodel.name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number).and(new QFilter("bizmodel.businessdomainid", "=", (Object)businessdomainid)).and(new QFilter("businessdomainid", "!=", (Object)businessdomainid))});
            if (data != null) {
                String name = data.getString("bizmodel.name");
                str = String.format(ResManager.loadKDString((String)"\u5173\u7cfb\u6a21\u578b\u201c%1$s\u201d\u5df2\u7ecf\u5b58\u5728\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u7ef4\u5ea6\uff0c\u589e\u52a0\u201c%3$s\u201d\u7ef4\u5ea6\u5931\u8d25\u3002", (String)"BizModelServiceHelper_6", (String)"epm-epbs-business", (Object[])new Object[0]), name, number, number);
            }
        }
        return str;
    }

    public static boolean checkNumber(String number) {
        String regEx = "^(?!_)[A-Za-z0-9_.-]{3,50}$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        return matcher.matches() && !number.startsWith(".") && !number.startsWith("_") && !number.contains("..") && NumberRuleUtils.checkKeyWords((String)number);
    }

    public static String getMessage() {
        return ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u5e94\u4e3a3\u523050\u4e2a\u5b57\u7b26\uff0c\u4ec5\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u5b57\u6bcd\u3001\u70b9\u53f7\u548c\u6a2a\u7ebf\u3002\u7f16\u7801\u4e0d\u80fd\u4ee5\u70b9\u53f7\u6216\u6a2a\u7ebf\u5f00\u5934\uff0c\u4e14\u70b9\u53f7\u4e0d\u80fd\u8fde\u7eed\u3002\u8bf7\u907f\u514d\u4f7f\u7528\u4fdd\u7559\u5b57\u6bb5\uff1aall\u3001other\u3001none\u3002", (String)"BizModelServiceHelper_7", (String)"epm-epbs-business", (Object[])new Object[0]);
    }

    public static boolean isExistCube(Object cubenumber, Long businessdomainid, long modelId, String entryName) {
        DynamicObject[] cubenumbers;
        boolean existCube = false;
        if (!ObjectUtils.isEmpty((Object)cubenumber)) {
            existCube = OlapServiceHelper.isExistCube(cubenumber.toString(), modelId);
        }
        if (businessdomainid != 0L && (cubenumbers = BusinessDataServiceHelper.load((String)entryName, (String)"cubenumber", (QFilter[])new QFilter("businessdomainid", "=", (Object)businessdomainid).and("type", "=", (Object)"1").toArray())) != null && cubenumbers.length > 0) {
            DynamicObject dynamicObject;
            for (int i = 0; i < cubenumbers.length && (ObjectUtils.isEmpty((Object)(cubenumber = (dynamicObject = cubenumbers[i]).get("cubenumber"))) || !(existCube = OlapServiceHelper.isExistCube(cubenumber.toString(), modelId))); ++i) {
            }
        }
        return existCube;
    }

    public static String checkExistCubeTypeList(long dimTypeId, long dimId, long modelId) {
        QFilter qFilter;
        DynamicObject dynamicObject;
        String str = "";
        String dimtype = "";
        if (dimTypeId != 0L && (dynamicObject = QueryServiceHelper.queryOne((String)"epbs_dimtype", (String)"type", (QFilter[])(qFilter = new QFilter("id", "=", (Object)dimTypeId)).toArray())) != null) {
            dimtype = dynamicObject.getString("type");
        }
        if (dimId != 0L) {
            EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
            DimTypeBean dimType = modelCache.getDimTypeByDimensionId(dimId);
            dimtype = dimType.getType();
        }
        if (!"".equals(dimtype) && !existCubeTypeList.contains(dimtype)) {
            str = ResManager.loadKDString((String)"\u591a\u7ef4\u6a21\u578b\u542f\u7528\u540e\uff0c\u4e1a\u52a1\u6a21\u578b\u548c\u591a\u7ef4\u6a21\u578b\uff0c\u53ea\u80fd\u52a0\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u548c\u7248\u672c\u7ef4\u5ea6\uff0c\u6210\u5458\u90fd\u662f\u9ed8\u8ba4\u4e3a\u201c\u4e0d\u533a\u5206\u6210\u5458\u201d\u3002", (String)"BizModelServiceHelper_8", (String)"epm-epbs-business", (Object[])new Object[0]);
        }
        return str;
    }

    public static void setDimAndMember(EpbsModelCache modelCache, Long bizModelId, Long dimId, Long viewId, Long modelId, Map<BaseBean, Tuple<Long, Long>> dimAndMember) {
        DimTypeBean dimTypeBean = modelCache.getDimTypeByDimensionId(dimId.longValue());
        if (dimTypeBean == null) {
            return;
        }
        String dimType = dimTypeBean.getType();
        if (existCubeTypeList.contains(dimType)) {
            DimensionBean dimensionBean = modelCache.getDimensionById(dimId.longValue());
            MemberBean defaultMember = modelCache.getDefaultMember(bizModelId, dimId, viewId);
            if (defaultMember != null) {
                Tuple node = Tuple.create((Object)defaultMember.getId(), (Object)defaultMember.getViewId());
                dimAndMember.put((BaseBean)dimensionBean, (Tuple<Long, Long>)node);
            }
        }
    }

    public static void executeBizModelMuitlEnable(Long modelId, Long bizModelId, BizModelMuitlRefParam params) {
        BizModelMuitlRefResult result = BizModelMuitlEnableRefHelper.getInstance(modelId, bizModelId).execute(params);
        if (!result.isResult()) {
            String errorMsg = result.getErrorMsg();
            if (StringUtils.isBlank((CharSequence)errorMsg)) {
                errorMsg = ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\u3002", (String)"BizModelServiceHelper_9", (String)"epm-epbs-business", (Object[])new Object[0]);
            }
            throw new KDBizException(errorMsg);
        }
    }

    public static void creteBizModelMuitlRefParam(EpbsModelCache modelCache, Long id, BizModelMuitlRefParam params) {
        Map dimMap;
        BizModelBean bizModelBean;
        HashMap dimIdAndViewIdMap = Maps.newHashMapWithExpectedSize((int)7);
        if (modelCache != null && (bizModelBean = modelCache.getBizModelById(id.longValue())) != null && (dimMap = bizModelBean.getDimMap()).size() > 0) {
            dimMap.forEach((k, v) -> {
                List viewIds = v.getViewIds();
                if (CollectionUtils.isNotEmpty((Collection)viewIds)) {
                    dimIdAndViewIdMap.put(k, viewIds.get(0));
                }
            });
        }
        params.setDimIdAndViewIdMap(dimIdAndViewIdMap);
    }
}

