/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.model.bizmodel.er;

import com.alibaba.fastjson.JSON;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.epm.epbs.business.bd.manage.BaseDataDivisionService;
import kd.epm.epbs.business.model.bizmodel.er.ModelErResponse;
import kd.epm.epbs.business.mservice.DataModelMsErHelper;
import kd.epm.epbs.business.mservice.EPDMDataResponse;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.BizModelErTypeEnum;
import kd.epm.epbs.common.enums.ErModelErrorEnum;
import kd.epm.epbs.common.enums.ErTableColEnum;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.common.model.bean.relation.RelationTypeEnum;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.thread.EpbsThreadPools;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class BizModelErInitHelper {
    private static final Log LOG = LogFactory.getLog(BizModelErInitHelper.class);
    private static final String TABLE_TMP = "t_%s_er_%s%d";
    private static final String ER_TYPE = "DataModel.Table";
    private static final String CREATE_COL_OTHER_TYPE = "Other";
    private static final String TABLE_CATALOG = "8160846473567851881";
    private static final String TABLE_STATUS = "2";
    protected static final WatchLogger logger = EpbsLogFactory.getWatchLogInstance(BaseDataDivisionService.class);

    public static ModelErResponse initErBase(long bizmodelId, long modelId, String formId) {
        ModelErResponse modelErResponse = new ModelErResponse();
        String appNum = ModelCacheHelper.getModel((long)modelId).getSrcAppNum().toLowerCase(Locale.ENGLISH);
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
        QFilter qf = new QFilter("id", "=", (Object)bizmodelId);
        DynamicObject modelDy = QueryServiceHelper.queryOne((String)modelCache.getMetaDataEntity("epbs_bizmodel"), (String)"cubenumber,number,name,model,model.shownumber,model.name,businessdomainid,businessdomainid.number,businessdomainid.name,datamodelid", (QFilter[])qf.toArray());
        String tbName = modelDy.getString("cubenumber");
        DynamicObject[] relationArray = BusinessDataServiceHelper.load((String)modelCache.getMetaDataEntity("epbs_relationmodelentity"), (String)"number,name,description,dimensionid,datatye,isenable,type", (QFilter[])new QFilter("bizmodel.id", "=", (Object)bizmodelId).toArray());
        if (StringUtils.isNotBlank((CharSequence)tbName)) {
            if (relationArray != null && relationArray.length > 0) {
                ArrayList<String> fieldListCur = new ArrayList<String>(16);
                for (DynamicObject dy : relationArray) {
                    String number = dy.getString("number");
                    fieldListCur.add("f" + number.toLowerCase(Locale.ENGLISH));
                }
                Long datamodelid = modelDy.getLong("datamodelid");
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                params.put("model", datamodelid);
                params.put("cols", new ArrayList(16));
                DataModelMsErHelper dataModelMsErHelper = new DataModelMsErHelper();
                dataModelMsErHelper.init(appNum, formId);
                ArrayList<String> fieldListDb = new ArrayList<String>(16);
                ArrayList<String> hasDelListDb = new ArrayList<String>(16);
                EPDMDataResponse<List<Map<String, Object>>> epdmDataResponse = dataModelMsErHelper.fields(params);
                if (epdmDataResponse.getCode() == 200 && epdmDataResponse.getData() != null) {
                    List<Map<String, Object>> resData = epdmDataResponse.getData();
                    for (Map<String, Object> map : resData) {
                        if ("-1".equals(map.get("status").toString())) {
                            hasDelListDb.add(map.get("field").toString().toLowerCase(Locale.ENGLISH));
                            continue;
                        }
                        fieldListDb.add(map.get("field").toString().toLowerCase(Locale.ENGLISH));
                    }
                }
                fieldListDb.removeIf(q -> BizModelErInitHelper.removeDefualt(q));
                ModelErResponse checkHasDelCols = BizModelErInitHelper.checkHasDelCols(relationArray, hasDelListDb, modelErResponse);
                if (checkHasDelCols != null) {
                    return checkHasDelCols;
                }
                ArrayList addedList = new ArrayList(fieldListCur);
                addedList.removeAll(fieldListDb);
                ArrayList removedList = new ArrayList(fieldListDb);
                removedList.removeAll(fieldListCur);
                if (CollectionUtils.isNotEmpty(addedList)) {
                    ArrayList addList = new ArrayList(addedList.size());
                    addList.addAll(addedList);
                    StringBuilder errorNumberBuffer = new StringBuilder();
                    for (DynamicObject dy : relationArray) {
                        String number = dy.getString("number");
                        String dbNumber = "f" + number.toLowerCase(Locale.ENGLISH);
                        if (!addList.contains(dbNumber)) continue;
                        String name = dy.getString("name");
                        String dbType = BizModelErInitHelper.setDbType(dy);
                        HashMap<String, Object> detail = new HashMap<String, Object>(16);
                        BizModelErInitHelper.fillField(detail, number, name, dbType);
                        HashMap<String, Object> addParams = new HashMap<String, Object>(16);
                        addParams.put("model", datamodelid);
                        addParams.put("field", detail);
                        EPDMDataResponse<Map<String, Object>> addEpdmDataResponse = null;
                        try {
                            addEpdmDataResponse = dataModelMsErHelper.addField(addParams);
                            if (addEpdmDataResponse.getCode() == 200 && addEpdmDataResponse.getData() != null) continue;
                            errorNumberBuffer.append(number).append(",");
                        }
                        catch (Exception e) {
                            LOG.error("[addField-ERROR]" + JSON.toJSONString(addParams) + " [ex]" + e);
                            errorNumberBuffer.append(number).append(",");
                        }
                    }
                    String errorNumber = errorNumberBuffer.toString();
                    if (StringUtils.isNotBlank((CharSequence)errorNumber)) {
                        modelErResponse.setErrorMsg(ErModelErrorEnum.CREATE_ADD_COL_ERROR.getDesc());
                        modelErResponse.setErrorNumbers(errorNumber.substring(0, errorNumber.length() - 1));
                        return modelErResponse;
                    }
                }
                if (CollectionUtils.isNotEmpty(removedList)) {
                    StringBuilder errorNumberBuffer = new StringBuilder();
                    for (String removeTmp : removedList) {
                        HashMap<String, Object> removeParams = new HashMap<String, Object>(16);
                        removeParams.put("model", datamodelid);
                        removeParams.put("field", removeTmp);
                        EPDMDataResponse<Map<String, Object>> addEpdmDataResponse = null;
                        try {
                            addEpdmDataResponse = dataModelMsErHelper.delField(removeParams);
                            if (addEpdmDataResponse.getCode() == 200 && addEpdmDataResponse.getData() != null) continue;
                            errorNumberBuffer.append(removeTmp).append(",");
                        }
                        catch (Exception e) {
                            LOG.error("[delField-ERROR]" + JSON.toJSONString(removeParams) + " [ex]" + e);
                            errorNumberBuffer.append(removeTmp).append(",");
                        }
                    }
                    String errorNumber = errorNumberBuffer.toString();
                    if (StringUtils.isNotBlank((CharSequence)errorNumber)) {
                        modelErResponse.setErrorMsg(ErModelErrorEnum.CREATE_DEL_COL_ERROR.getDesc());
                        modelErResponse.setErrorNumbers(errorNumber.substring(0, errorNumber.length() - 1));
                        return modelErResponse;
                    }
                }
            }
            if (relationArray != null) {
                BizModelErInitHelper.doSaveToResponse(bizmodelId, 0L, modelCache, tbName, relationArray, modelErResponse);
            }
            return modelErResponse;
        }
        if (relationArray != null && relationArray.length > 0) {
            tbName = BizModelErInitHelper.initTabName(appNum);
            HashMap<String, Object> tableInfos = new HashMap<String, Object>(16);
            BizModelErInitHelper.fillTableInfo(tableInfos, tbName, appNum, modelDy);
            ArrayList<Map<String, Object>> details = new ArrayList<Map<String, Object>>(16);
            BizModelErInitHelper.initFid(details);
            BizModelErInitHelper.initTlCols(details);
            for (DynamicObject dy : relationArray) {
                String number = dy.getString("number");
                String name = dy.getString("name");
                String dbType = BizModelErInitHelper.setDbType(dy);
                HashMap<String, Object> detail = new HashMap<String, Object>(16);
                BizModelErInitHelper.fillField(detail, number, name, dbType);
                details.add(detail);
            }
            tableInfos.put("details", details);
            DataModelMsErHelper dataModelMsErHelper = new DataModelMsErHelper();
            dataModelMsErHelper.init(appNum, formId);
            EPDMDataResponse<Map<String, Object>> epdmDataResponse = dataModelMsErHelper.create(tableInfos);
            if (epdmDataResponse.getCode() == 200 && epdmDataResponse.getData() != null) {
                Map<String, Object> resData = epdmDataResponse.getData();
                Long datamodelid = (Long)resData.get("id");
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                params.put("model", datamodelid);
                params.put("link", "");
                EpbsThreadPools.commonExecute(() -> {
                    try {
                        EPDMDataResponse<Map<String, Object>> iscReverseResponse = dataModelMsErHelper.iscReverse(params);
                        if (iscReverseResponse.getCode() != 200) {
                            LOG.info("[iscReverse-ERROR]" + JSON.toJSONString(iscReverseResponse));
                        }
                    }
                    catch (Exception e) {
                        LOG.info("[iscReverse-ERROR]" + JSON.toJSONString((Object)params) + "[ex]" + e);
                    }
                });
                BizModelErInitHelper.doSaveToResponse(bizmodelId, datamodelid, modelCache, tbName, relationArray, modelErResponse);
                return modelErResponse;
            }
        }
        return modelErResponse;
    }

    private static String setDbType(DynamicObject dy) {
        String dbType = BizModelErTypeEnum.STRING.getDateType();
        String type = dy.getString("type");
        if (type.equals(RelationTypeEnum.NOTHING.getType())) {
            String datatye = dy.getString("datatye");
            if (BizModelErTypeEnum.NUMBER.getCode().equals(datatye)) {
                dbType = BizModelErTypeEnum.NUMBER.getDateType();
            } else if (BizModelErTypeEnum.DATETIME.getCode().equals(datatye)) {
                dbType = BizModelErTypeEnum.DATETIME.getDateType();
            }
        }
        return dbType;
    }

    private static void doSaveToResponse(long bizmodelId, Long datamodelid, EpbsModelCache modelCache, String tbName, DynamicObject[] relationArray, ModelErResponse modelErResponse) {
        ModelErResponse response = BizModelErInitHelper.saveDb(bizmodelId, modelCache, tbName, datamodelid, relationArray);
        if (StringUtils.isBlank((CharSequence)response.getTableName())) {
            modelErResponse.setErrorMsg(ErModelErrorEnum.CREATE_TB_ERROR.getDesc());
        } else {
            modelErResponse.setTableName(response.getTableName());
            modelErResponse.setRefreshCols(response.getRefreshCols());
        }
    }

    @Nullable
    private static ModelErResponse checkHasDelCols(DynamicObject[] relationArray, List<String> hasDelListDb, ModelErResponse modelErResponse) {
        StringBuilder errorNumberBuffer = new StringBuilder();
        for (DynamicObject dy : relationArray) {
            String number = dy.getString("number");
            String dbnumber = "f" + number.toLowerCase(Locale.ENGLISH);
            if (!hasDelListDb.contains(dbnumber)) continue;
            errorNumberBuffer.append(number).append(",");
        }
        String errorNumberCheck = errorNumberBuffer.toString();
        if (StringUtils.isNotBlank((CharSequence)errorNumberCheck)) {
            modelErResponse.setErrorMsg(ErModelErrorEnum.CREATE_HAS_DEL_COL_ERROR.getDesc());
            modelErResponse.setErrorNumbers(errorNumberCheck.substring(0, errorNumberCheck.length() - 1));
            return modelErResponse;
        }
        return null;
    }

    public static String convertFieldName(String number) {
        if (StringUtils.isEmpty((CharSequence)number)) {
            return number;
        }
        return "f" + number.toLowerCase(Locale.ROOT);
    }

    private static void fillField(Map<String, Object> detail, String number, String name, String dbType) {
        detail.put("field", BizModelErInitHelper.convertFieldName(number));
        detail.put("content", name);
        detail.put("datatype", dbType);
        if (BizModelErTypeEnum.STRING.getDateType().equals(dbType)) {
            detail.put("datalen", 200);
        }
        if (BizModelErTypeEnum.NUMBER.getCode().equals(dbType)) {
            detail.put("label", TABLE_STATUS);
        } else {
            detail.put("label", "1");
        }
        detail.put("showfield", name);
        detail.put("required", "N");
        detail.put("isprimary", "N");
        detail.put("type", CREATE_COL_OTHER_TYPE);
        detail.put("remark", name);
    }

    private static void fillTableInfo(Map<String, Object> tableInfos, String tbName, String appNum, DynamicObject modelDy) {
        tableInfos.put("number", tbName);
        tableInfos.put("name", modelDy.getString("name"));
        tableInfos.put("table", tbName);
        tableInfos.put("type", ER_TYPE);
        tableInfos.put("catalog", TABLE_CATALOG);
        tableInfos.put("biz", appNum);
        String remark = String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\uff1a%1$s\uff08%2$s\uff09\uff1b\u4e1a\u52a1\u6a21\u578b\uff1a%3$s\uff08%4$s\uff09\uff1b\u5173\u7cfb\u6a21\u578b\uff1a%5$s\uff08%6$s\uff09\u3002", (String)"BizModelErInitHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]), modelDy.getString("model.name"), modelDy.getString("model.shownumber"), modelDy.getString("businessdomainid.name"), modelDy.getString("businessdomainid.number"), modelDy.getString("name"), modelDy.getString("number"));
        tableInfos.put("remark", remark);
        tableInfos.put("appid", appNum);
        tableInfos.put("expire", Integer.MAX_VALUE);
        tableInfos.put("security", 0);
        tableInfos.put("version", "V01");
        tableInfos.put("status", TABLE_STATUS);
    }

    private static String initTabName(String appNum) {
        Integer appLen = appNum.length();
        String timeStr = String.valueOf(System.currentTimeMillis());
        SecureRandom rand = null;
        try {
            rand = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        int randomNum = 0;
        if (rand != null) {
            randomNum = rand.nextInt(900) + 100;
        }
        String tbName = appLen > 3 ? String.format(TABLE_TMP, appNum.substring(0, 3), timeStr.substring(3, timeStr.length()), randomNum) : String.format(TABLE_TMP, appNum, timeStr.substring(appLen, timeStr.length()), randomNum);
        return tbName;
    }

    private static void initTlCols(List<Map<String, Object>> details) {
        BizModelErInitHelper.createComCols(details, BizModelErTypeEnum.LONG, ErTableColEnum.CREATOR.getCode(), ErTableColEnum.CREATOR.getDesc());
        BizModelErInitHelper.createComCols(details, BizModelErTypeEnum.DATETIME, ErTableColEnum.CREATETIME.getCode(), ErTableColEnum.CREATETIME.getDesc());
        BizModelErInitHelper.createComCols(details, BizModelErTypeEnum.LONG, ErTableColEnum.MODIFIER.getCode(), ErTableColEnum.MODIFIER.getDesc());
        BizModelErInitHelper.createComCols(details, BizModelErTypeEnum.DATETIME, ErTableColEnum.MODIFYTIME.getCode(), ErTableColEnum.MODIFYTIME.getDesc());
        BizModelErInitHelper.createComCols(details, BizModelErTypeEnum.STRING, ErTableColEnum.SOURCETYPE.getCode(), ErTableColEnum.SOURCETYPE.getDesc());
        BizModelErInitHelper.createComCols(details, BizModelErTypeEnum.STRING, ErTableColEnum.SOURCESYSTEM.getCode(), ErTableColEnum.SOURCESYSTEM.getDesc());
        BizModelErInitHelper.createComCols(details, BizModelErTypeEnum.STRING, ErTableColEnum.COLLECTTASK.getCode(), ErTableColEnum.COLLECTTASK.getDesc());
        BizModelErInitHelper.createComCols(details, BizModelErTypeEnum.STRING, ErTableColEnum.BATCHNO.getCode(), ErTableColEnum.BATCHNO.getDesc());
        BizModelErInitHelper.createComCols(details, BizModelErTypeEnum.DATETIME, ErTableColEnum.COLLECTTIME.getCode(), ErTableColEnum.COLLECTTIME.getDesc());
    }

    private static boolean removeDefualt(String q) {
        return ErTableColEnum.ID.getCode().equals(q) || ErTableColEnum.CREATOR.getCode().equals(q) || ErTableColEnum.CREATETIME.getCode().equals(q) || ErTableColEnum.MODIFIER.getCode().equals(q) || ErTableColEnum.MODIFYTIME.getCode().equals(q) || ErTableColEnum.SOURCETYPE.getCode().equals(q) || ErTableColEnum.SOURCESYSTEM.getCode().equals(q) || ErTableColEnum.COLLECTTASK.getCode().equals(q) || ErTableColEnum.BATCHNO.getCode().equals(q) || ErTableColEnum.COLLECTTIME.getCode().equals(q);
    }

    private static void createComCols(List<Map<String, Object>> details, BizModelErTypeEnum bizModelErTypeEnum, String field, String name) {
        HashMap<String, String> fmodifierid = new HashMap<String, String>(16);
        fmodifierid.put("field", field);
        fmodifierid.put("content", name);
        fmodifierid.put("datatype", bizModelErTypeEnum.getDateType());
        fmodifierid.put("label", "3");
        fmodifierid.put("showfields", name);
        fmodifierid.put("required", "N");
        fmodifierid.put("isprimary", "N");
        fmodifierid.put("type", "IT");
        fmodifierid.put("remark", name);
        details.add(fmodifierid);
    }

    private static void initFid(List<Map<String, Object>> details) {
        HashMap<String, Object> mainId = new HashMap<String, Object>(16);
        mainId.put("field", ErTableColEnum.ID.getCode());
        mainId.put("content", ErTableColEnum.ID.getDesc());
        mainId.put("datatype", BizModelErTypeEnum.LONG.getDateType());
        mainId.put("datalen", 11);
        mainId.put("label", "3");
        mainId.put("showfields", ErTableColEnum.ID.getDesc());
        mainId.put("required", "N");
        mainId.put("isprimary", "Y");
        mainId.put("type", CREATE_COL_OTHER_TYPE);
        mainId.put("remark", ErTableColEnum.ID.getDesc());
        details.add(mainId);
    }

    private static ModelErResponse saveDb(long bizmodelId, EpbsModelCache modelCache, String tbName, Long datamodelid, DynamicObject[] relationArray) {
        ModelErResponse modelErResponse = new ModelErResponse();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)bizmodelId, (String)modelCache.getMetaDataEntity("epbs_bizmodel"));
        for (DynamicObject object : relationArray) {
            object.set("isenable", (Object)true);
            modelErResponse.getRefreshCols().add(object.getString("number"));
        }
        SaveServiceHelper.save((DynamicObject[])relationArray);
        if (dynamicObject != null) {
            dynamicObject.set("cubenumber", (Object)tbName);
            dynamicObject.set("enable", (Object)"1");
            if (datamodelid != 0L) {
                dynamicObject.set("datamodelid", (Object)datamodelid);
            }
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                modelErResponse.setTableName(tbName);
            }
            catch (Exception e) {
                modelErResponse.setTableName("");
            }
        } else {
            modelErResponse.setTableName("");
        }
        return modelErResponse;
    }
}

