/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.model.bizmodel.ref;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.CollectionUtils;
import kd.epm.epbs.business.model.bizmodel.ref.BizModelDeleteRef;
import kd.epm.epbs.business.model.bizmodel.ref.BizModelRefResult;
import kd.epm.epbs.business.model.bizmodel.ref.IBizModelDeleteRef;
import kd.epm.epbs.business.model.memberref.RefBean;
import kd.epm.epbs.business.model.refUtils.RefUtils;
import kd.epm.epbs.common.configuration.enums.AppConfigPropEnum;
import kd.epm.epbs.common.configuration.enums.IAppConfigProp;
import kd.epm.epbs.common.configuration.factory.ConfigurationContext;
import kd.epm.epbs.common.enums.model.RefBizTypeEnum;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.ReflectUtils;

public class BizModelDeleteRefHelper {
    protected static List<IBizModelDeleteRef> dimDeleteruleList = new ArrayList<IBizModelDeleteRef>(10);
    private long id;
    private long modelId;

    public static BizModelDeleteRefHelper getInstance(long id, long modelId) {
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
        String clazz = ConfigurationContext.INSTANCE.loadProp(modelCache.getModel().getSrcAppNum(), (IAppConfigProp)AppConfigPropEnum.BIZMODELREF_CACHE_CLASS);
        BizModelDeleteRefHelper refHelper = (BizModelDeleteRefHelper)ReflectUtils.newInstance((String)clazz);
        refHelper.id = id;
        refHelper.modelId = modelId;
        return refHelper;
    }

    public BizModelRefResult hasRef() {
        for (IBizModelDeleteRef iBizModelDeleteRef : dimDeleteruleList) {
            BizModelRefResult refResult = this.hasRef(iBizModelDeleteRef);
            if (!refResult.isHasRef()) continue;
            return refResult;
        }
        return BizModelRefResult.success();
    }

    public BizModelRefResult hasRef(IBizModelDeleteRef iBizModelDeleteRef) {
        BizModelRefResult memberRefResult = iBizModelDeleteRef.check(this.id, this.modelId);
        if (memberRefResult.isHasRef()) {
            List<RefBean> hasRefList = memberRefResult.getHasRefList();
            if (memberRefResult.getMsg() == null && CollectionUtils.isNotEmpty(hasRefList)) {
                StringBuilder stringBuilder = new StringBuilder();
                RefBizTypeEnum refBizType = iBizModelDeleteRef.getRefBizType();
                EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.modelId);
                String tmplateStr = ResManager.loadKDString((String)"\u6a21\u578b%1$s\u88ab%2$s\u5f15\u7528\uff0c", (String)"BizModelDeleteRefHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]);
                String s1 = "\u201c" + modelCache.getBizModelById(this.id).getNumber() + " " + modelCache.getBizModelById(this.id).getNameString() + "\u201c";
                String s2 = refBizType.getName().getLocaleString() + "";
                RefUtils.buildErrorMsg(hasRefList, tmplateStr, s1, s2, stringBuilder);
                memberRefResult.setMsg(stringBuilder.toString());
            }
            return memberRefResult;
        }
        return BizModelRefResult.success();
    }

    static {
        dimDeleteruleList.add(new BizModelDeleteRef());
    }
}

