/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.model.dimension;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.CollectionUtils;
import kd.epm.epbs.business.model.dimension.DimAuthSetRuleRef;
import kd.epm.epbs.business.model.dimension.DimBizModelDeleteRef;
import kd.epm.epbs.business.model.dimension.DimRefResult;
import kd.epm.epbs.business.model.dimension.IDimDeleteRef;
import kd.epm.epbs.business.model.memberref.RefBean;
import kd.epm.epbs.business.model.refUtils.RefUtils;
import kd.epm.epbs.common.configuration.enums.AppConfigPropEnum;
import kd.epm.epbs.common.configuration.enums.IAppConfigProp;
import kd.epm.epbs.common.configuration.factory.ConfigurationContext;
import kd.epm.epbs.common.enums.model.RefBizTypeEnum;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.ReflectUtils;

public class DimDeleteRefHelper {
    protected static List<IDimDeleteRef> dimDeleteruleList = new ArrayList<IDimDeleteRef>(10);
    private long id;
    private long modelId;

    public static DimDeleteRefHelper getInstance(long id, long modelId) {
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
        String clazz = ConfigurationContext.INSTANCE.loadProp(modelCache.getModel().getSrcAppNum(), (IAppConfigProp)AppConfigPropEnum.DIMREF_CACHE_CLASS);
        DimDeleteRefHelper refHelper = (DimDeleteRefHelper)ReflectUtils.newInstance((String)clazz);
        refHelper.id = id;
        refHelper.modelId = modelId;
        return refHelper;
    }

    public DimRefResult hasRef() {
        for (IDimDeleteRef iBizModelDeleteRef : dimDeleteruleList) {
            DimRefResult refResult = this.hasRef(iBizModelDeleteRef);
            if (!refResult.isHasRef()) continue;
            return refResult;
        }
        return DimRefResult.success();
    }

    public DimRefResult hasRef(IDimDeleteRef iBizModelDeleteRef) {
        DimRefResult memberRefResult = iBizModelDeleteRef.check(this.id, this.modelId);
        if (memberRefResult.isHasRef()) {
            List<RefBean> hasRefList = memberRefResult.getHasRefList();
            if (memberRefResult.getMsg() == null && CollectionUtils.isNotEmpty(hasRefList)) {
                StringBuilder stringBuilder = new StringBuilder();
                RefBizTypeEnum refBizType = iBizModelDeleteRef.getRefBizType();
                String tmplateStr = ResManager.loadKDString((String)"\u7ef4\u5ea6%1$s\u88ab%2$s\u5f15\u7528\uff0c", (String)"DimDeleteRefHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]);
                EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.modelId);
                String s1 = "\u201c" + modelCache.getDimensionById(this.id).getShortNumber() + " " + modelCache.getDimensionById(this.id).getNumber() + "\u201c";
                String s2 = refBizType.getName().getLocaleString() + "";
                RefUtils.buildErrorMsg(hasRefList, tmplateStr, s1, s2, stringBuilder);
                memberRefResult.setMsg(stringBuilder.toString());
            }
            return memberRefResult;
        }
        return DimRefResult.success();
    }

    static {
        dimDeleteruleList.add(new DimAuthSetRuleRef());
        dimDeleteruleList.add(new DimBizModelDeleteRef());
    }
}

