/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.model.dimension;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.member.f7.NewF7Utils;
import kd.epm.epbs.common.bean.ModelBean;
import kd.epm.epbs.common.enums.model.DimTypeEnum;
import kd.epm.epbs.common.enums.model.PeriodTypeEnum;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.NumberRuleUtils;
import kd.epm.epbs.common.util.OperationResultUtil;
import org.jetbrains.annotations.NotNull;

public class DimensionServiceHelper {
    private static final String[] num = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};

    public static String checkAddData(AbstractFormPlugin plugIn) {
        Object model = plugIn.getView().getFormShowParameter().getCustomParam("model");
        String msg = "";
        String shortnumber = plugIn.getView().getModel().getValue("dimshortnumber").toString();
        String number = plugIn.getView().getModel().getValue("dimnumber").toString();
        String regEx = "^(?!_)[a-zA-Z0-9]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        Matcher matcher2 = pattern.matcher(shortnumber);
        if (StringUtils.startsWithAny((CharSequence)number, (CharSequence[])num) || StringUtils.startsWithAny((CharSequence)shortnumber, (CharSequence[])num) || !NumberRuleUtils.checkKeyWords((String)number) || !NumberRuleUtils.checkKeyWords((String)shortnumber) || !matcher.matches() || !matcher2.matches()) {
            msg = ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u548c\u7b80\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u548c\u534a\u89d2\u5b57\u6bcd\uff08\u591a\u7ef4\u5e93\u4fdd\u7559\u5b57\u6bb5all\u3001other\u3001none\u4e0d\u80fd\u4f5c\u4e3a\u7f16\u7801\u548c\u7b80\u7801\uff09\uff0c\u4e0d\u53ef\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimensionServiceHelper_10", (String)"epm-epbs-business", (Object[])new Object[0]);
            return msg;
        }
        if (number.contains(".") || shortnumber.contains(".")) {
            msg = ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u548c\u7b80\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u548c\u534a\u89d2\u5b57\u6bcd\uff08\u591a\u7ef4\u5e93\u4fdd\u7559\u5b57\u6bb5all\u3001other\u3001none\u4e0d\u80fd\u4f5c\u4e3a\u7f16\u7801\u548c\u7b80\u7801\uff09\uff0c\u4e0d\u53ef\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimensionServiceHelper_10", (String)"epm-epbs-business", (Object[])new Object[0]);
            return msg;
        }
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)((Long)model));
        ModelBean modelBean = modelCache.getModel();
        String modelName = "";
        if (modelBean != null) {
            modelName = modelBean.getNameString();
        }
        QFilter filter = new QFilter("number", "=", (Object)String.valueOf(number)).and(new QFilter("model", "=", model));
        boolean existRepeatNumber = QueryServiceHelper.exists((String)modelCache.getMetaDataEntity("epbs_dimension"), (QFilter[])new QFilter[]{filter});
        OperationStatus status = plugIn.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW) && existRepeatNumber) {
            msg = String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u201d%1$s\u201c\u4e0b\u5df2\u5b58\u5728\u7ef4\u5ea6\u7f16\u7801\u201d%2$s\u201c\u3002", (String)"DimensionServiceHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]), modelName, number);
            return msg;
        }
        Set collect = QueryServiceHelper.query((String)modelCache.getMetaDataEntity("epbs_dimension"), (String)"number", (QFilter[])new QFilter[]{new QFilter("model", "=", model)}).stream().map(c -> c.getString("number").toLowerCase()).collect(Collectors.toSet());
        if (collect.contains(number.toLowerCase()) && status.equals((Object)OperationStatus.ADDNEW)) {
            msg = String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u201d%1$s\u201c\u4e0b\u5df2\u5b58\u5728\u7ef4\u5ea6\u7f16\u7801\u201d%2$s\u201c\u3002", (String)"DimensionServiceHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]), modelName, number);
            return msg;
        }
        filter = new QFilter("shortnumber", "=", (Object)String.valueOf(shortnumber)).and(new QFilter("model", "=", model));
        existRepeatNumber = QueryServiceHelper.exists((String)modelCache.getMetaDataEntity("epbs_dimension"), (QFilter[])new QFilter[]{filter});
        if (status.equals((Object)OperationStatus.ADDNEW) && existRepeatNumber) {
            msg = String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u201d%1$s\u201c\u4e0b\u5df2\u5b58\u5728\u7ef4\u5ea6\u7b80\u7801\u201d%2$s\u201c\u3002", (String)"DimensionServiceHelper_2", (String)"epm-epbs-business", (Object[])new Object[0]), modelName, shortnumber);
            return msg;
        }
        if (shortnumber.equals(String.valueOf(number))) {
            msg = ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u548c\u7ef4\u5ea6\u7b80\u7801\u4e0d\u80fd\u4e00\u81f4\u3002", (String)"DimensionServiceHelper_3", (String)"epm-epbs-business", (Object[])new Object[0]);
            return msg;
        }
        return msg;
    }

    public static JSONObject saveData(DynamicObject dimension) {
        long modelId = dimension.getLong("model");
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
        JSONObject result = new JSONObject();
        dimension.set("status", (Object)"1");
        dimension.set("dseq", (Object)DimensionServiceHelper.getDimSeq(modelId, modelCache));
        dimension.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        dimension.set("createtime", (Object)TimeServiceHelper.now());
        dimension.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
        dimension.set("modifytime", (Object)TimeServiceHelper.now());
        long[] longIds = DBServiceHelper.genLongIds((String)dimension.getDataEntityType().getName(), (int)1);
        long id = longIds[0];
        dimension.set("id", (Object)id);
        result.put("dimId", (Object)id);
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dimension});
        if (save != null && save.length > 0) {
            DynamicObject saveData = (DynamicObject)save[0];
            Long viewId = DimensionServiceHelper.saveView(saveData.get("id"), dimension.get("number").toString(), dimension.get("shortnumber").toString(), modelCache);
            result.put("viewId", (Object)viewId);
        }
        EpbsModelCacheHelper.invalidateModelKeyById((Long)modelId);
        return result;
    }

    private static Long saveView(Object id, String number, String shortnumber, EpbsModelCache modelCache) {
        DynamicObject view;
        DynamicObject dimension = BusinessDataServiceHelper.loadSingle((Object)id, (String)modelCache.getMetaDataEntity("epbs_dimension"));
        String metaDataEntity = modelCache.getMetaDataEntity("epbs_struct_view");
        long[] longs = DBServiceHelper.genLongIds((String)metaDataEntity, (int)2);
        long groupId = longs[0];
        long Id = longs[1];
        DynamicObject viewGroup = BusinessDataServiceHelper.newDynamicObject((String)metaDataEntity);
        viewGroup.set("number", (Object)shortnumber);
        viewGroup.set("name", (Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u89c6\u56fe\u7ec4", (String)"DimensionServiceHelper_6", (String)"epm-epbs-business", (Object[])new Object[0]));
        viewGroup.set("type", (Object)"1");
        viewGroup.set("isgroup", (Object)true);
        viewGroup.set("id", (Object)groupId);
        viewGroup.set("model", dimension.get("model"));
        viewGroup.set("dimension", (Object)dimension);
        viewGroup.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        viewGroup.set("createtime", (Object)TimeServiceHelper.now());
        viewGroup.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
        viewGroup.set("modifytime", (Object)TimeServiceHelper.now());
        viewGroup.set("isdefault", (Object)true);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)metaDataEntity, (DynamicObject[])new DynamicObject[]{viewGroup}, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            OperationResultUtil.throwOperationResult((OperationResult)operationResult);
        }
        if (DimTypeEnum.Period.getValue().equals(dimension.getDynamicObject("dtypeid").getString("type"))) {
            view = BusinessDataServiceHelper.newDynamicObject((String)modelCache.getMetaDataEntity("epbs_period_view"));
            view.set("periodtype", (Object)PeriodTypeEnum.MONTH.getValue());
            view.set("startyear", (Object)"2");
            view.set("startmonth", (Object)"1");
            view.set("startday", (Object)"1");
            view.set("endyear", (Object)"2");
            view.set("endmonth", (Object)"12");
            view.set("endday", (Object)"31");
            view.set("iscrehalf", (Object)true);
            view.set("iscrequarter", (Object)true);
            view.set("name", (Object)ResManager.getLocaleString((String)"\u6708\u671f\u95f4", (String)"DimensionServiceHelper_7", (String)"epm-epbs-business"));
        } else {
            view = BusinessDataServiceHelper.newDynamicObject((String)metaDataEntity);
            view.set("name", (Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u89c6\u56fe", (String)"DimensionServiceHelper_8", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        view.set("model", dimension.get("model"));
        view.set("number", (Object)number);
        view.set("type", (Object)"1");
        view.set("isgroup", (Object)false);
        view.set("dimension", (Object)dimension);
        view.set("parent", (Object)viewGroup);
        view.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        view.set("createtime", (Object)TimeServiceHelper.now());
        view.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
        view.set("modifytime", (Object)TimeServiceHelper.now());
        view.set("isdefault", (Object)true);
        view.set("id", (Object)Id);
        operationResult = OperationServiceHelper.executeOperate((String)"save", (String)metaDataEntity, (DynamicObject[])new DynamicObject[]{view}, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            OperationResultUtil.throwOperationResult((OperationResult)operationResult);
        }
        return Id;
    }

    public static int getDimSeq(long modelId, EpbsModelCache modelCache) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)modelCache.getMetaDataEntity("epbs_dimension"), (String)"dseq", (QFilter[])qFilters, (String)"dseq");
        if (dcs != null) {
            return dcs.size() == 0 ? 1 : ((DynamicObject)dcs.get(dcs.size() - 1)).getInt("dseq") + 1;
        }
        return 1;
    }

    public static void addMember(AbstractFormPlugin plugIn, AbstractMemberF7Parameter f7Param) {
        Object dimension = plugIn.getView().getModel().getValue("dimension");
        if (dimension == null) {
            plugIn.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"DimensionServiceHelper_9", (String)"epm-epbs-business", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] entryGridCollection = ((EntryGrid)plugIn.getControl("entryentity")).getEntryData().getDataEntitys();
        HashMap<Long, Integer> selectIds = new HashMap<Long, Integer>();
        if (entryGridCollection != null && entryGridCollection.length > 0) {
            for (DynamicObject dynamicObject : entryGridCollection) {
                selectIds.put(dynamicObject.getLong("memberid"), dynamicObject.getInt("scope"));
            }
            f7Param.setViewId(Long.valueOf(entryGridCollection[0].getLong("viewid")));
            f7Param.setSelectIds(selectIds);
        }
        f7Param.setShowCustomProperty(false);
        f7Param.setEnableView(true);
        NewF7Utils.openF8(plugIn.getView(), f7Param, new CloseCallBack((IFormPlugin)plugIn, "addmember"));
    }

    public static void setVisibleFlex(AbstractFormPlugin plugIn, boolean flag, String name) {
        String type = (String)plugIn.getView().getModel().getValue(name);
        if ("1".equals(type)) {
            plugIn.getView().setVisible(Boolean.valueOf(false), new String[]{"businessdomainid", "bizmodel", "dimensionref", "basedata", "datatye"});
            plugIn.getView().setVisible(Boolean.valueOf(true), new String[]{"connectflex", "dimflexpanelap", "dimension", "isconnect"});
            plugIn.getView().getModel().setValue("bizmodel", null);
            plugIn.getView().getModel().setValue("dimensionref", null);
            plugIn.getView().getModel().setValue("basedata", null);
            plugIn.getView().getModel().setValue("isconnect", null);
            plugIn.getView().getModel().setValue("ismustinput", null);
            plugIn.getView().getModel().setValue("datatye", null);
            plugIn.getView().getModel().setValue("businessdomainid", null);
            if ("type".equals(name)) {
                plugIn.getView().getModel().setValue("sourcedim", (Object)"1");
            }
            if (flag) {
                FieldEdit edit = (FieldEdit)plugIn.getControl("dimension");
                edit.setMustInput(true);
            }
        } else if ("2".equals(type)) {
            plugIn.getView().setVisible(Boolean.valueOf(false), new String[]{"dimflexpanelap", "basedata", "datatye", "businessdomainid", "dimflexpanelap", "dimension"});
            plugIn.getView().setVisible(Boolean.valueOf(true), new String[]{"connectflex", "bizmodel", "dimensionref", "isconnect"});
            plugIn.getView().getModel().setValue("basedata", null);
            plugIn.getView().getModel().setValue("isconnect", null);
            plugIn.getView().getModel().setValue("ismustinput", null);
            plugIn.getView().getModel().setValue("datatye", null);
            plugIn.getView().getModel().deleteEntryData("entryentity");
            plugIn.getView().getModel().setValue("dimension", null);
            plugIn.getView().getModel().setValue("businessdomainid", null);
            if (flag) {
                FieldEdit edit = (FieldEdit)plugIn.getControl("bizmodel");
                edit.setMustInput(true);
                edit = (FieldEdit)plugIn.getControl("dimensionref");
                edit.setMustInput(true);
            }
        } else if ("3".equals(type)) {
            plugIn.getView().setVisible(Boolean.valueOf(false), new String[]{"dimflexpanelap", "basedata", "datatye", "businessdomainid", "dimflexpanelap", "dimension", "bizmodel", "dimensionref"});
            plugIn.getView().setVisible(Boolean.valueOf(true), new String[]{"connectflex", "basedata", "isconnect"});
            plugIn.getView().getModel().setValue("basedata", null);
            plugIn.getView().getModel().setValue("isconnect", null);
            plugIn.getView().getModel().setValue("ismustinput", null);
            plugIn.getView().getModel().setValue("datatye", null);
            plugIn.getView().getModel().deleteEntryData("entryentity");
            plugIn.getView().getModel().setValue("dimension", null);
            plugIn.getView().getModel().setValue("sourcedim", null);
            plugIn.getView().getModel().setValue("businessdomainid", null);
            if (flag) {
                FieldEdit edit = (FieldEdit)plugIn.getControl("basedata");
                edit.setMustInput(true);
            }
        } else if ("4".equals(type)) {
            plugIn.getView().setVisible(Boolean.valueOf(false), new String[]{"connectflex", "isconnect"});
            plugIn.getView().setVisible(Boolean.valueOf(true), new String[]{"datatye"});
            plugIn.getView().getModel().setValue("bizmodel", null);
            plugIn.getView().getModel().setValue("dimensionref", null);
            plugIn.getView().getModel().setValue("basedata", null);
            plugIn.getView().getModel().deleteEntryData("entryentity");
            plugIn.getView().getModel().setValue("dimension", null);
            plugIn.getView().getModel().setValue("sourcedim", null);
            plugIn.getView().getModel().setValue("businessdomainid", null);
            if (flag) {
                FieldEdit edit = (FieldEdit)plugIn.getControl("datatye");
                edit.setMustInput(true);
            }
        }
        if (flag) {
            plugIn.getView().updateView("splitpanel_right");
        } else {
            plugIn.getView().updateView();
        }
    }

    public static void updateIsLeafByParentId(Long[] memberIds, @NotNull Long modelId, @NotNull Long dimensionId, @NotNull String entityNumber) {
        DynamicObject[] loads;
        if (memberIds == null || memberIds.length == 0) {
            return;
        }
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
        DimensionBean dimension = modelCache.getDimensionById(dimensionId.longValue());
        DimTypeBean dimType = modelCache.getDimTypeById(dimension.getDimTypeId());
        String table = dimType.getMemberTreeTable();
        SqlBuilder sql = new SqlBuilder();
        sql.append("select distinct fparentid from ", new Object[0]).append(table, new Object[0]).append(" where fmodelid = ? ", new Object[]{modelId});
        sql.append(" and fdimensionid = ?", new Object[]{dimensionId});
        sql.append(" and ", new Object[0]).appendIn("fparentid", (Object[])memberIds);
        HashSet hasChildren = Sets.newHashSetWithExpectedSize((int)memberIds.length);
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet ds = DB.queryDataSet((String)"queryParentSize", (DBRoute)modelCache.getAppDBRoute(), (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    hasChildren.add(row.getLong(0));
                }
            }
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)entityNumber, (String)"id, isleaf", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)memberIds)})) {
            if (hasChildren.contains(load.getLong("id"))) {
                load.set("isleaf", (Object)0);
                continue;
            }
            load.set("isleaf", (Object)1);
        }
        SaveServiceHelper.update((DynamicObject[])loads);
    }
}

