/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.model.f7;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.model.f7.CusPropertyTreeBuilder;
import kd.epm.epbs.business.model.f7.DynamicTreeBuilder;
import kd.epm.epbs.business.model.f7.SelectedDimMember;
import kd.epm.epbs.business.permission.data.context.EpbsPermContext;
import kd.epm.epbs.business.permission.data.factory.DimPermFactory;
import kd.epm.epbs.common.enums.DataPermTypeEnum;
import kd.epm.epbs.common.enums.RangeEnum;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.QFBuilder;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class MemberF7Parameter
extends AbstractMemberF7Parameter {
    private long bizModelId;
    private DataPermTypeEnum permType;
    private boolean enableDimension = false;
    private List<SelectedDimMember> selectedDimMemberList;

    public void setPermType(DataPermTypeEnum permType) {
        this.permType = permType;
    }

    public DataPermTypeEnum getPermType() {
        return this.permType;
    }

    public MemberF7Parameter() {
    }

    public MemberF7Parameter(@NotNull Long modelId) {
        this.setModelId(modelId);
    }

    public MemberF7Parameter(@NotNull Long modelId, @NotNull Long dimensionId) {
        super(modelId, dimensionId);
    }

    public MemberF7Parameter(@NotNull Long modelId, @NotNull String dimensionNumber) {
        super(modelId, dimensionNumber);
    }

    public MemberF7Parameter(@NotNull Long modelId, @NotNull DynamicObject dimension) {
        super(modelId, dimension);
    }

    protected Set<Long> loadPermission() {
        EpbsPermContext ctx = new EpbsPermContext(this.getModelId(), this.permType == null ? DataPermTypeEnum.READ_WRITE : this.permType);
        ctx.setViewId(IDUtils.toLong((Object)this.getViewId()));
        return (Set)DimPermFactory.getInstance().getAllMembIds(ctx, this.getDimensionNumber());
    }

    protected QFilter getSelectRangeFilter() {
        return null;
    }

    protected boolean isMember(Long memberId) {
        return false;
    }

    public boolean canShowCustomProperty() {
        return true;
    }

    public List<ComboItem> getRangeItems() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        items.add(new ComboItem(new LocaleString(RangeEnum.ONLY.getName()), String.valueOf(RangeEnum.ONLY.getIndex())));
        items.add(new ComboItem(new LocaleString(RangeEnum.DIRECTSUB_EXCLUDE.getName()), String.valueOf(RangeEnum.DIRECTSUB_EXCLUDE.getIndex())));
        items.add(new ComboItem(new LocaleString(RangeEnum.DIRECTSUB.getName()), String.valueOf(RangeEnum.DIRECTSUB.getIndex())));
        items.add(new ComboItem(new LocaleString(RangeEnum.ALL_EXCLUDE.getName()), String.valueOf(RangeEnum.ALL_EXCLUDE.getIndex())));
        items.add(new ComboItem(new LocaleString(RangeEnum.ALL.getName()), String.valueOf(RangeEnum.ALL.getIndex())));
        items.add(new ComboItem(new LocaleString(RangeEnum.PEERS_EXCLUDE.getName()), String.valueOf(RangeEnum.PEERS_EXCLUDE.getIndex())));
        items.add(new ComboItem(new LocaleString(RangeEnum.PEERS.getName()), String.valueOf(RangeEnum.PEERS.getIndex())));
        items.add(new ComboItem(new LocaleString(RangeEnum.ALL_DETAIL.getName()), String.valueOf(RangeEnum.ALL_DETAIL.getIndex())));
        items.add(new ComboItem(new LocaleString(RangeEnum.ALL_NOTDETAIL.getName()), String.valueOf(RangeEnum.ALL_NOTDETAIL.getIndex())));
        return items;
    }

    public boolean isView() {
        return false;
    }

    public String getF7FormId() {
        return "epbs_new_memberf7";
    }

    public String getF8FormId() {
        return "epbs_new_memberf8";
    }

    public String fields() {
        String _fields = this.getFields();
        if (StringUtils.isEmpty((CharSequence)this.getFields())) {
            _fields = "id,name,number,shownumber,parent.id,isleaf,level";
        }
        return _fields;
    }

    public CusPropertyTreeBuilder getCustomPropertyTreeBuilder(AbstractMemberF7Parameter f7Parameter) {
        return new CusPropertyTreeBuilder(f7Parameter);
    }

    public DynamicTreeBuilder getTreeBuilder(AbstractMemberF7Parameter f7Parameter) {
        return new DynamicTreeBuilder(f7Parameter);
    }

    public QFBuilder filters(boolean isBuildTree) {
        QFBuilder filters = super.filters(isBuildTree);
        if (IDUtils.isNotNull((Long)this.getViewId())) {
            filters.add(new QFilter("view", "=", (Object)this.getViewId()));
        }
        return filters;
    }

    protected void initBaseParam(@NotNull Long modelId, DynamicObject dimension) {
        super.initBaseParam(modelId, dimension);
    }

    protected DynamicObject getDimension(@NotNull Long modelId, @NotNull String dimensionNumber) {
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("number", "=", (Object)dimensionNumber);
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
        return QueryServiceHelper.queryOne((String)modelCache.getMetaDataEntity("epbs_dimension"), (String)"id,name,number,dtypeid.membertreemodel as membermodel,dtypeid.isshowview as isshowview,shortnumber", (QFilter[])builder.toArray());
    }

    protected DynamicObject getDimension(@NotNull Long dimensionId) {
        QFilter qFilter = new QFilter("id", "=", (Object)dimensionId);
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
        return QueryServiceHelper.queryOne((String)modelCache.getMetaDataEntity("epbs_dimension"), (String)"id,name,number,dtypeid.membertreemodel as membermodel,dtypeid.isshowview as isshowview,shortnumber", (QFilter[])qFilter.toArray());
    }

    public long getBizModelId() {
        return this.bizModelId;
    }

    public void setBizModelId(long bizModelId) {
        this.bizModelId = bizModelId;
    }

    public boolean isEnableDimension() {
        return this.enableDimension;
    }

    public List<SelectedDimMember> getSelectedDimMemberList() {
        return this.selectedDimMemberList;
    }

    public void setSelectedDimMemberList(List<SelectedDimMember> selectedDimMemberList) {
        this.selectedDimMemberList = selectedDimMemberList;
    }

    public void addSelectedDimMemberList(SelectedDimMember selectedDimMember) {
        if (this.selectedDimMemberList == null) {
            this.selectedDimMemberList = new ArrayList<SelectedDimMember>(10);
        }
        this.selectedDimMemberList.add(selectedDimMember);
    }

    public void setEnableDimension(boolean enableDimension) {
        this.enableDimension = enableDimension;
        this.setClearSelectWhenChangeView(!enableDimension);
    }

    public String getOrderBy() {
        if (StringUtils.isEmpty((CharSequence)this.orderBy)) {
            this.orderBy = "level,dseq";
        }
        return this.orderBy;
    }

    public boolean isNewReturn() {
        return true;
    }
}

