/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.model.f7;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.model.f7.DynamicTreeBuilder;
import kd.epm.epbs.business.model.f7.PeriodMemberF7Parameter;
import kd.epm.epbs.business.model.f7.SelectedPeriod;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.member.f7.F7TreeUtils;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.CommonServiceHelper;
import org.jetbrains.annotations.NotNull;

public class PeriodDynamicTreeBuilder
extends DynamicTreeBuilder {
    private Set<String> selectedNodeIds = null;

    protected PeriodDynamicTreeBuilder(@NotNull AbstractMemberF7Parameter f7Parameter) {
        super(f7Parameter);
    }

    protected TreeNode buildRootTree(@NotNull IPageCache pageCache) {
        TreeNode treeNode;
        List<Map<String, Object>> yearMaps = this.queryYearData();
        List periodMaps = this.queryInitData();
        ArrayList yearPeriodMaps = new ArrayList(periodMaps.size() * yearMaps.size());
        for (Map<String, Object> yearMap : yearMaps) {
            for (Map map : periodMaps) {
                LinkedHashMap<String, Object> yearPeriodMap = new LinkedHashMap<String, Object>(16);
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    if ("id".equals(key)) {
                        yearPeriodMap.put(key, yearMap.get(key) + "@" + entry.getValue());
                        continue;
                    }
                    if ("parent.id".equals(key)) {
                        yearPeriodMap.put(key, yearMap.get("id") + "@" + entry.getValue());
                        continue;
                    }
                    if ("number".equals(key) || "shownumber".equals(key) || "name".equals(key)) {
                        int level = (Integer)map.get("level");
                        if (level == 1 && "name".equals(key)) {
                            yearPeriodMap.put(key, yearMap.get(key));
                            continue;
                        }
                        yearPeriodMap.put(key, yearMap.get(key) + "" + entry.getValue());
                        continue;
                    }
                    yearPeriodMap.put(key, entry.getValue());
                }
                yearPeriodMaps.add(yearPeriodMap);
            }
        }
        TreeNode root = new TreeNode("", "root", "root");
        LinkedHashMap<String, TreeNode> nodeMap = new LinkedHashMap<String, TreeNode>(yearPeriodMaps.size());
        for (Map map : yearPeriodMaps) {
            treeNode = new TreeNode((String)map.get("parent.id"), (String)map.get("id"), "");
            treeNode.setText(F7TreeUtils.nodeShowType((Map)map, (String)this.getF7Parameter().getShowType()));
            nodeMap.put(treeNode.getId(), treeNode);
            if (!this.checkHasSelect(treeNode.getId())) continue;
            this.getSelected().add(treeNode);
        }
        for (Map.Entry entry : nodeMap.entrySet()) {
            treeNode = (TreeNode)entry.getValue();
            TreeNode parent = (TreeNode)nodeMap.get(treeNode.getParentid());
            if (parent != null) {
                parent.addChild(treeNode);
                continue;
            }
            if (!treeNode.getParentid().contains("@0")) continue;
            treeNode.setParentid("root");
            root.addChild(treeNode);
        }
        this.setShowRoot(false);
        return root;
    }

    public Set<String> getSelectedNodeIds() {
        PeriodMemberF7Parameter f7Parameter;
        List<SelectedPeriod> selectedPeriodList;
        if (this.selectedNodeIds == null && (selectedPeriodList = (f7Parameter = this.getF7Parameter()).getSelectedPeriodList()) != null) {
            this.selectedNodeIds = selectedPeriodList.stream().map(SelectedPeriod::toPeriodKey).collect(Collectors.toSet());
        }
        return this.selectedNodeIds;
    }

    protected boolean checkHasSelect(@NotNull String nodeId) {
        Set<String> selectedNodeIds;
        PeriodMemberF7Parameter f7Parameter = this.getF7Parameter();
        if (f7Parameter.getFunctionType() == 1 && (selectedNodeIds = this.getSelectedNodeIds()) != null) {
            return selectedNodeIds.contains(nodeId);
        }
        return false;
    }

    protected PeriodMemberF7Parameter getF7Parameter() {
        return (PeriodMemberF7Parameter)super.getF7Parameter();
    }

    protected QFilter[] getYearDimInitFilters() {
        return this.getF7Parameter().getYearDimFilters().getFilters().toArray(new QFilter[0]);
    }

    protected List<Map<String, Object>> queryYearData() {
        List filterData;
        PeriodMemberF7Parameter f7Parameter = this.getF7Parameter();
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)f7Parameter.getModelId());
        long yearDimId = f7Parameter.getYearDimId();
        DimTypeBean dimType = modelCache.getDimTypeByDimensionId(yearDimId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryTreeData", (String)dimType.getMemberTreemodel(), (String)this.getInitFields(), (QFilter[])this.getYearDimInitFilters(), (String)this.getInitOrder());){
            filterData = CommonServiceHelper.transDataSet((DataSet)ds);
        }
        return filterData;
    }

    protected TreeNode getFocusNode(TreeNode root) {
        PeriodMemberF7Parameter f7Parameter = this.getF7Parameter();
        List<SelectedPeriod> selectedPeriodList = f7Parameter.getSelectedPeriodList();
        TreeNode _node = null;
        if (selectedPeriodList != null && !selectedPeriodList.isEmpty()) {
            SelectedPeriod selectedPeriod = selectedPeriodList.get(0);
            _node = root.getTreeNode(selectedPeriod.toPeriodKey());
        }
        if (_node == null) {
            _node = root;
        }
        return _node;
    }
}

