/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.model.f7;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.epm.epbs.business.model.f7.MemberF7Parameter;
import kd.epm.epbs.business.model.f7.PeriodDynamicTreeBuilder;
import kd.epm.epbs.business.model.f7.SelectedPeriod;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.bean.YearPeriod;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epbs.common.util.QFBuilder;
import org.jetbrains.annotations.NotNull;

public abstract class PeriodMemberF7Parameter
extends MemberF7Parameter {
    private long yearDimId;
    private List<SelectedPeriod> selectedPeriodList;
    private final Map<Long, YearPeriod> yearPeriodIdMap = new HashMap<Long, YearPeriod>(16);

    public long getYearDimId() {
        return this.yearDimId;
    }

    public void setYearDimId(long yearDimId) {
        this.yearDimId = yearDimId;
    }

    public PeriodMemberF7Parameter() {
    }

    public PeriodMemberF7Parameter(@NotNull Long modelId, @NotNull Long yearDimId, @NotNull Long periodDimId) {
        super(modelId, periodDimId);
        this.yearDimId = yearDimId;
    }

    public PeriodMemberF7Parameter(@NotNull Long modelId, @NotNull String yearDimNumber, @NotNull String periodDimNumber) {
        super(modelId, periodDimNumber);
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
        this.yearDimId = modelCache.getDimension(yearDimNumber).getId();
    }

    @Override
    protected Set<Long> loadPermission() {
        return null;
    }

    @Override
    public PeriodDynamicTreeBuilder getTreeBuilder(AbstractMemberF7Parameter f7Parameter) {
        return new PeriodDynamicTreeBuilder(f7Parameter);
    }

    public QFBuilder getYearDimFilters() {
        log.info("begin-filters.");
        QFBuilder builder = new QFBuilder();
        builder.add(this.getModelFilter());
        builder.add("dimension", "=", (Object)this.yearDimId);
        builder.add("isstandard", "=", (Object)true);
        if (!this.isShowNotEnable()) {
            builder.add("enable", "=", (Object)"1");
        }
        if (this.isShowDisable()) {
            builder.remove("enable");
        }
        builder.add("level", ">", (Object)1);
        if (this.getSelectRangeIds() != null) {
            HashSet<Long> tmpIds = new HashSet<Long>(this.getSelectRangeIds());
            if (tmpIds.isEmpty()) {
                tmpIds.add(0L);
            }
            builder.add(this.pkField(), "in", tmpIds);
        }
        return builder;
    }

    public List<SelectedPeriod> getSelectedPeriodList() {
        return this.selectedPeriodList;
    }

    public void setSelectedPeriodList(List<SelectedPeriod> selectedPeriodList) {
        this.selectedPeriodList = selectedPeriodList;
    }

    public void addSelectedPeriodList(SelectedPeriod selectedPeriod) {
        if (this.selectedPeriodList == null) {
            this.selectedPeriodList = new ArrayList<SelectedPeriod>(10);
        }
        this.selectedPeriodList.add(selectedPeriod);
    }

    public void setSelectIds(Map<Long, Integer> selectIds) {
    }

    public void setSelectIds(Set<Long> selectIds) {
    }

    public Map<Long, YearPeriod> getYearPeriodIdMap() {
        return this.yearPeriodIdMap;
    }

    public ListSelectedRowCollection selectedListRows() {
        ListSelectedRowCollection rows = new ListSelectedRowCollection();
        if (this.selectedPeriodList != null) {
            EpbsMemberCache epbsMemberCache = EpbsMemberCacheHelper.get((long)this.getModelId(), (long)this.getYearDimId());
            for (SelectedPeriod selectedPeriod : this.selectedPeriodList) {
                long id = GlobalIdUtil.genGlobalLongId();
                YearPeriod yearPeriod = new YearPeriod(selectedPeriod.getYearId(), selectedPeriod.getPeriodId());
                MemberBean member = epbsMemberCache.getMember(selectedPeriod.getYearId());
                if (member != null) {
                    yearPeriod.setYearNumber(member.getNumber());
                }
                this.yearPeriodIdMap.put(id, yearPeriod);
                ListSelectedRow row = new ListSelectedRow((Object)id);
                HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
                dataMap.put("scope", selectedPeriod.getScope());
                row.setDataMap(dataMap);
                rows.add((Object)row);
            }
        }
        return rows;
    }
}

