/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.model.memberref;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.model.memberref.IMemberRef;
import kd.epm.epbs.business.model.memberref.MemberRefResult;
import kd.epm.epbs.business.model.memberref.RefBean;
import kd.epm.epbs.business.olap.OlapServiceHelper;
import kd.epm.epbs.common.enums.model.BizModelTypeEnum;
import kd.epm.epbs.common.enums.model.RefBizTypeEnum;
import kd.epm.epbs.common.model.bean.BaseBean;
import kd.epm.epbs.common.model.bean.BizModelBean;
import kd.epm.epbs.common.model.bean.BizModelDimBean;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;

public class CubeDataRef
implements IMemberRef {
    @Override
    public MemberRefResult check(long modelId, long dimensionId, List<Long> memberIds, boolean isPropValue) {
        if (isPropValue) {
            return MemberRefResult.success();
        }
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
        Map bizModelMap = modelCache.getBizModelMap();
        ArrayList hasRefList = Lists.newArrayListWithExpectedSize((int)16);
        for (BizModelBean bizModelBean : bizModelMap.values()) {
            DimensionBean dimensionBean;
            Map dimMap;
            BizModelDimBean bizModelDimBean;
            if (bizModelBean.getBizModelType() != BizModelTypeEnum.MUITL || StringUtils.isEmpty((String)bizModelBean.getCube()) || !OlapServiceHelper.isExistCube(bizModelBean.getCube(), modelId) || (bizModelDimBean = (BizModelDimBean)(dimMap = bizModelBean.getDimMap()).get(dimensionId)) == null || (dimensionBean = modelCache.getDimensionById(dimensionId)) == null) continue;
            List viewIds = bizModelDimBean.getViewIds();
            EpbsMemberCache epbsMemberCache = EpbsMemberCacheHelper.get((long)modelId, (long)dimensionId);
            List members = epbsMemberCache.getMembers(memberIds);
            Map<String, MemberBean> memberBeanMap = members.stream().filter(o -> viewIds.contains(o.getViewId())).collect(Collectors.toMap(BaseBean::getNumber, o -> o, (oldValue, newValue) -> newValue));
            if (memberBeanMap.isEmpty()) continue;
            Map<String, Boolean> memberMap = OlapServiceHelper.queryData(bizModelBean.getCube(), new ArrayList<String>(memberBeanMap.keySet()), dimensionBean.getNumber(), modelId);
            for (Map.Entry<String, Boolean> entry : memberMap.entrySet()) {
                MemberBean memberBean;
                if (!entry.getValue().booleanValue() || (memberBean = memberBeanMap.get(entry.getKey())) == null) continue;
                hasRefList.add(new RefBean(memberBean.getId(), bizModelBean.getNumber(), bizModelBean.getNameString()));
            }
        }
        if (!hasRefList.isEmpty()) {
            return MemberRefResult.fail(hasRefList);
        }
        return MemberRefResult.success();
    }

    @Override
    public RefBizTypeEnum getMemberRefBizType() {
        return RefBizTypeEnum.CUBEDATA;
    }
}

