/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.model.memberref;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.CollectionUtils;
import kd.epm.epbs.business.model.memberref.CubeDataRef;
import kd.epm.epbs.business.model.memberref.IMemberRef;
import kd.epm.epbs.business.model.memberref.MemberRefResult;
import kd.epm.epbs.business.model.memberref.RefBean;
import kd.epm.epbs.business.model.memberref.RelationDataRef;
import kd.epm.epbs.common.configuration.enums.AppConfigPropEnum;
import kd.epm.epbs.common.configuration.enums.IAppConfigProp;
import kd.epm.epbs.common.configuration.factory.ConfigurationContext;
import kd.epm.epbs.common.enums.model.RefBizTypeEnum;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.bean.PropValueBean;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsPropCache;
import kd.epm.epbs.common.model.cache.EpbsPropCacheHelper;
import kd.epm.epbs.common.util.ReflectUtils;

public class MemberRefHelper {
    protected static final List<IMemberRef> memberRefList = new ArrayList<IMemberRef>(10);
    private long modelId;
    private long dimensionId;
    private boolean isPropValue = false;

    public boolean isPropValue() {
        return this.isPropValue;
    }

    public void setPropValue(boolean propValue) {
        this.isPropValue = propValue;
    }

    public static MemberRefHelper getInstance(long modelId, long dimensionId) {
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
        String clazz = ConfigurationContext.INSTANCE.loadProp(modelCache.getModel().getSrcAppNum(), (IAppConfigProp)AppConfigPropEnum.MEMBERREF_CACHE_CLASS);
        MemberRefHelper memberRefHelper = (MemberRefHelper)ReflectUtils.newInstance((String)clazz);
        memberRefHelper.modelId = modelId;
        memberRefHelper.dimensionId = dimensionId;
        return memberRefHelper;
    }

    public void setDimensionId(long dimensionId) {
        this.dimensionId = dimensionId;
    }

    public MemberRefResult hasRef(long memberId) {
        return this.hasRef(Collections.singletonList(memberId));
    }

    public MemberRefResult hasRef(List<Long> memberIds) {
        for (IMemberRef memberRef : memberRefList) {
            MemberRefResult memberRefResult = this.hasRef(memberIds, memberRef);
            if (!memberRefResult.isHasRef()) continue;
            return memberRefResult;
        }
        return MemberRefResult.success();
    }

    public MemberRefResult hasRef(long memberId, IMemberRef memberRef) {
        return this.hasRef(Collections.singletonList(memberId), memberRef);
    }

    public MemberRefResult hasRef(List<Long> memberIds, IMemberRef memberRef) {
        if (CollectionUtils.isEmpty(memberIds)) {
            return MemberRefResult.success();
        }
        int size = 10000;
        int page = memberIds.size() / size + 1;
        for (int i = 0; i < page; ++i) {
            int start = i * size;
            int end = Math.min(memberIds.size(), start + size);
            MemberRefResult memberRefResult = memberRef.check(this.modelId, this.dimensionId, memberIds.subList(start, end), this.isPropValue);
            if (!memberRefResult.isHasRef()) continue;
            List<RefBean> hasRefList = memberRefResult.getHasRefList();
            if (memberRefResult.getMsg() == null && CollectionUtils.isNotEmpty(hasRefList)) {
                RefBizTypeEnum memberRefBizType = memberRef.getMemberRefBizType();
                StringBuilder stringBuilder = new StringBuilder();
                for (RefBean refBean : hasRefList) {
                    String bizMag = refBean.getBizMsg();
                    if (bizMag == null) {
                        bizMag = memberRefBizType.getName().getLocaleString() + refBean.getBizNumber() + " " + refBean.getBizName();
                        refBean.setBizMsg(bizMag);
                    }
                    if (this.isPropValue) {
                        EpbsPropCache epbsPropCache = EpbsPropCacheHelper.get((long)this.modelId, (long)this.dimensionId);
                        PropValueBean propValue = epbsPropCache.getPropValue(refBean.getMemberId());
                        if (propValue == null) continue;
                        stringBuilder.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u503c\u201c%1$s\u201d\u88ab\u201d%2$s\u201c\u5f15\u7528\uff0c", (String)"MemberRefHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]), propValue.getNumber() + " " + propValue.getNameString(), bizMag));
                        continue;
                    }
                    EpbsMemberCache epbsMemberCache = EpbsMemberCacheHelper.get((long)this.modelId, (long)this.dimensionId);
                    MemberBean member = epbsMemberCache.getMember(refBean.getMemberId());
                    if (member == null) continue;
                    stringBuilder.append(String.format(ResManager.loadKDString((String)"\u6210\u5458\u201c%1$s\u201c\u88ab\u201c%2$s\u201c\u5f15\u7528\uff0c", (String)"MemberRefHelper_2", (String)"epm-epbs-business", (Object[])new Object[0]), member.getNumber() + " " + member.getNameString(), bizMag));
                }
                memberRefResult.setMsg(stringBuilder.toString());
            }
            return memberRefResult;
        }
        return MemberRefResult.success();
    }

    static {
        memberRefList.add(new CubeDataRef());
        memberRefList.add(new RelationDataRef());
    }
}

