/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.model.view.bean.utils;

import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.epbs.business.model.view.bean.vo.MemberExcelVO;
import kd.epm.epbs.business.model.view.context.IMemberContext;
import kd.epm.epbs.business.model.view.context.SaveMemberContext;
import kd.epm.epbs.common.enums.DataTypeEnum;
import kd.epm.epbs.common.enums.model.MemberSourceTypeEnum;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.util.DynamicObjectUtils;
import kd.epm.epbs.common.util.IDUtils;

public class MemberVoUtils {
    private final IMemberContext context;
    private Boolean customProperty = null;

    protected IMemberContext getContext() {
        return this.context;
    }

    public MemberVoUtils(IMemberContext context) {
        this.context = context;
    }

    public String getFields() {
        String fields = "id,number,name,longnumber,shownumber,aggoprt,sourcetype,datatype,isleaf,level,dseq,description,modifier,modifytime,parent.id,shortname,member,enable,dimension";
        if (this.getContext().hasCustomProperty()) {
            // empty if block
        }
        return fields;
    }

    public MemberExcelVO toMember(int index, Map<Integer, String> rowData) {
        String description;
        if (rowData == null) {
            return null;
        }
        MemberExcelVO member = this.createExcelVo();
        member.setRowIndex(index);
        member.setNumber(rowData.get(0));
        member.setName(rowData.get(1));
        member.setParentNumber(rowData.get(2));
        String shortName = rowData.get(3);
        member.setShortName(shortName == null ? "" : shortName);
        if (this.getContext() instanceof SaveMemberContext) {
            member.transAggoprt(rowData.get(4));
        }
        member.setDescription((description = rowData.get(5)) == null ? "" : description);
        member.setViewId(this.getContext().getViewId());
        return member;
    }

    public MemberExcelVO createExcelVo() {
        return new MemberExcelVO();
    }

    public boolean checkUpdate(MemberExcelVO excelVO, MemberBean current) {
        return !Objects.equals(excelVO.getName(), current.getName()) || !Objects.equals(excelVO.getDescription(), current.getDesc()) || !Objects.equals(excelVO.getLocaleShortName(), current.getBaseMemberBean().getShortName()) || !Objects.equals(excelVO.getAggoprt(), current.getAggoprt().getValue()) || this.checkCustomProperty(excelVO, current);
    }

    protected boolean hasCustomProperty() {
        if (this.customProperty == null) {
            this.customProperty = false;
        }
        return this.customProperty;
    }

    protected boolean checkCustomProperty(MemberExcelVO excelVO, MemberBean current) {
        if (!this.hasCustomProperty()) {
            return false;
        }
        return false;
    }

    public DynamicObject toMemberObject(MemberExcelVO excelVO, Map<Object, DynamicObject> updateObjects) {
        if (!excelVO.isAddNew() && !excelVO.isUpdate()) {
            return null;
        }
        DynamicObject object = this.getObject(excelVO, updateObjects);
        this.dealBasePropInfo(excelVO, object);
        if (excelVO.isUpdate()) {
            object.set("id", (Object)excelVO.getId());
        } else {
            if (IDUtils.isNull((Long)excelVO.getId())) {
                excelVO.setId(DBServiceHelper.genGlobalLongId());
            }
            object.set("id", (Object)excelVO.getId());
            this.dealAddNewBasePropInfo(excelVO, object);
            object.set("creator", (Object)this.getContext().getUserId());
            object.set("createtime", (Object)this.getContext().getTime());
            object.set("sourcetype", (Object)MemberSourceTypeEnum.FILEIMPORT.getValue());
            object.set("reftype", (Object)"0");
            object.set("datatype", (Object)DataTypeEnum.DEFAULT.getCode());
            object.set("dseq", (Object)excelVO.getSeq());
            object.set("parent", (Object)excelVO.getParentId());
        }
        object.set("level", (Object)excelVO.getLevel());
        object.set("longnumber", (Object)excelVO.getLongNumber());
        object.set("modifier", (Object)this.getContext().getUserId());
        object.set("modifytime", (Object)this.getContext().getTime());
        object.set("description", (Object)excelVO.getDescription());
        object.set("shortname", (Object)excelVO.getShortName());
        object.set("enable", (Object)(excelVO.isEnable() ? "1" : "0"));
        object.set("isleaf", (Object)excelVO.isLeaf());
        this.dealCustomProperty(excelVO, object);
        return object;
    }

    protected DynamicObject getObject(MemberExcelVO excelVO, Map<Object, DynamicObject> updateObjects) {
        return excelVO.isUpdate() ? updateObjects.get(excelVO.getId()) : DynamicObjectUtils.newDynamicObject((String)this.getContext().getMemberModel());
    }

    protected void dealAddNewBasePropInfo(MemberExcelVO excelVO, DynamicObject object) {
        object.set("model", (Object)this.getContext().getModel().getId());
        object.set("dimension", (Object)this.getContext().getDimensionId());
        object.set("view", (Object)this.getContext().getViewId());
        object.set("viewgp", (Object)this.getContext().getView().getGroupId());
        object.set("number", (Object)excelVO.getNumber());
    }

    protected void dealBasePropInfo(MemberExcelVO excelVO, DynamicObject object) {
        object.set("name", (Object)excelVO.getName());
        object.set("shortname", (Object)excelVO.getShortName());
        object.set("longnumber", (Object)excelVO.getLongNumber());
        object.set("shownumber", (Object)excelVO.getNumber());
        object.set("aggoprt", (Object)excelVO.getAggoprt());
        object.set("modifier", (Object)this.getContext().getUserId());
    }

    protected void dealCustomProperty(MemberExcelVO excelVO, DynamicObject object) {
    }
}

