/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.model.view.context;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.lang.Lang;
import kd.epm.epbs.business.model.view.context.IMemberContext;
import kd.epm.epbs.business.model.view.context.MemberOperEnum;
import kd.epm.epbs.common.enums.model.DimTypeEnum;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.bean.ModelBean;
import kd.epm.epbs.common.model.bean.PropBean;
import kd.epm.epbs.common.model.bean.ViewBean;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsPropCache;
import kd.epm.epbs.common.model.cache.EpbsPropCacheHelper;
import kd.epm.epbs.common.util.UserUtils;
import org.jetbrains.annotations.NotNull;

public class MemberContext
implements IMemberContext {
    private final EpbsModelCache modelCache;
    private EpbsMemberCache memberCache;
    private EpbsPropCache propCache = null;
    private final String dimNumber;
    private final String memberModel;
    private final String memberTable;
    private final Long dimensionId;
    private final Long viewId;
    private Long datasetId = null;
    private final Long userId;
    private final Date date;
    private final Lang lang;
    private boolean checkPermission = true;
    private Long permissionUserId = null;
    private Boolean customProperty = null;
    private List<PropBean> properties = null;
    private DimensionBean dimension = null;
    private ViewBean view = null;
    private MemberOperEnum operation = MemberOperEnum.ADD;

    @Override
    public void setCheckPermission(boolean checkPermission) {
        this.checkPermission = checkPermission;
    }

    @Override
    public boolean isCheckPermission() {
        return this.checkPermission;
    }

    @Override
    public void setPermissionUserId(Long permissionUserId) {
        this.permissionUserId = permissionUserId;
    }

    @Override
    public Long getPermissionUserId() {
        return this.permissionUserId;
    }

    public MemberContext(@NotNull EpbsModelCache modelCache, @NotNull String dimNumber, String memberModel, String memberTable, Long viewId) {
        this.modelCache = modelCache;
        this.dimNumber = dimNumber;
        this.memberModel = memberModel;
        this.memberTable = memberTable;
        this.viewId = viewId;
        this.dimensionId = modelCache.getDimension(dimNumber).getId();
        this.userId = UserUtils.getUserId();
        this.lang = RequestContext.get().getLang();
        this.date = new Date();
    }

    @Override
    public EpbsModelCache getModelCache() {
        return this.modelCache;
    }

    @Override
    public EpbsMemberCache getMemberCache() {
        if (this.memberCache == null) {
            this.memberCache = EpbsMemberCacheHelper.get((long)this.modelCache.getModel().getId(), (long)this.getDimensionId());
        }
        return this.memberCache;
    }

    @Override
    public EpbsPropCache getPropCache() {
        if (this.propCache == null) {
            this.propCache = EpbsPropCacheHelper.get((long)this.getModel().getId(), (long)this.getDimensionId());
        }
        return this.propCache;
    }

    @Override
    public boolean hasCustomProperty() {
        if (this.customProperty == null) {
            long dimTypeId = this.getDimension().getDimTypeId();
            DimTypeBean dimType = this.getModelCache().getDimTypeById(dimTypeId);
            DimTypeEnum dimTypeEnum = DimTypeEnum.getDimType((String)dimType.getType());
            if (dimTypeEnum != null) {
                this.customProperty = dimTypeEnum.isHasCustomProperty();
            }
        }
        return this.customProperty;
    }

    @Override
    public List<PropBean> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<PropBean>(this.getPropCache().getProps());
        }
        return this.properties;
    }

    @Override
    public ModelBean getModel() {
        return (ModelBean)this.getModelCache().getModel();
    }

    @Override
    public String getDimNumber() {
        return this.dimNumber;
    }

    @Override
    public Long getDimensionId() {
        return this.dimensionId;
    }

    @Override
    public String getMemberModel() {
        return this.memberModel;
    }

    @Override
    public String getMemberTable() {
        return this.memberTable;
    }

    @Override
    public DimensionBean getDimension() {
        if (this.dimension == null) {
            this.dimension = this.getModelCache().getDimensionById(this.getDimensionId().longValue());
        }
        return this.dimension;
    }

    @Override
    public Long getViewId() {
        return this.viewId;
    }

    @Override
    public ViewBean getView() {
        if (this.view == null) {
            this.view = this.getModelCache().getViewById(this.getViewId().longValue());
        }
        return this.view;
    }

    @Override
    public void setDatasetId(Long datasetId) {
        this.datasetId = datasetId;
    }

    @Override
    public Long getDatasetId() {
        return this.datasetId;
    }

    @Override
    public Long getUserId() {
        return this.userId;
    }

    @Override
    public Date getTime() {
        return this.date;
    }

    @Override
    public Lang getLang() {
        return this.lang;
    }

    @Override
    public void setOperationType(MemberOperEnum operation) {
        this.operation = operation;
    }

    @Override
    public MemberOperEnum getOperationType() {
        if (this.operation == null) {
            this.operation = MemberOperEnum.ADD;
        }
        return this.operation;
    }
}

