/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.model.view.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.model.dimension.DimensionServiceHelper;
import kd.epm.epbs.business.model.view.bean.utils.MemberVoUtils;
import kd.epm.epbs.business.model.view.bean.vo.IMemberVO;
import kd.epm.epbs.business.model.view.bean.vo.MemberExcelVO;
import kd.epm.epbs.business.model.view.bean.vo.MemberVO;
import kd.epm.epbs.business.model.view.context.MemberOperEnum;
import kd.epm.epbs.business.model.view.context.SaveMemberContext;
import kd.epm.epbs.business.model.view.valid.IMemberValidator;
import kd.epm.epbs.business.model.view.valid.MemberBaseExcelImportValidator;
import kd.epm.epbs.business.model.view.valid.MemberExtExcelImportValidator;
import kd.epm.epbs.business.model.view.valid.MemberValidator;
import kd.epm.epbs.business.model.view.valid.ValidResult;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.util.DynamicObjectUtils;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epbs.common.util.QFBuilder;
import org.jetbrains.annotations.NotNull;

public class MemberExcelImportHandler {
    public static final Log log = LogFactory.getLog(MemberExcelImportHandler.class);
    private final String[] MEMBER_FIELDS = new String[]{"dimension", "number", "shownumber", "name", "shortname", "description", "sourcetype", "datatype"};
    private final SaveMemberContext context;
    private Set<String> refNumbers = null;
    private MemberValidator validator = null;
    public static final int HEAD_ROW_INDEX = 2;
    public static final int DATA_ROW_INDEX = 3;
    private final Set<String> saveMemberNumbers = Sets.newLinkedHashSet();

    protected SaveMemberContext getContext() {
        return this.context;
    }

    protected EpbsModelCache getModelCache() {
        return this.getContext().getModelCache();
    }

    protected Long getModelId() {
        return this.getModelCache().getModel().getId();
    }

    protected String getDimNumber() {
        return this.getContext().getDimNumber();
    }

    protected Long getDimensionId() {
        return this.getContext().getDimensionId();
    }

    protected Long getViewId() {
        return this.getContext().getViewId();
    }

    public void setRefNumbers(Set<String> refNumbers) {
        this.refNumbers = refNumbers;
    }

    public Set<String> getRefNumbers() {
        return this.refNumbers;
    }

    protected MemberValidator getValidator() {
        if (this.validator == null) {
            this.validator = MemberBaseExcelImportValidator.getValidator(this.getModelCache(), this.getDimNumber(), this.getViewId());
            this.validator.setRefNumbers(this.getRefNumbers());
            this.validator.registerValidator(this.getExtExcelImportValidator(this.getContext()));
        }
        return this.validator;
    }

    public MemberExcelImportHandler(SaveMemberContext context) {
        this.context = context;
    }

    protected int getHeadRowIndex() {
        return 2;
    }

    protected int getBeginDataRowIndex() {
        return 3;
    }

    protected int getMaxRowCount() {
        return 500000;
    }

    public Set<String> getSaveMemberNumbers() {
        return this.saveMemberNumbers;
    }

    public void execute(List<Map<Integer, String>> rows, List<ValidResult<String>> workBookValid) {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        MemberVoUtils voUtils = this.getContext().getVoUtils();
        ValidResult<String> valid = new ValidResult<String>();
        workBookValid.add(valid);
        List<IMemberVO> members = this.transMembers(rows, valid, voUtils);
        if (CollectionUtils.isNotEmpty(members)) {
            int size = 10000;
            int page = members.size() / size + 1;
            for (int i = 0; i < page; ++i) {
                int start = i * size;
                int end = Math.min(members.size(), start + size);
                this.save(members.subList(start, end));
            }
        }
    }

    protected IMemberValidator getExtExcelImportValidator(SaveMemberContext context) {
        return MemberExtExcelImportValidator.get(context);
    }

    protected List<IMemberVO> transMembers(List<Map<Integer, String>> rows, ValidResult<String> workValid, MemberVoUtils voUtils) {
        ValidResult<String> _tmpValids;
        LinkedList members = Lists.newLinkedList();
        for (int i = 0; i < rows.size(); ++i) {
            MemberExcelVO member;
            Map<Integer, String> row = rows.get(i);
            if (i > this.getMaxRowCount()) break;
            if (i < this.getBeginDataRowIndex() || row.isEmpty() || (member = voUtils.toMember(i, row)) == null) continue;
            this.syncCurrentMemberData(member);
            if (this.getContext().getOperationType() == MemberOperEnum.ADD && !member.isAddNew()) {
                workValid.addValidResult(i, ResManager.loadKDString((String)"\u8be5\u7f16\u7801\u5df2\u5b58\u5728\u4e8e\u7cfb\u7edf\u4e2d\u3002", (String)"MemberExcelImportHandler_1", (String)"epm-epbs-business", (Object[])new Object[0]));
                continue;
            }
            members.add(member);
            _tmpValids = this.getValidator().valid(member);
            if (_tmpValids.isOk()) continue;
            workValid.setOk(_tmpValids.isOk());
            workValid.getValidResultMap().put(String.valueOf(i), _tmpValids.getErrMsg());
        }
        if (workValid.isOk()) {
            LinkedHashMap memberVOMap = Maps.newLinkedHashMapWithExpectedSize((int)members.size());
            members.forEach(m -> memberVOMap.put(m.getNumber(), m));
            _tmpValids = this.getValidator().batchValid(memberVOMap);
            if (!_tmpValids.isOk()) {
                workValid.setOk(_tmpValids.isOk());
                workValid.setErrMsg(_tmpValids.getErrMsg());
                workValid.getValidResultMap().putAll(_tmpValids.getValidResultMap());
            } else if (memberVOMap.size() != members.size()) {
                members.clear();
                members.addAll(memberVOMap.values());
            }
        }
        return workValid.isOk() ? members : null;
    }

    protected void syncCurrentMemberData(MemberExcelVO memberExcelVO) {
        MemberBean dbMember = this.getValidator().getDbDimMemberMap().get(memberExcelVO.getNumber());
        if (dbMember != null) {
            memberExcelVO.setId(dbMember.getId());
            memberExcelVO.setLevel(dbMember.getLevel());
            memberExcelVO.setLongNumber(dbMember.getLongNumber());
        }
        memberExcelVO.checkAddNewOrUpdate(this.getContext().getVoUtils(), dbMember);
        MemberBean parentMember = this.getValidator().getDbDimMemberMap().get(memberExcelVO.getParentNumber());
        if (parentMember != null) {
            memberExcelVO.setParentId(parentMember.getId());
        } else if (StringUtils.isEmpty((String)memberExcelVO.getParentNumber())) {
            MemberBean rootMember = this.getContext().getModelCache().getRoot(this.getContext().getDimNumber(), this.getContext().getViewId().longValue());
            memberExcelVO.setParentNumber(rootMember.getNumber());
            memberExcelVO.setParentId(rootMember.getId());
        }
    }

    public void save(List<IMemberVO> members) {
        MemberExcelVO excelVO;
        if (members == null || members.isEmpty()) {
            return;
        }
        MemberVoUtils voUtils = this.getContext().getVoUtils();
        LinkedHashMap saveMembers = Maps.newLinkedHashMap();
        LinkedHashMap addNewMembers = Maps.newLinkedHashMap();
        LinkedHashMap addBaseMembers = Maps.newLinkedHashMap();
        LinkedHashMap upBaseMembers = Maps.newLinkedHashMap();
        LinkedList upParentMembers = Lists.newLinkedList();
        LinkedHashSet oldUpParentIds = Sets.newLinkedHashSet();
        for (IMemberVO _member : members) {
            excelVO = (MemberExcelVO)_member;
            if (!excelVO.isUpdateParent()) continue;
            oldUpParentIds.add(excelVO.getOldParentId());
            upParentMembers.add(excelVO);
        }
        Map<Object, DynamicObject> updateObjects = this.getUpdateObject(members, voUtils);
        LinkedHashSet baseMemberIds = Sets.newLinkedHashSet();
        for (IMemberVO _member : members) {
            excelVO = (MemberExcelVO)_member;
            DynamicObject object = voUtils.toMemberObject(excelVO, updateObjects);
            if (object == null) continue;
            this.getSaveMemberNumbers().add(excelVO.getNumber());
            if (excelVO.isUpdate()) {
                saveMembers.put(object.getLong("id"), object);
                baseMemberIds.add(object.getLong("member.id"));
                continue;
            }
            addNewMembers.put(object.getLong("id"), object);
        }
        EpbsModelCache modelCache = this.getModelCache();
        DimensionBean dimension = this.getContext().getDimension();
        DimTypeBean dimType = modelCache.getDimTypeById(dimension.getDimTypeId());
        if (!saveMembers.isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", (Object)baseMemberIds);
            DynamicObject[] baseMembers = BusinessDataServiceHelper.load((String)dimType.getBaseMemberModel(), (String)"id,name, shortname, description", (QFilter[])qFilter.toArray());
            Map<Long, DynamicObject> baseMemberMap = Arrays.stream(baseMembers).collect(Collectors.toMap(o -> o.getLong("id"), o -> o, (key1, key2) -> key2));
            for (DynamicObject saveMember : saveMembers.values()) {
                DynamicObject baseMember = baseMemberMap.get(saveMember.getLong("member_id"));
                if (baseMember == null) continue;
                baseMember.set("name", saveMember.get("name"));
                baseMember.set("shortname", saveMember.get("shortname"));
                baseMember.set("description", saveMember.get("description"));
                upBaseMembers.put(baseMember.getLong("id"), baseMember);
            }
        }
        if (!addNewMembers.isEmpty()) {
            for (DynamicObject addNewMember : addNewMembers.values()) {
                DynamicObject baseMember = BusinessDataServiceHelper.newDynamicObject((String)dimType.getBaseMemberModel());
                baseMember.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                for (String memberField : this.MEMBER_FIELDS) {
                    baseMember.set(memberField, addNewMember.get(memberField));
                }
                addBaseMembers.put(baseMember.getLong("id"), baseMember);
                addNewMember.set("member", (Object)baseMember);
            }
        }
        upParentMembers.sort(Comparator.comparing(MemberVO::getOldLevel));
        try (TXHandle tx = TX.requiresNew((String)"importMemberSave");){
            try {
                DynamicObjectUtils.save(new ArrayList(addNewMembers.values()));
                DynamicObjectUtils.save(new ArrayList(saveMembers.values()));
                DynamicObjectUtils.save(new ArrayList(addBaseMembers.values()));
                DynamicObjectUtils.save(new ArrayList(upBaseMembers.values()));
                if (!(addNewMembers.isEmpty() && saveMembers.isEmpty() && addBaseMembers.isEmpty() && upBaseMembers.isEmpty())) {
                    DimensionServiceHelper.updateIsLeafByParentId(this.getParentIds(addNewMembers.values(), saveMembers.values(), oldUpParentIds), this.getModelId(), this.getContext().getDimensionId(), this.getContext().getMemberModel());
                    MemberExcelImportHandler.clearEntityCache(dimType.getMemberTreemodel());
                    MemberExcelImportHandler.clearEntityCache(dimType.getBaseMemberModel());
                }
            }
            catch (Throwable ex) {
                log.error("MemberExcelImportHandler-error:", ex);
                tx.markRollback();
                throw new KDBizException(ex.getMessage());
            }
        }
    }

    protected Map<Object, DynamicObject> getUpdateObject(List<IMemberVO> members, MemberVoUtils voUtils) {
        if (members == null || members.isEmpty()) {
            return Collections.emptyMap();
        }
        Set memberIds = members.stream().filter(m -> ((MemberExcelVO)m).isUpdate()).map(IMemberVO::getId).collect(Collectors.toSet());
        if (memberIds.isEmpty()) {
            return Collections.emptyMap();
        }
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)this.getContext().getModel().getId());
        builder.add("dimension", "=", (Object)this.getContext().getDimensionId());
        builder.add("id", "in", memberIds);
        DynamicObject[] object = BusinessDataServiceHelper.load((String)this.getContext().getMemberModel(), (String)voUtils.getFields(), (QFilter[])builder.toArray());
        return Stream.of(object).collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
    }

    protected Long[] getParentIds(Collection<DynamicObject> newMembers, Collection<DynamicObject> upMembers, Set<Long> upParentIds) {
        LinkedHashSet memberIds = Sets.newLinkedHashSet();
        if (newMembers != null && !newMembers.isEmpty()) {
            memberIds.addAll(newMembers.stream().map(m -> m.getLong("parent_id")).collect(Collectors.toSet()));
        }
        if (upMembers != null && !upMembers.isEmpty()) {
            memberIds.addAll(upMembers.stream().map(m -> m.getLong("parent_id")).collect(Collectors.toSet()));
        }
        if (upParentIds != null) {
            memberIds.addAll(upParentIds);
        }
        return memberIds.toArray(new Long[0]);
    }

    public static void clearEntityCache(@NotNull String entityNumber) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)dataEntityType);
        cacheManager.removeByDt();
        cacheManager.removeByFilterDt();
    }
}

