/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.model.view.valid;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.epbs.business.model.view.bean.vo.IMemberVO;
import kd.epm.epbs.business.model.view.bean.vo.MemberExcelVO;
import kd.epm.epbs.business.model.view.valid.MemberValidator;
import kd.epm.epbs.business.model.view.valid.ValidResult;
import kd.epm.epbs.common.model.cache.EpbsModelCache;

public class MemberBaseExcelImportValidator
extends MemberValidator {
    private final Set<String> memberNums = Sets.newLinkedHashSet();

    public MemberBaseExcelImportValidator(EpbsModelCache modelCache, String dimNumber, Long viewId) {
        super(modelCache, dimNumber, viewId);
    }

    public static MemberValidator getValidator(EpbsModelCache modelCache, String dimNumber, Long viewId) {
        return new MemberBaseExcelImportValidator(modelCache, dimNumber, viewId);
    }

    protected Set<String> getMemberNums() {
        return this.memberNums;
    }

    @Override
    public void validNumber(MemberExcelVO saveMember) {
        super.validNumber(saveMember);
        if (!this.getMemberNums().add(saveMember.getNumber())) {
            String errorTag = ResManager.loadKDString((String)"\u8be5\u7f16\u7801\u5728\u5bfc\u5165\u6587\u4ef6\u4e2d\u5b58\u5728\u91cd\u590d\u3002", (String)"MemberBaseExcelImportValidator_1", (String)"epm-epbs-business", (Object[])new Object[0]);
            throw new KDBizException(errorTag);
        }
    }

    @Override
    public ValidResult<String> batchValid(Map<String, IMemberVO> members) {
        ValidResult<String> valid = super.batchValid(members);
        if (valid.isOk()) {
            // empty if block
        }
        return valid;
    }
}

