/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.model.view.valid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.model.view.bean.vo.IMemberVO;
import kd.epm.epbs.business.model.view.bean.vo.MemberExcelVO;
import kd.epm.epbs.business.model.view.context.IMemberContext;
import kd.epm.epbs.business.model.view.valid.AbstractValidator;
import kd.epm.epbs.business.model.view.valid.MemberAddNewValidUtil;
import kd.epm.epbs.business.model.view.valid.MemberSaveValidUtil;
import kd.epm.epbs.business.model.view.valid.ValidResult;
import kd.epm.epbs.business.olap.OlapServiceHelper;
import kd.epm.epbs.common.constant.SystemSeparator;
import kd.epm.epbs.common.enums.model.AggoprtEnum;
import kd.epm.epbs.common.enums.model.BizModelTypeEnum;
import kd.epm.epbs.common.model.bean.BizModelBean;
import kd.epm.epbs.common.model.bean.BizModelDimBean;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.util.IDUtils;

public class MemberExtExcelImportValidator
extends AbstractValidator {
    public static MemberExtExcelImportValidator get(IMemberContext context) {
        return new MemberExtExcelImportValidator(context);
    }

    public MemberExtExcelImportValidator(IMemberContext context) {
        super(context);
    }

    public ValidResult<String> valid(IMemberVO member) {
        ValidResult<String> result;
        try {
            result = this.$valid(member);
        }
        catch (KDBizException ex) {
            result = new ValidResult(ex.getMessage());
        }
        return result;
    }

    protected ValidResult<String> $valid(IMemberVO member) {
        MemberExcelVO _excelVo = (MemberExcelVO)member;
        String number = _excelVo.getNumber();
        String parentNumber = _excelVo.getParentNumber();
        if (parentNumber.indexOf(13) >= 0 || parentNumber.indexOf(10) >= 0 || parentNumber.contains(" ")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7f16\u7801\u5b58\u5728\u6362\u884c\u7b26\u6216\u8005\u7a7a\u683c\u3002", (String)"MemberExtExcelImportValidator_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        if (parentNumber.equalsIgnoreCase(number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7f16\u7801\u4e0d\u53ef\u4e0e\u81ea\u8eab\u7f16\u7801\u76f8\u540c\u3002", (String)"MemberExtExcelImportValidator_2", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        MemberBean dbMember = this.getMemValidator().getDbDimMemberMap().get(member.getNumber());
        if (dbMember != null && !Objects.equals(_excelVo.getParentId(), dbMember.getParentId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u7ea7\u6210\u5458\u4e0e\u7cfb\u7edf\u4e2d\u8bbe\u7f6e\u7684\u4e0a\u7ea7\u4e0d\u4e00\u81f4\u3002", (String)"MemberExtExcelImportValidator_3", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        MemberBean parent = this.getMemValidator().getDbDimMemberMap().get(parentNumber);
        if (parent != null) {
            String checkMsg;
            if (_excelVo.isAddNew() && (checkMsg = MemberAddNewValidUtil.checkByImport(this.getContext().getModelCache(), this.getContext().getMemberCache(), parent.getId())) != null) {
                throw new KDBizException(checkMsg);
            }
            if (!Objects.equals(this.getContext().getViewId(), parent.getViewId())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u7ea7\u6210\u5458\u7684\u89c6\u56fe\u4e0d\u4e00\u81f4\u3002", (String)"MemberExtExcelImportValidator_4", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            checkMsg = MemberSaveValidUtil.checkLongNumber(parent.getLongNumber(), number);
            if (checkMsg != null) {
                throw new KDBizException(checkMsg);
            }
            _excelVo.setLevel(parent.getLevel() + 1);
            _excelVo.setParentId(parent.getId());
            _excelVo.setLongNumber(parent.getLongNumber() + SystemSeparator.LONGNUMBER_SEPARAROT + number);
        }
        if (StringUtils.isEmpty((String)_excelVo.getAggoprt())) {
            _excelVo.setAggoprt(AggoprtEnum.ADD.getValue());
        }
        return ValidResult.SUCCEED;
    }

    public ValidResult<String> batchValid(Map<String, IMemberVO> members) {
        ValidResult<String> result;
        try {
            result = this.$batchValid(members);
            if (result.isOk()) {
                this.beforeBatch(members);
            }
        }
        catch (KDBizException ex) {
            result = new ValidResult(ex.getMessage());
        }
        return result;
    }

    protected ValidResult<String> $batchValid(Map<String, IMemberVO> members) {
        ValidResult<String> result = new ValidResult<String>();
        HashMap<String, MemberExcelVO> numberMemberMap = new HashMap<String, MemberExcelVO>(16000);
        for (IMemberVO member : members.values()) {
            this.dealCurrentMemberParent((MemberExcelVO)member, members, result);
            MemberBean parent = this.getMemValidator().getDbDimMemberMap().get(member.getParentNumber());
            if (parent == null || !parent.isLeaf()) continue;
            numberMemberMap.put(parent.getNumber(), (MemberExcelVO)member);
        }
        EpbsModelCache modelCache = this.getContext().getModelCache();
        long modelId = modelCache.getModel().getId();
        Long dimensionId = this.getContext().getDimensionId();
        Map bizModelMap = modelCache.getBizModelMap();
        for (BizModelBean bizModelBean : bizModelMap.values()) {
            DimensionBean dimensionBean;
            Map dimMap;
            BizModelDimBean bizModelDimBean;
            if (bizModelBean.getBizModelType() != BizModelTypeEnum.MUITL || StringUtils.isEmpty((String)bizModelBean.getCube()) || !OlapServiceHelper.isExistCube(bizModelBean.getCube(), modelId) || (bizModelDimBean = (BizModelDimBean)(dimMap = bizModelBean.getDimMap()).get(dimensionId)) == null || (dimensionBean = modelCache.getDimensionById(dimensionId.longValue())) == null) continue;
            Map<String, Boolean> memberMap = OlapServiceHelper.queryData(bizModelBean.getCube(), new ArrayList<String>(numberMemberMap.keySet()), dimensionBean.getNumber(), modelId);
            for (Map.Entry<String, Boolean> entry : memberMap.entrySet()) {
                MemberExcelVO memberVO;
                if (!entry.getValue().booleanValue() || (memberVO = (MemberExcelVO)numberMemberMap.get(entry.getKey())) == null) continue;
                result.addValidResult(memberVO.getRowIndex(), String.format(ResManager.loadKDString((String)"%s\u5b58\u5728\u591a\u7ef4\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7", (String)"MemberExtExcelImportValidator_5", (String)"epm-epbs-business", (Object[])new Object[0]), memberVO.getNumber()));
            }
        }
        return result;
    }

    protected void dealCurrentMemberParent(MemberExcelVO current, Map<String, IMemberVO> members, ValidResult<String> result) {
        if (IDUtils.isNotNull((Long)current.getParentId())) {
            return;
        }
        MemberExcelVO parent = (MemberExcelVO)members.get(current.getParentNumber());
        if (parent == null) {
            result.addValidResult(current.getRowIndex(), String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a(%s)\u7684\u7236\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u7236\u6210\u5458\u7f16\u7801\u662f\u5426\u6b63\u786e\u3002", (String)"MemberExtExcelImportValidator_6", (String)"epm-epbs-business", (Object[])new Object[0]), current.getParentNumber()));
        } else {
            this.dealCurrentMemberParent(parent, members, result);
            String longNumber = parent.getLongNumber() + SystemSeparator.LONGNUMBER_SEPARAROT + current.getNumber();
            if (longNumber.length() > 2000) {
                result.addValidResult(current.getRowIndex(), ResManager.loadKDString((String)"\u957f\u7f16\u7801\u957f\u5ea6\u8d85\u8fc72000\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5\u5c42\u7ea7\u662f\u5426\u8fc7\u591a\u3002", (String)"MemberExtExcelImportValidator_7", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            if (IDUtils.isNull((Long)parent.getId())) {
                parent.setId(DBServiceHelper.genGlobalLongId());
            }
            current.setParentId(parent.getId());
            current.setLongNumber(longNumber);
            current.setLevel(parent.getLevel() + 1);
            if (current.getSeq() == 0) {
                int seq = this.getMemValidator().getDbSeqMap().compute(current.getParentId(), (k, v) -> v != null ? v + 1 : 1);
                current.setSeq(seq);
            }
        }
    }

    protected void beforeBatch(Map<String, IMemberVO> members) {
        for (IMemberVO _member : members.values()) {
            MemberExcelVO _excelVo = (MemberExcelVO)_member;
            MemberBean parent = this.getMemValidator().getDbDimMemberMap().get(_excelVo.getParentNumber());
            if (parent == null) {
                MemberExcelVO _parent = (MemberExcelVO)members.get(_excelVo.getParentNumber());
                _parent.setIsLeaf(false);
            }
            if (_excelVo.getSeq() != 0) continue;
            _excelVo.setSeq(this.getMemValidator().getDbSeqMap().compute(_excelVo.getParentId(), (k, v) -> v != null ? v + 1 : 1));
        }
    }
}

