/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.model.view.valid;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.epm.epbs.business.model.view.bean.vo.IMemberVO;
import kd.epm.epbs.business.model.view.bean.vo.MemberExcelVO;
import kd.epm.epbs.business.model.view.valid.IMemberValidator;
import kd.epm.epbs.business.model.view.valid.MemberSaveValidUtil;
import kd.epm.epbs.business.model.view.valid.ValidResult;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.util.BizRequire;
import kd.epm.epbs.common.util.MetaUtils;
import org.apache.commons.lang3.StringUtils;

public class MemberValidator {
    private final EpbsModelCache modelCache;
    private DimensionBean dimension = null;
    private final String dimNumber;
    private final Long viewId;
    private final Set<String> dbDimLowerNumber = Sets.newHashSet();
    private final Map<String, MemberBean> dbDimMemberMap = Maps.newHashMap();
    private final Map<Long, Integer> dbSeqMap = Maps.newLinkedHashMap();
    private boolean hasInitData;
    private Set<String> refNumbers = null;
    private final List<IMemberValidator> validators = Lists.newLinkedList();
    private DynamicObjectType dt = null;

    public void setRefNumbers(Set<String> refNumbers) {
        this.refNumbers = refNumbers;
    }

    public Set<String> getRefNumbers() {
        return this.refNumbers;
    }

    public List<IMemberValidator> getValidators() {
        return this.validators;
    }

    public void registerValidator(IMemberValidator validator) {
        if (validator != null) {
            validator.setMemValidator(this);
            this.getValidators().add(validator);
        }
    }

    public MemberValidator(EpbsModelCache modelCache, String dimNumber, Long viewId) {
        this.modelCache = modelCache;
        this.dimNumber = dimNumber;
        this.viewId = viewId;
    }

    protected EpbsModelCache getModelCache() {
        return this.modelCache;
    }

    protected DimensionBean getDimension() {
        if (this.dimension == null) {
            this.dimension = this.modelCache.getDimension(this.dimNumber);
        }
        return this.dimension;
    }

    protected Long getViewId() {
        return this.viewId;
    }

    public ValidResult<String> valid(MemberExcelVO member) {
        try {
            String name = member.getLocaleName();
            BizRequire.isTrue((boolean)StringUtils.isNotBlank((CharSequence)name), (String)ResManager.loadKDString((String)"\u540d\u79f0\u4e3a\u7a7a\uff0c\u6216\u4e0d\u662f\u6587\u672c\u5185\u5bb9\u3002", (String)"MemberValidator_1", (String)"epm-epbs-business", (Object[])new Object[0]));
            BizRequire.isFalse((boolean)StringUtils.containsAny((CharSequence)name, (CharSequence[])new CharSequence[]{"\r", "\n"}), (String)ResManager.loadKDString((String)"\u540d\u79f0\u5b58\u5728\u6362\u884c\u7b26\u3002", (String)"MemberValidator_2", (String)"epm-epbs-business", (Object[])new Object[0]));
            BizRequire.isTrue((boolean)MetaUtils.verifyMetaLength((DynamicObjectType)this.getMemberDT(), (String)"name", (String)name), (String)ResManager.loadKDString((String)"\u540d\u79f0\u8fc7\u957f\u3002", (String)"MemberValidator_3", (String)"epm-epbs-business", (Object[])new Object[0]));
            BizRequire.isTrue((boolean)MetaUtils.verifyMetaLength((DynamicObjectType)this.getMemberDT(), (String)"shortname", (String)member.getLocaleShortName()), (String)ResManager.loadKDString((String)"\u7b80\u79f0\u8fc7\u957f\u3002", (String)"MemberValidator_4", (String)"epm-epbs-business", (Object[])new Object[0]));
            this.validNumber(member);
            if (!this.getValidators().isEmpty()) {
                for (IMemberValidator _validator : this.getValidators()) {
                    ValidResult<?> _tmpValid = _validator.valid(member);
                    BizRequire.isTrue((boolean)_tmpValid.isOk(), (String)_tmpValid.getErrMsg());
                }
            }
        }
        catch (KDBizException e) {
            return new ValidResult<String>(e.getMessage());
        }
        return ValidResult.SUCCEED;
    }

    public void validNumber(MemberExcelVO saveMember) {
        String number = saveMember.getNumber();
        BizRequire.isFalse((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{number}), (String)ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u7a7a\uff0c\u6216\u4e0d\u662f\u6587\u672c\u5185\u5bb9\u3002", (String)"MemberValidator_5", (String)"epm-epbs-business", (Object[])new Object[0]));
        boolean numberContainLineBreakBoolean = StringUtils.containsAny((CharSequence)number, (CharSequence[])new CharSequence[]{"\r", "\n", " "});
        BizRequire.isFalse((boolean)numberContainLineBreakBoolean, (String)ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8f93\u5165\u7f16\u7801\uff0c\u907f\u514d\u4f7f\u7528\u6362\u884c\u7b26\u6216\u7a7a\u683c\u3002", (String)"MemberValidator_6", (String)"epm-epbs-business", (Object[])new Object[0]));
        boolean numberLengthCheck = MetaUtils.verifyMetaLength((DynamicObjectType)this.getMemberDT(), (String)"number", (String)number);
        BizRequire.isTrue((boolean)numberLengthCheck, (String)ResManager.loadKDString((String)"\u7f16\u7801\u8fc7\u957f\u3002", (String)"MemberValidator_7", (String)"epm-epbs-business", (Object[])new Object[0]));
        String msg = MemberSaveValidUtil.checkNumber(number);
        BizRequire.isFalse((msg != null ? 1 : 0) != 0, (String)msg);
        if (!saveMember.isUpdate() && saveMember.isAddNew()) {
            String lowNumber = number.toLowerCase();
            BizRequire.isFalse((boolean)this.getDbDimMemberMap().containsKey(number), (String)ResManager.loadKDString((String)"\u8be5\u7f16\u7801\u5df2\u5b58\u5728\u4e8e\u7cfb\u7edf\u4e2d\u3002", (String)"MemberValidator_8", (String)"epm-epbs-business", (Object[])new Object[0]));
            BizRequire.isFalse((boolean)this.getDbDimLowerNumber().contains(lowNumber), (String)ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u5df2\u7ecf\u5b58\u5728\u8be5\u7f16\u7801\u7684\u5927\u5199\u6216\u5c0f\u5199\u7f16\u7801\uff0c\u8bf7\u4fdd\u6301\u4e00\u81f4\u3002", (String)"MemberValidator_9", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
    }

    private void initDbMember(EpbsModelCache modelCache, String dimNumber) {
        this.hasInitData = true;
        DimensionBean dimension = modelCache.getDimension(dimNumber);
        DimTypeBean dimType = modelCache.getDimTypeById(dimension.getDimTypeId());
        String memberTreemodel = dimType.getMemberTreemodel();
        String memberTreeTable = dimType.getMemberTreeTable();
        Long modelId = modelCache.getModel().getId();
        Long dimensionId = this.getDimension().getId();
        EpbsMemberCache epbsMemberCache = EpbsMemberCacheHelper.get((long)modelId, (long)dimensionId);
        Map memberMap = epbsMemberCache.getMemberMap();
        for (MemberBean memberBean : memberMap.values()) {
            this.dbDimLowerNumber.add(memberBean.getNumber().toLowerCase());
            this.dbDimMemberMap.put(memberBean.getNumber(), memberBean);
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fparentid, max(fdseq) as fdseq from ", new Object[0]).append(memberTreeTable, new Object[0]).append(" where fmodelid = ? and fdimensionid = ? group by fparentid", new Object[]{modelId, dimensionId});
        try (DataSet ds = DB.queryDataSet((String)"querySeq", (DBRoute)modelCache.getAppDBRoute(), (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    this.dbSeqMap.put(row.getLong("fparentid"), row.getInteger("fdseq"));
                }
            }
        }
    }

    public Map<String, MemberBean> getDbDimMemberMap() {
        if (this.dbDimMemberMap.isEmpty() && !this.hasInitData) {
            this.initDbMember(this.modelCache, this.dimNumber);
        }
        return this.dbDimMemberMap;
    }

    public Set<String> getDbDimLowerNumber() {
        if (this.dbDimMemberMap.isEmpty() && !this.hasInitData) {
            this.initDbMember(this.modelCache, this.dimNumber);
        }
        return this.dbDimLowerNumber;
    }

    public Map<Long, Integer> getDbSeqMap() {
        if (this.dbSeqMap.isEmpty() && !this.hasInitData) {
            this.initDbMember(this.modelCache, this.dimNumber);
        }
        return this.dbSeqMap;
    }

    private DynamicObjectType getMemberDT() {
        if (this.dt == null) {
            EpbsModelCache modelCache = this.getModelCache();
            DimTypeBean dimType = modelCache.getDimTypeById(this.getDimension().getDimTypeId());
            this.dt = EntityMetadataCache.getDataEntityType((String)dimType.getMemberTreemodel());
        }
        return this.dt;
    }

    public ValidResult<String> batchValid(Map<String, IMemberVO> members) {
        ValidResult<String> valid = new ValidResult<String>();
        try {
            MutableGraph graph = GraphBuilder.directed().build();
            for (IMemberVO iMemberVO : members.values()) {
                graph.putEdge((Object)iMemberVO.getParentNumber(), (Object)iMemberVO.getNumber());
            }
            if (Graphs.hasCycle((Graph)graph)) {
                LinkedHashSet<String> nodePath = new LinkedHashSet<String>();
                for (String node : graph.nodes()) {
                    Set reachNodes = Graphs.reachableNodes((Graph)graph, (Object)node);
                    for (String reachNode : reachNodes) {
                        Set subReachNodes;
                        if (reachNode.equals(node) || !(subReachNodes = Graphs.reachableNodes((Graph)graph, (Object)reachNode)).contains(node)) continue;
                        this.getCyclePath((MutableGraph<String>)graph, node, node, nodePath);
                        for (String _node : nodePath) {
                            MemberExcelVO member = (MemberExcelVO)members.get(_node);
                            valid.addValidResult(member.getRowIndex(), ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u6811\u5f62\u7ed3\u6784\u5b58\u5728\u5faa\u73af\u5f15\u7528\u3002", (String)"MemberValidator_10", (String)"epm-epbs-business", (Object[])new Object[0]));
                        }
                    }
                    if (nodePath.isEmpty()) continue;
                    break;
                }
            }
            if (valid.isOk() && !this.getValidators().isEmpty()) {
                for (IMemberValidator iMemberValidator : this.getValidators()) {
                    ValidResult<?> _tmpValid = iMemberValidator.batchValid(members);
                    if (_tmpValid.isOk()) continue;
                    valid.mergeErrorValidResult(_tmpValid);
                }
            }
        }
        catch (Throwable ex) {
            valid = new ValidResult(ex.getMessage());
        }
        return valid;
    }

    private void getCyclePath(MutableGraph<String> graph, String originNode, String nextStartNode, Collection<String> pathList) {
        pathList.add(nextStartNode);
        Set successors = graph.successors((Object)nextStartNode);
        if (successors.contains(originNode)) {
            pathList.add(originNode);
            return;
        }
        for (String successor : successors) {
            Set reachNodes = Graphs.reachableNodes(graph, (Object)successor);
            if (!reachNodes.contains(originNode) || pathList.contains(successor)) continue;
            this.getCyclePath(graph, originNode, successor, pathList);
            break;
        }
    }
}

