/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.mq.consumer;

import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.epm.epbs.business.mq.consumer.MessageConsumerFactory;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.common.mq.MQMessage;

public class MQConsumerFacade
implements MessageConsumer {
    private static WatchLogger log = EpbsLogFactory.getWatchLogInstance((boolean)true, MQConsumerFacade.class);

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        MQMessage msg = MQMessage.cast((String)message.toString());
        try {
            log.startWatch();
            MessageConsumerFactory.getConsumer(msg).onMessage(msg, messageId, resend, acker);
            log.infoEnd(String.format("epbs-consumer message-->%s", msg.genSendMQFormatMessage()));
            acker.ack(messageId);
        }
        catch (Exception e) {
            acker.discard(messageId);
            log.error(String.format("epbs-consumer-error,message is::%s", msg.genSendMQFormatMessage()), (Throwable)e);
        }
    }
}

