/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.mservice.EPDMCUDRequest;
import kd.epm.epbs.business.mservice.EPDMDataRequest;
import kd.epm.epbs.business.mservice.EPDMDataResponse;
import kd.epm.epbs.business.relation.RdQueryService;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;

public class DataModelMsHelper {
    protected static final WatchLogger LOG = EpbsLogFactory.getWatchLogInstance(RdQueryService.class);
    public static final String serviceName = "DataModelService";
    public static final String serviceNameCUD = "DataModelCUDService";
    public static final String getQueryId = "getQueryId";
    public static final String queryData = "queryData";
    public static final String getCUDId = "createCUDid";
    public static final String create = "create";
    public static final String update = "update";
    public static final String delete = "delete";
    public static final String getMultCUDId = "createMultCUDid";
    public static final String actionMult = "actionMult";
    public static final String ACTION_C = "C";
    public static final String ACTION_U = "U";
    public static final String ACTION_D = "D";
    public static final String COUNT = "count";
    public static final String PKEY = "pkey";
    public static final String ACTION_C_ROW = "rows";
    public static final String ACTION_U_ROW = "row";

    public EPDMDataResponse<Map<String, Object>> invokeBizService(String serviceName, String methodName, Object request) {
        EPDMDataResponse response = (EPDMDataResponse)DispatchServiceHelper.invokeBizService((String)AppTypeEnum.EPDM.getColudNum(), (String)AppTypeEnum.EPDM.getMserivceAppId(), (String)serviceName, (String)methodName, (Object[])new Object[]{request});
        if (null == response || response.getCode() != 200) {
            int code = null != response ? response.getCode() : 0;
            String msg = null != response ? response.getMessage() : "";
            LOG.error(String.format("%s-%s:req=[%s], rsp=[%s,%s]", serviceName, methodName, SerializationUtils.toJsonString((Object)request), code, msg));
            throw new KDBizException(new ErrorCode(String.valueOf(code), msg), new Object[0]);
        }
        return response;
    }

    public EPDMDataResponse<Map<String, Object>> invokeBizService(String methodName, Object request) {
        return this.invokeBizService(serviceName, methodName, request);
    }

    public EPDMDataResponse<Map<String, Object>> invokeBizServiceCUD(String methodName, Object request) {
        return this.invokeBizService(serviceNameCUD, methodName, request);
    }

    public Long getQueryId(EPDMDataRequest request) {
        EPDMDataResponse<Map<String, Object>> response = this.invokeBizService(getQueryId, request);
        return (Long)response.getData().get("qid");
    }

    public EPDMDataResponse<Map<String, Object>> queryData(EPDMDataRequest request) {
        Long qid = this.getQueryId(request);
        EPDMDataResponse<Map<String, Object>> response = this.invokeBizService(queryData, qid);
        return response;
    }

    public Long getMultCUDId(List<EPDMCUDRequest> requests) {
        EPDMDataResponse<Map<String, Object>> response = this.invokeBizServiceCUD(getMultCUDId, requests);
        return (Long)response.getData().get("CUDid");
    }

    protected Map<String, Object> buildCUDParams(Long cudid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("CUDid", cudid);
        return params;
    }

    public EPDMDataResponse<Map<String, Object>> actionMult(List<EPDMCUDRequest> requests, Map<String, Object> requestRows) {
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>(requests.size());
        Long cudid = this.getMultCUDId(requests);
        for (EPDMCUDRequest request : requests) {
            Map<String, Object> params = this.buildCUDParams(cudid);
            String rowKey = "";
            if (ACTION_C.equals(request.getAction())) {
                rowKey = ACTION_C_ROW;
            } else if (ACTION_U.equals(request.getAction())) {
                rowKey = ACTION_U_ROW;
            }
            params.put(PKEY, request.getPkey());
            if (StringUtils.isNotEmpty((String)rowKey)) {
                params.put(rowKey, requestRows.get(request.getPkey()));
            }
            paramList.add(params);
        }
        EPDMDataResponse<Map<String, Object>> response = this.invokeBizServiceCUD(actionMult, paramList);
        return response;
    }
}

