/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.mservice;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.mservice.EPDMFilter;
import kd.epm.epbs.business.mservice.EPDMGroup;
import kd.epm.epbs.business.mservice.EPDMOrder;
import kd.epm.epbs.business.mservice.EPDMRequest;
import kd.epm.epbs.common.enums.DataQueryGroupActionEnum;

public class EPDMDataRequest
extends EPDMRequest {
    private int size;
    private int page;
    private int total;
    private int lastPage;
    private String cache = "Y";
    private List<EPDMFilter> filters;
    private List<EPDMOrder> ords;
    private EPDMGroup group;
    private String customWhere = null;

    public String where() {
        if (null != this.customWhere && this.customWhere.length() > 2) {
            return this.customWhere;
        }
        return this.where(this.filters);
    }

    public String order() {
        if (null == this.oraLike) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u7c7b\u578b\u672a\u8bbe\u7f6e\u3002", (String)"EPDMDataRequest_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        StringBuilder sql = new StringBuilder();
        if (null == this.ords || this.ords.isEmpty()) {
            return sql.toString();
        }
        for (EPDMOrder ord : this.ords) {
            String field = ord.getField();
            if (this.oraLike.booleanValue()) {
                field = this.addQuotesAndUpperCase(field);
            }
            if (sql.length() < 1) {
                sql.append("order by ").append(field).append(" ").append(ord.getValue());
                continue;
            }
            sql.append(",").append(field).append(" ").append(ord.getValue());
        }
        return sql.toString();
    }

    public GroupEntity group() {
        DataQueryGroupActionEnum act;
        if (null == this.oraLike) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u7c7b\u578b\u672a\u8bbe\u7f6e\u3002", (String)"EPDMDataRequest_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        StringBuilder sql = new StringBuilder();
        if (null == this.group) {
            return null;
        }
        String fields = this.group.getFields();
        if (null == fields) {
            fields = "";
        }
        if (!StringUtils.isEmpty((String)fields)) {
            sql.append("group by ").append(this.group.getFields()).append(" ");
        }
        if ((act = DataQueryGroupActionEnum.get((String)this.group.getAction())) != null) {
            String numField = this.getNumField(act);
            String param = this.group.getParam();
            switch (act) {
                case AVG: 
                case MAX: 
                case MIN: 
                case SUM: {
                    if (!StringUtils.isEmpty((String)param)) break;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0eGROUP BY\u5bf9\u5e94\u7684\u64cd\u4f5c\u51fd\u6570[%s()]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EPDMDataRequest_2", (String)"epm-epbs-business", (Object[])new Object[0]), act.name()));
                }
                case COUNT: {
                    if (!StringUtils.isEmpty((String)param)) break;
                    param = "1";
                }
            }
            fields = !StringUtils.isEmpty((String)fields) ? fields + "," + act.name() + "(" + param + ") AS " + numField : fields + act.name() + "(" + param + ") AS " + numField;
        }
        return new GroupEntity(sql.toString(), fields);
    }

    private String getNumField(DataQueryGroupActionEnum act) {
        String numField = act.name() + "_NUM";
        if (this.getOrds() != null) {
            for (EPDMOrder order : this.getOrds()) {
                if (numField.equalsIgnoreCase(order.getField()) || StringUtils.isEmpty((String)order.getField()) || this.group.getFields().contains(order.getField())) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"ORDER BY \u7684\u5b57\u6bb5[%s]\u5fc5\u987b\u4e0eGROUP BY\u5bf9\u5e94\u3002", (String)"EPDMDataRequest_3", (String)"epm-epbs-business", (Object[])new Object[0]), order.getField()));
            }
        }
        return numField;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public List<EPDMFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<EPDMFilter> filters) {
        this.filters = filters;
    }

    public List<EPDMOrder> getOrds() {
        return this.ords;
    }

    public void setOrds(List<EPDMOrder> ords) {
        this.ords = ords;
    }

    public int getPage() {
        return this.page;
    }

    @Override
    public void setPage(int page) {
        this.page = page;
    }

    public int getTotal() {
        return this.total;
    }

    @Override
    public void setTotal(int total) {
        this.total = total;
    }

    public int getLastPage() {
        return this.lastPage;
    }

    @Override
    public void setLastPage(int lastPage) {
        this.lastPage = lastPage;
    }

    public EPDMGroup getGroup() {
        return this.group;
    }

    public void setGroup(EPDMGroup group) {
        this.group = group;
    }

    public String getCache() {
        return this.cache;
    }

    public void setCache(String cache) {
        this.cache = cache;
    }

    public String getCustomWhere() {
        return this.customWhere;
    }

    public void setCustomWhere(String customWhere) {
        this.customWhere = customWhere;
    }

    public static class GroupEntity {
        private final String groupBy;
        private final String fields;

        public GroupEntity(String groupBy, String fields) {
            this.groupBy = groupBy;
            this.fields = fields;
        }

        public String getGroupBy() {
            return this.groupBy;
        }

        public String getFields() {
            return this.fields;
        }
    }
}

