/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.mservice;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kd.bos.orm.query.QFilter;

public class EPDMFilter
implements Serializable {
    private String field;
    private String qcp;
    private Object value;
    private List<EPDMFilter> and;
    private List<EPDMFilter> or;
    private int level;

    public EPDMFilter(String field, String qcp, Object value) {
        this.field = field;
        this.qcp = qcp;
        this.value = value;
        this.level = 0;
        this.and = new ArrayList<EPDMFilter>(16);
        this.or = new ArrayList<EPDMFilter>(16);
    }

    public EPDMFilter() {
        this.and = new ArrayList<EPDMFilter>(16);
        this.or = new ArrayList<EPDMFilter>(16);
    }

    public String toExpress(boolean isOra) {
        return this.toQFilter(this, isOra).toString();
    }

    public QFilter toQFilter(EPDMFilter epf, boolean isOra) {
        String field = epf.getField();
        if (isOra) {
            field = this.addQuotesAndUpperCase(field);
        }
        QFilter filter = new QFilter(field, epf.getQcp(), epf.getValue());
        if (null != epf.getAnd() && !epf.getAnd().isEmpty()) {
            for (EPDMFilter f : epf.getAnd()) {
                filter.and(this.toQFilter(f, isOra));
            }
        }
        if (null != epf.getOr() && !epf.getOr().isEmpty()) {
            for (EPDMFilter f : epf.getOr()) {
                filter.or(this.toQFilter(f, isOra));
            }
        }
        return filter;
    }

    private String addQuotesAndUpperCase(String s) {
        return "\"" + s.toUpperCase(Locale.ROOT) + "\"";
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getQcp() {
        return this.qcp;
    }

    public void setQcp(String qcp) {
        this.qcp = qcp;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public EPDMFilter and(EPDMFilter filter) {
        this.and.add(filter);
        return this;
    }

    public EPDMFilter or(EPDMFilter filter) {
        this.or.add(filter);
        return this;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public List<EPDMFilter> getAnd() {
        return this.and;
    }

    public void setAnd(List<EPDMFilter> and) {
        this.and = and;
    }

    public List<EPDMFilter> getOr() {
        return this.or;
    }

    public void setOr(List<EPDMFilter> or) {
        this.or = or;
    }
}

