/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.multilingual;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.epm.epbs.business.multilingual.KsqlHandlerModel;
import kd.epm.epbs.business.multilingual.TableTree;
import kd.epm.epbs.business.paramsetting.KsqlExportUtil;
import kd.epm.epbs.common.enums.AppTypeEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class MetadataKsqlBuilder {
    private String appNum;
    private String formId;
    private QFilter[] qFilter;
    private List<String> fieldList;
    private Map<String, List<String>> childFields;
    private String orderby;
    private boolean enableOnlyInsert = false;
    private Consumer<KsqlHandlerModel> handler;
    private boolean recursion = true;
    private String language;
    protected DBRoute dbRoute;
    protected TableTree mainTable;

    public MetadataKsqlBuilder(String formId) {
        this(AppTypeEnum.EPBS.getAppNum(), formId);
    }

    public MetadataKsqlBuilder(String appNum, String formId) {
        this.appNum = appNum;
        this.formId = formId;
    }

    public void setRecursion(boolean recursion) {
        this.recursion = recursion;
    }

    public MetadataKsqlBuilder setFields(String fields) {
        this.fieldList = new ArrayList<String>(10);
        this.childFields = new HashMap<String, List<String>>();
        for (String f : fields.split(",")) {
            String[] split = f.split("\\.");
            String key = split[0].toLowerCase(Locale.ENGLISH).trim();
            if (split.length > 1) {
                this.childFields.computeIfAbsent(key, k -> new ArrayList(10)).add(split[1].toLowerCase(Locale.ENGLISH).trim());
            }
            if (this.fieldList.contains(key)) continue;
            this.fieldList.add(key);
        }
        return this;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        if (this.language == null) {
            this.language = Lang.get().name();
        }
        return this.language;
    }

    public MetadataKsqlBuilder setFilter(QFilter[] qf) {
        this.qFilter = qf;
        return this;
    }

    public MetadataKsqlBuilder setOrderBy(String orderby) {
        this.orderby = orderby;
        return this;
    }

    public MetadataKsqlBuilder enableOnlyInsert() {
        this.enableOnlyInsert = true;
        return this;
    }

    public MetadataKsqlBuilder addInterceptorHandler(Consumer<KsqlHandlerModel> handler) {
        this.handler = handler;
        return this;
    }

    private void init() {
        if (this.dbRoute == null) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.formId);
            String appId = dataEntityType.getAppId();
            this.dbRoute = DBRoute.of((String)appId);
            if (this.fieldList == null) {
                this.fieldList = dataEntityType.getProperties().stream().map(e -> e.getName()).collect(Collectors.toList());
            }
            this.mainTable = this.resolve(this.fieldList, (EntityType)dataEntityType);
        }
    }

    public String genKsqlDownloadUrl(String ksql) {
        if (StringUtils.isEmpty((String)ksql)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25,\u8bf7\u68c0\u67e5\u6570\u636e", (String)"MetadataKsqlBuilder_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        String fileName = KsqlExportUtil.genKsqlFileName(this.appNum, MetadataServiceHelper.getDataEntityType((String)this.formId).getName());
        return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)new ByteArrayInputStream(ksql.getBytes(StandardCharsets.UTF_8)), 5000);
    }

    public String genKsqlDownloadUrl() {
        return this.genKsqlDownloadUrl(this.genKsql());
    }

    public String genKsql() {
        this.init();
        if (this.mainTable == null) {
            return "";
        }
        StringJoiner sj = new StringJoiner(System.lineSeparator());
        this.fieldList.remove("multilanguagetext");
        DynamicObject[] load = BusinessDataServiceHelper.load((String)this.formId, (String)String.join((CharSequence)",", this.fieldList), (QFilter[])this.qFilter, (String)this.orderby);
        String fid = null;
        for (DynamicObject dy : load) {
            fid = dy.get("id") instanceof String ? "fid='" + dy.getString("id") + "'" : "fid=" + dy.getString("id");
            this.parseKSql(new KsqlHandlerModel(this.mainTable, fid, dy), sj);
            if (!this.recursion) continue;
            this.recursionKsql(this.mainTable.getChilds(), dy, fid, sj);
        }
        return sj.toString();
    }

    protected void recursionKsql(List<TableTree> childs, DynamicObject dy, String where, StringJoiner sj) {
        for (TableTree child : childs) {
            DynamicProperty property = dy.getDynamicObjectType().getProperty(child.getKey());
            if (property instanceof MuliLangTextProp) {
                String tempWhere = where;
                if (kd.bos.util.StringUtils.isNotEmpty((String)this.getLanguage())) {
                    tempWhere = String.format("%1$s and flocaleid='%2$s'", where, this.getLanguage());
                }
                this.parseKSql(new KsqlHandlerModel(child, tempWhere, dy), sj);
                continue;
            }
            if (property instanceof MulBasedataProp) {
                String pkid = dy.getDynamicObjectCollection(child.getKey()).stream().map(e -> e.getString("pkid")).collect(Collectors.joining(","));
                if (!kd.bos.util.StringUtils.isNotEmpty((String)pkid)) continue;
                String wherestr = where + " and fpkid in(" + pkid + ")";
                this.parseKSql(new KsqlHandlerModel(child, wherestr, dy), sj);
                continue;
            }
            if (!(property instanceof EntryProp)) continue;
            DynamicObjectCollection dys = dy.getDynamicObjectCollection(child.getKey());
            if (child.getChilds().isEmpty()) {
                if (dys.isEmpty()) continue;
                String fentryid = dys.stream().map(e -> {
                    Object o = e.get("id");
                    if (o instanceof String) {
                        return "'" + o + "'";
                    }
                    return o.toString();
                }).collect(Collectors.joining(","));
                String wheres = where + " and fentryid in(" + fentryid + ")";
                this.parseKSql(new KsqlHandlerModel(child, wheres, dy), sj);
                continue;
            }
            for (DynamicObject dyc : dys) {
                Object o = dyc.get("id");
                String w = o.toString();
                if (o instanceof String) {
                    w = "'" + o + "'";
                }
                this.parseKSql(new KsqlHandlerModel(child, "fentryid=" + w, dyc), sj);
                this.recursionKsql(child.getChilds(), dyc, "fid=" + w, sj);
            }
        }
    }

    protected void parseKSql(KsqlHandlerModel model, StringJoiner sj) {
        if (this.handler != null) {
            this.handler.accept(model);
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.formId);
        String ksql = KsqlExportUtil.getKsql(DBRoute.of((String)dataEntityType.getDBRouteKey()), model.getTableTree().getTable(), model.getTableTree().getFields().stream().collect(Collectors.joining(",")), model.getWhere());
        if (this.enableOnlyInsert) {
            String[] split;
            for (String s : split = ksql.split(System.lineSeparator())) {
                if (!kd.bos.util.StringUtils.isNotEmpty((String)s) || s.startsWith("DELETE FROM")) continue;
                sj.add(s);
            }
        } else {
            sj.add(ksql);
        }
    }

    protected TableTree resolve(List<String> fieldList, EntityType dataType) {
        if (kd.bos.util.StringUtils.isEmpty((String)dataType.getAlias()) || CollectionUtils.isEmpty(fieldList)) {
            return null;
        }
        TableTree tableTree = new TableTree(dataType.getAlias(), dataType.getName());
        for (String field : fieldList) {
            DynamicProperty prop = dataType.getProperty(field);
            if (prop instanceof MuliLangTextProp && kd.bos.util.StringUtils.isNotEmpty((String)prop.getAlias())) {
                TableTree child;
                List columnNames = DB.getColumnNames((DBRoute)DBRoute.of((String)dataType.getDBRouteKey()), (String)tableTree.getTable());
                if (columnNames.stream().anyMatch(e -> e.equalsIgnoreCase(prop.getAlias()))) {
                    tableTree.addField(prop.getAlias());
                }
                if ((child = tableTree.createChild(tableTree.getTable() + "_l", prop.getName())).getFields().isEmpty()) {
                    child.addFields(Arrays.asList("FID", "FPKID", "FLOCALEID"));
                }
                child.addField(prop.getAlias());
                continue;
            }
            if (prop instanceof MulBasedataProp && kd.bos.util.StringUtils.isNotEmpty((String)prop.getAlias())) {
                tableTree.createChild(((MulBasedataProp)prop).getDynamicCollectionItemPropertyType().getAlias(), prop.getName()).addFields(Arrays.asList("FID", "FBASEDATAID", "FPKID"));
                continue;
            }
            if (prop instanceof EntryProp) {
                EntryType entryType;
                List<String> childList = this.childFields == null ? entryType.getProperties().stream().map(e -> e.getName()).collect(Collectors.toList()) : this.childFields.get(field);
                TableTree resolve = this.resolve(childList, (EntityType)(entryType = (EntryType)((EntryProp)prop).getDynamicCollectionItemPropertyType()));
                if (resolve == null) continue;
                if (!resolve.getFields().contains("fid")) {
                    resolve.addField("fid");
                }
                tableTree.addChild(resolve);
                continue;
            }
            if (!kd.bos.util.StringUtils.isNotEmpty((String)prop.getAlias())) continue;
            if (kd.bos.util.StringUtils.isNotEmpty((String)prop.getTableGroup())) {
                tableTree.createChild(tableTree.getTable() + "_" + prop.getTableGroup(), prop.getName()).addField(prop.getAlias());
                continue;
            }
            tableTree.addField(prop.getAlias());
        }
        return tableTree;
    }
}

