/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.multilingual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.multilingual.MetadataKsqlBuilder;

public class MultilingualRecordService {
    private String sourceType;
    Map<String, ILocaleString> records = new HashMap<String, ILocaleString>(10);
    private MetadataKsqlBuilder ksqlBuilder;

    public MultilingualRecordService(String sourceType) {
        this.sourceType = sourceType;
    }

    public MultilingualRecordService addRecord(String number, ILocaleString name) {
        if (name != null) {
            this.records.put(number, name);
        }
        return this;
    }

    private QFilter[] queryQf(String ... numbers) {
        return new QFilter("number", "in", (Object)numbers).and("sourcetype", "=", (Object)this.sourceType).toArray();
    }

    public MultilingualRecordService save() {
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"epbs_multilingual_record", (String)"id,name,number,sourcetype", (QFilter[])this.queryQf(this.records.keySet().toArray(new String[0])));
        HashMap<String, ILocaleString> bakMap = new HashMap<String, ILocaleString>(this.records);
        for (DynamicObject dy : dys) {
            ILocaleString name2 = bakMap.remove(dy.getString("number"));
            if (name2 == null) continue;
            dy.set("name", (Object)name2);
        }
        ArrayList list = new ArrayList(16);
        bakMap.forEach((number, name) -> {
            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"epbs_multilingual_record");
            dy.set("number", number);
            dy.set("name", name);
            dy.set("sourcetype", (Object)this.sourceType);
            list.add(dy);
        });
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])dys);
        return this;
    }

    public String genKsql() {
        String[] array = this.records.keySet().toArray(new String[0]);
        this.records.clear();
        return this.genKsql(array);
    }

    public String genKsql(String ... numbers) {
        if (null == numbers || numbers.length == 0) {
            return "";
        }
        if (this.ksqlBuilder == null) {
            this.ksqlBuilder = new MetadataKsqlBuilder("epbs_multilingual_record").enableOnlyInsert();
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"epbs_multilingual_record");
        StringBuilder sb = new StringBuilder();
        String tablename = dataEntityType.getAlias();
        StringJoiner sj = new StringJoiner("','", "('", "')");
        for (String number : numbers) {
            sj.add(number);
        }
        String where = sj.toString();
        sb.append(String.format("DELETE FROM %s_l WHERE FID IN(SELECT FID FROM %s WHERE FNUMBER IN %s AND FSOURCETYPE='%s');", tablename, tablename, where, this.sourceType)).append(System.lineSeparator());
        sb.append(String.format("DELETE FROM %s WHERE FNUMBER IN %s AND FSOURCETYPE='%s';", tablename, where, this.sourceType)).append(System.lineSeparator());
        return sb.append(System.lineSeparator()).append(this.ksqlBuilder.setFilter(this.queryQf(numbers)).genKsql()).toString();
    }

    public Map<String, ILocaleString> queryLocale(QFilter qf) {
        return Arrays.stream(BusinessDataServiceHelper.load((String)"epbs_multilingual_record", (String)"number,name", (QFilter[])qf.toArray())).collect(Collectors.toMap(k -> k.getString("number"), v -> v.getLocaleString("name")));
    }
}

