/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.multilingual;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class TableTree {
    private String table;
    private String key;
    private List<String> fields = new ArrayList<String>(10);
    private List<TableTree> childs = new ArrayList<TableTree>(1);

    public TableTree(String table, String key) {
        this.table = table;
        this.key = key;
    }

    public String getTable() {
        return this.table;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void addField(String field) {
        if (!this.fields.contains(field)) {
            this.fields.add(field);
        }
    }

    public void addFields(List<String> fields) {
        this.fields.addAll(fields);
    }

    public List<TableTree> getChilds() {
        return this.childs;
    }

    public TableTree createChild(String childTable, String key) {
        Optional<TableTree> optional = this.childs.stream().filter(e -> e.getTable().equals(childTable)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        TableTree tableTree = new TableTree(childTable, key);
        this.childs.add(tableTree);
        return tableTree;
    }

    public void addChild(TableTree child) {
        if (child != null) {
            this.childs.add(child);
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

