/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.olap;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.common.PropertyBag;
import kd.bos.olap.dataSources.AggFactorMetadataItem;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.FunctionCommandInfo;
import kd.bos.olap.dataSources.MemberMetadataItem;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.olap.metadata.IMetadataBuilder;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.bos.olap.metadata.MetadataTypes;
import kd.bos.olap.metadata.OlapDataTypes;
import kd.bos.olap.metadata.StringMetadataBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceConfig;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.tracer.MemSpanTrace;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.olap.OlapUtils;
import kd.epm.epbs.business.olap.SQLBuilder;
import kd.epm.epbs.business.olap.bean.CellSetResultSet;
import kd.epm.epbs.business.olap.bean.MDResultSet;
import kd.epm.epbs.business.olap.bean.MDResultSetReader;
import kd.epm.epbs.business.olap.exception.MDQueryException;
import kd.epm.epbs.common.cache.helper.GlobalCacheServiceHelper;
import kd.epm.epbs.common.enums.model.BizModelAggoprtTypeEnum;
import kd.epm.epbs.common.enums.model.DimTypeEnum;
import kd.epm.epbs.common.enums.model.FacTabFieldDefEnum;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.BatchProcessHelper;
import kd.epm.epbs.common.util.OlapManagerHelper;
import org.apache.commons.collections4.CollectionUtils;

public class OlapServiceHelper {
    public static final String IS_UPGRADE_DYNA_COMPUTING = "is_dynamic";
    private static WatchLogger logger = EpbsLogFactory.getWatchLogInstance((boolean)true, OlapServiceHelper.class);

    public static void createCubeSchemes(DynamicObject model, long modelId) {
        String cube = model.getString("number");
        OlapServiceHelper.checkCubeCatalogIsNotNull(cube);
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.create);
        cmd.setMetadataType(MetadataTypes.Cube);
        cmd.setName(cube);
        cmd.getProperties().set("caption", model.getString("name") + "(" + model.getString("shownumber") + "," + RequestContext.get().getTenantId() + ")");
        cmd.getProperties().set(IS_UPGRADE_DYNA_COMPUTING, "true");
        String modelShowNumber = EpbsModelCacheHelper.get((long)modelId).getModel().getShowNumber();
        cmd.getProperties().set("database", modelId + modelShowNumber);
        OlapServiceHelper.executeCommand(cmd, cube, modelId);
        OlapServiceHelper.createMeasureSchemes(cube, modelId, false, FacTabFieldDefEnum.FIELD_MONEY.getField());
    }

    public static void createMeasureSchemes(String cubeCatalog, long modelId, boolean isInt, String ... measureFields) {
        OlapServiceHelper.checkCubeCatalogIsNotNull(cubeCatalog);
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        for (String measure : measureFields) {
            cmd.setAction(CommandTypes.create);
            cmd.setMetadataType(MetadataTypes.Measure);
            cmd.setOwnerUniqueName(cubeCatalog);
            cmd.setName(measure);
            if (isInt) {
                cmd.setDataType(OlapDataTypes.int64);
            }
            OlapServiceHelper.executeCommand(cmd, cubeCatalog, modelId);
        }
    }

    public static void syncDimensionShortNumber2Cube(String entityName, String cubeCatalog, long modelId) {
        OlapServiceHelper.getDimensionShortNumber2NumberMap(entityName, modelId).forEach((key, value) -> {
            MetadataCommandInfo cmd = new MetadataCommandInfo();
            cmd.setAction(CommandTypes.alter);
            cmd.setOwnerUniqueName(cubeCatalog);
            cmd.setMetadataType(MetadataTypes.Dimension);
            cmd.setName(value);
            cmd.getProperties().set("alias", key);
            OlapServiceHelper.executeCommand(cmd, cubeCatalog, modelId);
        });
    }

    public static void dropCubeSchemes(String cubeCatalog, long modelId) {
        OlapServiceHelper.checkCubeCatalogIsNotNull(cubeCatalog);
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.drop);
        cmd.setMetadataType(MetadataTypes.Cube);
        cmd.setName(cubeCatalog);
        OlapServiceHelper.executeCommand(cmd, cubeCatalog, modelId);
    }

    private static void checkCubeCatalogIsNotNull(String cubeCatalog) {
        if (StringUtils.isEmpty((String)cubeCatalog)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u521b\u5efacube\u65b9\u6848\u65f6,\u63d0\u4f9b\u7684\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (String)"OlapServiceHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
    }

    public static void dropDimensionMember(String cubeName, String dimNum, String memNum, long modelId) {
        if (OlapServiceHelper.isExistCube(cubeName, modelId)) {
            OlapServiceHelper.batchDropDimensionMembersForce(cubeName, dimNum, Lists.newArrayList((Object[])new String[]{memNum}), modelId);
        }
    }

    public static void batchDropDimensionMembers(String cubeCatalog, String dimNum, Collection<String> members, long modelId) {
        if (OlapServiceHelper.isExistCube(cubeCatalog, modelId)) {
            OlapServiceHelper.batchDropDimensionMembersForce(cubeCatalog, dimNum, members, modelId);
        }
    }

    public static void batchDropDimensionMembersForce(String cubeName, String dimNum, Collection<String> members, long modelId) {
        if (CollectionUtils.isEmpty(members)) {
            return;
        }
        OlapServiceHelper.checkCubeCatalogIsNotNull(cubeName);
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.drop);
        cmd.setMetadataType(MetadataTypes.Member);
        cmd.setOwnerUniqueName(cubeName + "." + dimNum);
        cmd.getProperties().set("allowDropMemberWhenRowReferenced", "true");
        Set<String> notExistMemberSet = OlapServiceHelper.batCheckMemberIsExistOlap(dimNum, members.toArray(new String[0]), cubeName, modelId);
        for (String name : members) {
            if (notExistMemberSet.contains(name)) continue;
            MemberMetadataItem memeber = new MemberMetadataItem();
            memeber.setName(name);
            cmd.getItems().add(memeber);
        }
        if (!cmd.getItems().isEmpty()) {
            OlapServiceHelper.executeCommand(cmd, cubeName, modelId);
        }
    }

    private static void executeCommand(MetadataCommandInfo cmd, String cubeCatalog, long modelId) {
        OlapConnection conn = null;
        try {
            conn = OlapServiceHelper.getOlapConnection(cubeCatalog, modelId);
            conn.Open();
            OlapCommand olapCommand = new OlapCommand(conn, (CommandInfo)cmd);
            olapCommand.executeNonQuery();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"olap \u64cd\u4f5c\u5931\u8d25\uff0c%s", (String)"OlapServiceHelper_2", (String)"epm-epbs-business", (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            if (conn != null) {
                conn.Close();
            }
        }
    }

    public static void batchCreateDimensionSchemes(String cubeName, String dimNum, String dimShortNumber, List<List<String>> list, long modelId, String aggoprttype) {
        OlapServiceHelper.createDimensionSchemes(cubeName, dimNum, dimShortNumber, modelId);
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.create);
        cmd.setOwnerUniqueName(cubeName + "." + dimNum);
        cmd.setMetadataType(MetadataTypes.Member);
        String[] members = new String[list.size()];
        ConcurrentHashMap<String, MemberStorageTypes> storageMap = new ConcurrentHashMap<String, MemberStorageTypes>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            String memNum;
            members[i] = memNum = list.get(i).get(0);
            boolean isleaf = Boolean.parseBoolean(list.get(i).get(3));
            if (!isleaf && !BizModelAggoprtTypeEnum.NONE.getValue().equals(aggoprttype)) {
                storageMap.put(memNum, MemberStorageTypes.DynamicCalc);
                continue;
            }
            storageMap.put(memNum, MemberStorageTypes.Stored);
        }
        Set<String> notExistsMember = OlapServiceHelper.batCheckMemberIsExistOlap(dimNum, members, cubeName, modelId);
        if (notExistsMember.isEmpty()) {
            OlapServiceHelper.synchronizationAggFactor(cubeName, dimNum, list, modelId, storageMap);
            return;
        }
        ArrayList metadataItems = new ArrayList(notExistsMember.size());
        notExistsMember.forEach(mem -> {
            MemberMetadataItem metadataItem = new MemberMetadataItem();
            metadataItem.setName(mem);
            metadataItems.add(metadataItem);
        });
        BatchProcessHelper.batchConsume(new ArrayList(metadataItems), (int)5000, batchBetadataItems -> {
            cmd.getItems().addAll(batchBetadataItems);
            OlapServiceHelper.executeCommand(cmd, cubeName, modelId);
            cmd.getItems().clear();
        });
        OlapServiceHelper.synchronizationAggFactor(cubeName, dimNum, list, modelId, storageMap);
    }

    public static void synchronizationAggFactor(String cubeName, String dimNum, List<List<String>> list, long modelId, Map<String, MemberStorageTypes> storageMap) {
        if (storageMap.size() > 0) {
            OlapServiceHelper.batchAlterMemberStorageType(cubeName, modelId, dimNum, storageMap);
        }
        HashMap<String, List<AggFactorMetadataItem>> map = new HashMap<String, List<AggFactorMetadataItem>>(16);
        HashMap parentSourceMap = new HashMap(16);
        list.forEach(t -> {
            String parentNumber = (String)t.get(2);
            if (StringUtils.isNotEmpty((String)parentNumber)) {
                List l = map.getOrDefault(parentNumber, new ArrayList(10));
                String memberNumber = (String)t.get(0);
                l.add(OlapUtils.createAggFactorMetadataItem(memberNumber, Integer.parseInt((String)t.get(1))));
                map.put(parentNumber, l);
                if (!parentSourceMap.containsKey(parentNumber)) {
                    parentSourceMap.put(parentNumber, new ArrayList(8));
                }
                ((List)parentSourceMap.get(parentNumber)).add(t);
            }
        });
        OlapServiceHelper.batchRepairAggFactor(cubeName, modelId, dimNum, map);
    }

    public static void createDimensionSchemes(String cubeCatalog, String dimNumber, String shortNumber, long modelId) {
        OlapServiceHelper.checkCubeCatalogIsNotNull(cubeCatalog);
        boolean existDimension = OlapServiceHelper.isExistDimension(cubeCatalog, modelId, dimNumber);
        if (existDimension) {
            return;
        }
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.create);
        cmd.setOwnerUniqueName(cubeCatalog);
        cmd.setMetadataType(MetadataTypes.Dimension);
        cmd.setName(dimNumber);
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
        DimensionBean dimension = modelCache.getDimension(dimNumber);
        if (dimension != null) {
            DimTypeBean dimTypeBean = modelCache.getDimTypeByDimensionId(dimension.getId());
            if (dimTypeBean == null || DimTypeEnum.Custom.getValue().equals(dimTypeBean.getType()) || DimTypeEnum.Version.getValue().equals(dimTypeBean.getType())) {
                cmd.setDefaultMemberName(dimension.getNoneMemberNumber());
            } else {
                cmd.setDefaultMemberName(dimNumber);
            }
        } else {
            cmd.setDefaultMemberName(dimNumber);
        }
        cmd.setAllowNull(false);
        OlapServiceHelper.executeCommand(cmd, cubeCatalog, modelId);
    }

    private static void executeUpdateMetadata(MetadataCommandInfo cmd, String cube, long modelId) {
        OlapConnection conn = null;
        try {
            conn = OlapServiceHelper.getOlapConnection(cube, modelId);
            conn.Open();
            OlapCommand olapCommand = new OlapCommand(conn, (CommandInfo)cmd);
            olapCommand.updateMetadata();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"olap \u66f4\u65b0\u5143\u6570\u636e\u5931\u8d25\uff0c%s", (String)"OlapServiceHelper_3", (String)"epm-epbs-business", (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            if (conn != null) {
                conn.Close();
            }
        }
    }

    public static void batchRepairAggFactor(String cubeNum, long modelId, String dimNum, Map<String, List<AggFactorMetadataItem>> map) {
        if (map != null && map.size() > 0) {
            MetadataCommandInfo cmd = new MetadataCommandInfo();
            cmd.setAction(CommandTypes.alter);
            cmd.setMetadataType(MetadataTypes.Member);
            cmd.setOwnerUniqueName(cubeNum + "." + dimNum);
            List items = cmd.getItems();
            for (Map.Entry<String, List<AggFactorMetadataItem>> entry : map.entrySet()) {
                String memNum = entry.getKey();
                List<AggFactorMetadataItem> agg = entry.getValue();
                MemberMetadataItem memItem = new MemberMetadataItem();
                memItem.setName(memNum);
                memItem.setFactors(agg);
                items.add(memItem);
                if (items.size() % 5000 != 0) continue;
                OlapServiceHelper.executeUpdateMetadata(cmd, cubeNum, modelId);
                items.clear();
            }
            if (items.size() > 0) {
                OlapServiceHelper.executeUpdateMetadata(cmd, cubeNum, modelId);
            }
        }
    }

    public static void batchAlterMemberStorageType(String cubeNum, long modelId, String dimNum, Map<String, MemberStorageTypes> map) {
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.alter);
        cmd.setMetadataType(MetadataTypes.Member);
        cmd.setOwnerUniqueName(cubeNum + "." + dimNum);
        List items = cmd.getItems();
        for (Map.Entry<String, MemberStorageTypes> entry : map.entrySet()) {
            String memNum = entry.getKey();
            MemberStorageTypes type = entry.getValue();
            MemberMetadataItem memItem = new MemberMetadataItem();
            if (type == MemberStorageTypes.Stored) {
                memItem.getProperties().set("storageType", "");
            } else {
                memItem.getProperties().set("storageType", type.getCode());
            }
            memItem.setName(memNum);
            items.add(memItem);
            if (items.size() % 100000 != 0) continue;
            OlapServiceHelper.executeUpdateMetadata(cmd, cubeNum, modelId);
            items.clear();
        }
        if (items.size() > 0) {
            OlapServiceHelper.executeUpdateMetadata(cmd, cubeNum, modelId);
        }
    }

    public static OlapConnection getOlapConnection(String cubeNum, long modelId) {
        return OlapManagerHelper.getOlapConnection((String)cubeNum, (Long)modelId);
    }

    public static OlapConnection getEmptyOlapConnection(String cubeNum, long modelId) {
        return OlapManagerHelper.getEmptyOlapConnection((String)cubeNum, (Long)modelId);
    }

    public static List<String> getMembersOfDimFromOlap(String dimensionNum, String cube, long modelId) {
        OlapConnection connect = OlapServiceHelper.getOlapConnection(cube, modelId);
        PropertyBag propertyBag = OlapServiceHelper.isExistMetadataNames(connect, dimensionNum, true);
        String[] childs = null;
        ArrayList<String> olapMembers = new ArrayList<String>(10);
        if (propertyBag.get("exist").equals("true")) {
            childs = propertyBag.get("children").split("\n");
            olapMembers = new ArrayList<String>(Arrays.asList(childs));
        }
        return olapMembers;
    }

    public static Set<String> batCheckMemberIsExistOlap(String dimensionNum, String[] memberNum, String cube, long modelId) {
        if (memberNum == null || memberNum.length == 0) {
            return Sets.newHashSet();
        }
        List<String> olapMembers = OlapServiceHelper.getMembersOfDimFromOlap(dimensionNum, cube, modelId);
        if (CollectionUtils.isEmpty(olapMembers)) {
            return Sets.newHashSet((Object[])memberNum);
        }
        HashSet olapMembersLowCase = new HashSet(olapMembers.size());
        HashSet<String> notExistMember = new HashSet<String>(memberNum.length);
        olapMembers.forEach(member -> olapMembersLowCase.add(member.toLowerCase(Locale.ENGLISH)));
        for (int i = 0; i < memberNum.length; ++i) {
            if (olapMembersLowCase.contains(String.valueOf(memberNum[i]).toLowerCase(Locale.ENGLISH))) continue;
            notExistMember.add(String.valueOf(memberNum[i]));
        }
        return notExistMember;
    }

    public static PropertyBag isExistMetadataNames(OlapConnection con, String path, boolean children) {
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.set("path", path);
        propertyBag.set("children", String.valueOf(children));
        FunctionCommandInfo functionCommandInfo = new FunctionCommandInfo("getMetadataNames", propertyBag);
        OlapCommand cmd = new OlapCommand(con, (CommandInfo)functionCommandInfo);
        return cmd.executeFunction();
    }

    public static boolean isExistCube(String cube, long modelId) {
        try {
            OlapConnection connect = OlapServiceHelper.getOlapConnection(cube, modelId);
            PropertyBag propertyBag = OlapServiceHelper.isExistMetadataNames(connect, "", false);
            return "true".equals(propertyBag.get("exist"));
        }
        catch (Exception e) {
            logger.error("OlapServiceHelper_isExistCube check faield:" + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean isExistDimension(String cube, long modelId, String dimensionNum) {
        try {
            OlapConnection connect = OlapServiceHelper.getOlapConnection(cube, modelId);
            PropertyBag propertyBag = OlapServiceHelper.isExistMetadataNames(connect, dimensionNum, false);
            return "true".equals(propertyBag.get("exist"));
        }
        catch (Exception e) {
            logger.error("OlapServiceHelper_isExistDimension check faield:" + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean hasOlapData(String cubeNum, List<String> memberNum, String dimensionNum, long modelId) {
        Map<String, Boolean> queryData = OlapServiceHelper.queryData(cubeNum, memberNum, dimensionNum, modelId);
        if (queryData == null || queryData.size() == 0) {
            return false;
        }
        return memberNum.stream().anyMatch(m -> (Boolean)queryData.get(m));
    }

    public static List<String> getHasOlapDataMembers(String cubeNum, List<String> memberNum, String dimensionNum, long modelId) {
        Map<String, Boolean> queryData = OlapServiceHelper.queryData(cubeNum, memberNum, dimensionNum, modelId);
        return queryData.keySet().stream().filter(k -> (Boolean)queryData.get(k)).collect(Collectors.toList());
    }

    public static Map<String, Boolean> queryData(String cubeNum, List<String> memberNum, String dimensionNum, long modelId) {
        if (!OlapServiceHelper.isExistCube(cubeNum, modelId) || !OlapServiceHelper.isExistDimension(cubeNum, modelId, dimensionNum)) {
            return new HashMap<String, Boolean>(16);
        }
        Set<String> notExistMembers = OlapServiceHelper.batCheckMemberIsExistOlap(dimensionNum, memberNum.toArray(new String[0]), cubeNum, modelId);
        if (!CollectionUtils.isEmpty(notExistMembers)) {
            memberNum.removeAll(notExistMembers);
        }
        if (memberNum.isEmpty()) {
            return Maps.newHashMap();
        }
        HashSet members = Sets.newHashSet(memberNum);
        return OlapServiceHelper.judgeExistMDDataByMember(cubeNum, dimensionNum, members, modelId);
    }

    public static Map<String, Boolean> judgeExistMDDataByMember(String cubeCatalog, String dimNum, Set<String> members, long modelId) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(members.size());
        SQLBuilder sql = new SQLBuilder(cubeCatalog);
        sql.addSelectField(dimNum);
        String measure = FacTabFieldDefEnum.FIELD_MONEY.getField();
        sql.addMeasures(measure);
        sql.setIncludeNull(false);
        sql.setExcludeDynaData(true);
        for (String member : members) {
            sql.replaceOrAddFilter(dimNum, member);
            result.put(member, OlapServiceHelper.judeExistNotNullMDData(sql, cubeCatalog, modelId));
        }
        return result;
    }

    public static boolean judeExistNotNullMDData(SQLBuilder sql, String cubeCatalog, long modelId) {
        int limitCount = 1000000;
        String measure = sql.getMeasures()[0];
        boolean isExist = false;
        try (MDResultSetReader rs = OlapServiceHelper.queryDataReader(sql, cubeCatalog, modelId);){
            int exeCount = 0;
            while (rs.next()) {
                if (exeCount >= limitCount) {
                    break;
                }
                Object v = rs.getOriginalValue(measure);
                if (v != null && (v instanceof Number && BigDecimal.ZERO.compareTo(new BigDecimal(v.toString())) != 0 || v instanceof String && StringUtils.isNotEmpty((String)v.toString()))) {
                    isExist = true;
                    break;
                }
                ++exeCount;
            }
        }
        return isExist;
    }

    public static MDResultSetReader queryDataReader(SQLBuilder sql, String cubeCatalog, long modelId) {
        sql.checkSelf();
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        queryInfo.addDims(sql.getSelectField());
        queryInfo.addMeasures(sql.getMeasures());
        queryInfo.setExcludeDynamicCalcResult(sql.isExcludeDynaData());
        queryInfo.setExcludeNull(sql.getTop() <= 0 && !sql.isIncludeNull());
        sql.getFilters().forEach(p -> queryInfo.addFilter((String)p.p1, (String[])p.p2));
        if (sql.getTop() > 0) {
            queryInfo.setTop(sql.getTop());
        }
        OlapConnection conn = null;
        OlapDataReader cs = null;
        try {
            conn = OlapServiceHelper.getOlapConnection(cubeCatalog, modelId);
            conn.Open();
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)queryInfo);
            cs = cmd.executeReader((IMetadataBuilder)StringMetadataBuilder.INSTANCE);
            MDResultSetReader rs = OlapServiceHelper.getMDResultSetReader();
            CellSetResultSet set = new CellSetResultSet(sql.getCubecatalog(), cs, queryInfo, conn);
            set.setIncludeNull(sql.getTop() > 0 || sql.isIncludeNull());
            try (MemSpanTrace span = MemSpanTrace.create((String)"olap", (String)"query");
                 TraceSpan ts = Tracer.create((String)"olap", (String)"query");
                 Auditable audit = Audit.audit((String)"olap_cost", (Object[])new Object[]{"query", queryInfo});){
                if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)"olap")) {
                    ts.addTag("sql", queryInfo.toString());
                }
                ts.addTag("route", sql.getCubecatalog());
            }
            rs.populate(set);
            return rs;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new MDQueryException(String.format(ResManager.loadKDString((String)"olap \u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"OlapServiceHelper_4", (String)"epm-epbs-business", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private static MDResultSetReader getMDResultSetReader() {
        return new MDResultSetReader();
    }

    public static Map<String, String> getDimensionShortNumber2NumberMap(String entityName, long modelId) {
        return (Map)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)("dim-number-short-bizmodel" + modelId), () -> {
            LinkedHashMap cacheMap = new LinkedHashMap(16);
            BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"number,shortnumber", (QFilter[])new QFilter("id", "=", (Object)modelId).toArray(), (String)"dseq").values().forEach(e -> cacheMap.put(e.getString("shortnumber"), e.getString("number")));
            return Collections.unmodifiableMap(cacheMap);
        });
    }

    public static List<Map<String, Object>> queryData(SelectCommandInfo queryInfo, OlapConnection conn) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
        OlapCommand cmd = new OlapCommand(conn, (CommandInfo)queryInfo);
        OlapDataReader olapDataReader = cmd.ExecuteReader();
        int fieldCount = olapDataReader.getFieldCount();
        Object[] values = new Object[fieldCount];
        while (olapDataReader.next()) {
            olapDataReader.getValues(values);
            int i = 0;
            HashMap<String, Object> map = new HashMap<String, Object>(fieldCount);
            for (String measure : queryInfo.getMeasures()) {
                map.put(measure, values[i++]);
            }
            for (String dimension : queryInfo.getDimensions()) {
                map.put(dimension, values[i++]);
            }
            list.add(map);
        }
        olapDataReader.close();
        return list;
    }

    /*
     * Exception decompiling
     */
    public static Map<String, Object> queryData(SelectCommandInfo queryInfo, String cubeCatalog, Long modelId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Map<String, Object> queryDataCore(SelectCommandInfo queryInfo, String cubeCatalog, Long modelId) {
        SQLBuilder sql = new SQLBuilder(cubeCatalog);
        sql.addSelectField(queryInfo.getDimensions().toArray(new String[0]));
        if (queryInfo.getFilter() != null) {
            queryInfo.getFilter().forEach(f -> sql.addFilter(f.getName(), f.getValues().toArray(new String[0])));
        }
        sql.setModelId(modelId);
        sql.addMeasures(queryInfo.getMeasures().toArray(new String[0]));
        sql.setTop(queryInfo.getTop());
        sql.setExcludeDynaData(queryInfo.getExcludeDynamicCalcResult());
        sql.setIncludeDynamicMemberWhenNullFilter(queryInfo.getIncludeDynamicMemberWhenNullFilter());
        MDResultSet rs = OlapServiceHelper.queryData(sql);
        HashMap<String, Object> result = rs == null ? new HashMap(16) : rs.asMap("|", queryInfo.getDimensions());
        return result;
    }

    public static MDResultSet queryData(SQLBuilder sql) {
        return OlapServiceHelper.queryData(sql, false);
    }

    public static MDResultSet queryData(SQLBuilder sql, boolean multiMeasure) {
        if (sql.isCancel()) {
            return null;
        }
        sql.checkSelf();
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        queryInfo.addDims(sql.getSelectField());
        queryInfo.setExcludeNullOrDefault(sql.isExcludeNullOrDefault());
        if (multiMeasure) {
            queryInfo.addMeasures(sql.getMeasures());
        } else {
            queryInfo.addMeasures(new String[]{sql.getMeasures()[0]});
        }
        List<String> measures = Arrays.asList(sql.getMeasures());
        queryInfo.setExcludeDynamicCalcResult(sql.isExcludeDynaData());
        queryInfo.setIncludeDynamicMemberWhenNullFilter(sql.getIncludeDynamicMemberWhenNullFilter());
        if (!sql.getLazyFilter().isEmpty()) {
            queryInfo.setIncludeDynamicMemberWhenNullFilter(true);
        }
        sql.getFilters().forEach(p -> queryInfo.addFilter((String)p.p1, (String[])p.p2));
        if (sql.getTop() > 0) {
            queryInfo.setTop(sql.getTop());
        }
        OlapConnection conn = null;
        OlapDataReader cs = null;
        try {
            MDResultSet rs = new MDResultSet();
            try (TraceSpan ts = Tracer.create((String)"olap", (String)"query");){
                conn = OlapServiceHelper.getOlapConnection(sql.getCubecatalog(), sql.getModelId());
                conn.Open();
                OlapCommand cmd = new OlapCommand(conn, (CommandInfo)queryInfo);
                cs = cmd.ExecuteReader();
                CellSetResultSet set = new CellSetResultSet(sql.getCubecatalog(), cs, queryInfo, conn);
                set.setIncludeNull(sql.getTop() > 0 || sql.isIncludeNull());
                set.setLazyFilters(sql.getLazyFilter());
                set.getDataChecker().setCheckPar_Son(sql.isCheckPar_Son());
                if (sql.isExcludeNullData()) {
                    set.setIncludeNull(false);
                }
                if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)"olap")) {
                    ts.addTag("sql", queryInfo.toString());
                }
                ts.addTag("route", sql.getCubecatalog());
                if (multiMeasure) {
                    rs.populates(set);
                } else {
                    rs.populate(set);
                }
                ts.addTag("count", String.valueOf(rs.getCount()));
            }
            MDResultSet mDResultSet = rs;
            return mDResultSet;
        }
        catch (Throwable e) {
            logger.error(e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"olap \u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"OlapServiceHelper_4", (String)"epm-epbs-business", (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            if (cs != null) {
                cs.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void alterCubeDatabase(OlapConnection olapConn, String cubeNumber, String database) {
        MetadataCommandInfo commandInfo = new MetadataCommandInfo();
        commandInfo.setMetadataType(MetadataTypes.Cube);
        commandInfo.setName(cubeNumber);
        commandInfo.setOwnerUniqueName(cubeNumber);
        commandInfo.setAction(CommandTypes.alter);
        commandInfo.getProperties().set("database", database);
        OlapCommand command = new OlapCommand(olapConn, (CommandInfo)commandInfo);
        command.executeNonQuery();
    }

    public static long selectDatasource() {
        DynamicObjectCollection dataSources = QueryServiceHelper.query((String)"epbs_datasource", (String)"id", (QFilter[])new QFilter[0]);
        if (!dataSources.isEmpty()) {
            return ((DynamicObject)dataSources.get(0)).getLong("id");
        }
        return 0L;
    }
}

