/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.olap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.olap.FacTabFieldDefEnum;
import kd.epm.epbs.business.olap.ISqlLazyFilter;
import kd.epm.epbs.business.olap.exception.MDQueryException;
import kd.epm.epbs.common.util.Pair;
import kd.epm.epbs.common.util.ToStringHelper;

public class SQLBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _cubecatalog;
    private long modelId;
    private List<String> selector = new LinkedList<String>();
    private List<Pair<String, String[]>> filter = new ArrayList<Pair<String, String[]>>();
    private Map<String, Set<ISqlLazyFilter>> lazyFilter = new HashMap<String, Set<ISqlLazyFilter>>(8);
    private List<String> measures = new LinkedList<String>();
    private int top = -1;
    private boolean isIncludeNull = false;
    private boolean excludeNullData = false;
    private boolean isCancel = false;
    private boolean isOnlyNumber = false;
    private boolean excludeDynaData = false;
    private boolean isCheckPar_Son = true;
    private boolean includeDynamicMemberWhenNullFilter = false;
    private boolean excludeNullOrDefault = false;

    public SQLBuilder(String cubecatalog) {
        this._cubecatalog = cubecatalog;
    }

    public String getCubecatalog() {
        return this._cubecatalog;
    }

    public boolean isExcludeNullData() {
        return this.excludeNullData;
    }

    public void setExcludeNullData(boolean excludeNullData) {
        this.excludeNullData = excludeNullData;
    }

    public void setIncludeDynamicMemberWhenNullFilter(boolean includeDynamicMemberWhenNullFilter) {
        this.includeDynamicMemberWhenNullFilter = includeDynamicMemberWhenNullFilter;
    }

    public boolean getIncludeDynamicMemberWhenNullFilter() {
        return this.includeDynamicMemberWhenNullFilter;
    }

    public void addSelectField(String ... dimKeys) {
        for (String f : dimKeys) {
            if (this.selector.contains(f)) {
                throw new MDQueryException(String.format("set repeated field:%s", f));
            }
            this.selector.add(f);
        }
    }

    public String[] getSelectField() {
        return this.selector.toArray(new String[0]);
    }

    public void addFilter(String dimKey, String ... values) {
        this.filter.add((Pair<String, String[]>)Pair.onePair((Object)dimKey, (Object)values));
    }

    public void addLazyFilter(String dimKey, ISqlLazyFilter filter) {
        this.lazyFilter.compute(dimKey, (k, v) -> {
            HashSet<ISqlLazyFilter> set = null;
            if (v == null) {
                set = new HashSet<ISqlLazyFilter>();
                set.add(filter);
            } else {
                set = v;
                set.add(filter);
            }
            return set;
        });
    }

    public Map<String, Set<ISqlLazyFilter>> getLazyFilter() {
        return this.lazyFilter;
    }

    public boolean containFilter(String dimKey) {
        return this.getFilter(dimKey) != null;
    }

    public void replaceOrAddFilter(String dimKey, String ... values) {
        boolean isReplace = false;
        for (int i = 0; i < this.filter.size(); ++i) {
            if (!dimKey.equals(this.filter.get((int)i).p1)) continue;
            this.filter.set(i, (Pair<String, String[]>)Pair.onePair((Object)this.filter.get((int)i).p1, (Object)values));
            isReplace = true;
            break;
        }
        if (!isReplace) {
            this.addFilter(dimKey, values);
        }
    }

    public void mergeOrAddFilter(String dimKey, Set<String> values) {
        boolean isReplace = false;
        for (int i = 0; i < this.filter.size(); ++i) {
            if (!dimKey.equals(this.filter.get((int)i).p1)) continue;
            values.addAll(Arrays.asList((Object[])this.filter.get((int)i).p2));
            this.filter.set(i, (Pair<String, String[]>)Pair.onePair((Object)this.filter.get((int)i).p1, (Object)values.toArray(new String[0])));
            isReplace = true;
            break;
        }
        if (!isReplace) {
            this.addFilter(dimKey, values.toArray(new String[0]));
        }
    }

    public List<Pair<String, String[]>> getFilters() {
        return this.filter;
    }

    public Pair<String, String[]> getFilter(String dimNum) {
        return this.filter.stream().filter(f -> ((String)f.p1).equals(dimNum)).findFirst().orElse(null);
    }

    public void addMeasures(String ... measures) {
        for (String m : measures) {
            if (this.measures.contains(m)) {
                throw new MDQueryException(String.format("set repeated measure:%s", m));
            }
            this.measures.add(m);
        }
    }

    public String[] getMeasures() {
        String[] stringArray;
        if (this.measures.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = FacTabFieldDefEnum.FIELD_MONEY.getField();
        } else {
            stringArray = this.measures.toArray(new String[0]);
        }
        return stringArray;
    }

    public void reset() {
        this.selector.clear();
        this.filter.clear();
        this.measures.clear();
    }

    public void checkSelf() {
        if (StringUtils.isEmpty((String)this._cubecatalog) || this.selector.isEmpty()) {
            throw new MDQueryException(String.format("SQLBuilder is not complete SQL:%s", ToStringHelper.deepToString((Object)this)));
        }
    }

    public int getTop() {
        return this.top;
    }

    public String toString() {
        return ToStringHelper.deepToString((Object)this);
    }

    public void setTop(int top) {
        this.top = top;
    }

    public boolean isIncludeNull() {
        return this.isIncludeNull;
    }

    public void setIncludeNull(boolean isIncludeNull) {
        this.isIncludeNull = isIncludeNull;
    }

    public void setCancel(boolean cancel) {
        this.isCancel = cancel;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public boolean isOnlyNumber() {
        return this.isOnlyNumber;
    }

    public void setOnlyNumber(boolean isOnlyNumber) {
        this.isOnlyNumber = isOnlyNumber;
    }

    public boolean isExcludeDynaData() {
        return this.excludeDynaData;
    }

    public void setExcludeDynaData(boolean excludeDynaData) {
        this.excludeDynaData = excludeDynaData;
    }

    public boolean isCheckPar_Son() {
        return this.isCheckPar_Son;
    }

    public void setCheckPar_Son(boolean checkPar_Son) {
        this.isCheckPar_Son = checkPar_Son;
    }

    public boolean isExcludeNullOrDefault() {
        return this.excludeNullOrDefault;
    }

    public void setExcludeNullOrDefault(boolean excludeNullOrDefault) {
        this.excludeNullOrDefault = excludeNullOrDefault;
    }

    public long getModelId() {
        return this.modelId;
    }

    public void setModelId(long modelId) {
        this.modelId = modelId;
    }
}

