/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.olap.bean;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.epbs.business.olap.ISqlLazyFilter;
import kd.epm.epbs.business.olap.bean.MDDataChecker;

public class CellSetResultSet {
    private SelectCommandInfo queryInfo;
    private OlapDataReader cs;
    private boolean isIncludeNull = false;
    private boolean isOnlyNumber = false;
    private OlapConnection conn = null;
    private MDDataChecker dataChecker = null;
    private String modelNum = null;
    private static final Set<String> commDimKeys = Sets.newHashSet((Object[])new String[]{"Process", "Entity", "Year", "Period", "Scenario"});
    private Map<String, Set<ISqlLazyFilter>> lazyFilters;

    public CellSetResultSet(String modelNum, OlapDataReader cs, SelectCommandInfo queryInfo, OlapConnection conn) {
        this.cs = cs;
        this.queryInfo = queryInfo;
        this.conn = conn;
        this.modelNum = modelNum;
        this.dataChecker = new MDDataChecker();
        this.dataChecker.build(container -> queryInfo.getFilter().forEach(f -> {
            if (commDimKeys.contains(f.getName()) && f.getValues() != null && f.getValues().size() == 1) {
                container.put(f.getName(), f.getValues().get(0));
            }
        }));
    }

    public OlapConnection getConnection() {
        return this.conn;
    }

    public List<String> getMetaData() {
        ArrayList<String> metaDatas = new ArrayList<String>();
        metaDatas.addAll(this.queryInfo.getDimensions());
        metaDatas.addAll(this.queryInfo.getMeasures());
        return metaDatas;
    }

    public OlapDataReader getOlapDataReader() {
        return this.cs;
    }

    protected String getMeasure() {
        return (String)this.queryInfo.getMeasures().get(0);
    }

    protected List<String> getMeasures() {
        return this.queryInfo.getMeasures();
    }

    public boolean isIncludeNull() {
        return this.isIncludeNull;
    }

    public void setIncludeNull(boolean isIncludeNull) {
        this.isIncludeNull = isIncludeNull;
    }

    public boolean isOnlyNumber() {
        return this.isOnlyNumber;
    }

    public void setOnlyNumber(boolean isOnlyNumber) {
        this.isOnlyNumber = isOnlyNumber;
    }

    public String getModelNum() {
        return this.modelNum;
    }

    public MDDataChecker getDataChecker() {
        return this.dataChecker;
    }

    public Map<String, Set<ISqlLazyFilter>> getLazyFilters() {
        return this.lazyFilters;
    }

    public void setLazyFilters(Map<String, Set<ISqlLazyFilter>> lazyFilters) {
        this.lazyFilters = lazyFilters;
    }
}

