/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.olap.bean;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.epm.epbs.business.olap.SQLBuilder;
import kd.epm.epbs.business.olap.bean.CellSetResultSet;
import kd.epm.epbs.business.olap.bean.IMDResultSet;
import kd.epm.epbs.business.olap.bean.MDResultSet;
import kd.epm.epbs.business.olap.bean.MDResultSetMetaData;
import kd.epm.epbs.business.olap.bean.Row;
import kd.epm.epbs.business.olap.util.CartesianUtil;
import kd.epm.epbs.common.util.DateTimeUtils;

public class MDResultSetReader
implements Serializable,
IMDResultSet {
    private CellSetResultSet cs;
    private boolean hasNextRow = false;
    private Row row;
    private MDResultSetMetaData metaData;
    private Map<MDResultSet.MemberMeta, MDResultSet.MemberMeta> memberMetaDic = new HashMap<MDResultSet.MemberMeta, MDResultSet.MemberMeta>();

    @Override
    public boolean next() {
        this.hasNextRow = false;
        while (this.cs.getOlapDataReader().next()) {
            Object v;
            this.row = null;
            Object[] values = new Object[this.cs.getMetaData().size()];
            this.cs.getOlapDataReader().getValues(values);
            if (values[0] == null && !this.cs.isIncludeNull() || (v = values[0]) != null && this.cs.isOnlyNumber() && !this.isNumber(v)) continue;
            this.row = new Row(this.metaData, this.memberMetaDic);
            int size = values.length;
            for (int i = 1; i < size; ++i) {
                this.row.addColumnValue(values[i]);
            }
            Object value = values[0];
            if (value instanceof String && String.valueOf(value).startsWith("/OADate")) {
                value = DateTimeUtils.formatDateToUTC((String)String.valueOf(value));
            }
            this.row.addMeasureValue(value);
            if (!this.isValidated(this.cs.getModelNum(), this.row, this.cs.getDataChecker())) continue;
            this.hasNextRow = true;
            break;
        }
        return this.hasNextRow;
    }

    private boolean isNumber(Object v) {
        return v instanceof Number;
    }

    @Override
    public void beforeFirst() {
        this.notSupportException();
    }

    @Override
    public void populate(CellSetResultSet rs) {
        this.cs = rs;
        List<String> list = rs.getMetaData();
        this.metaData = new MDResultSetMetaData();
        list.forEach(c -> this.metaData.addColumnMeta((String)c));
    }

    @Override
    public int getFetchSize() {
        return (Integer)this.notSupportException();
    }

    private <T> T notSupportException() {
        throw new RuntimeException("not support operator");
    }

    private void checkRecordRead() {
        if (this.row == null) {
            throw new RuntimeException("not record to read");
        }
    }

    @Override
    public String getString(String colName) {
        this.checkRecordRead();
        return this.row.getString(colName);
    }

    @Override
    public Date getDate(String colName) {
        this.checkRecordRead();
        return this.row.getDate(colName);
    }

    @Override
    public BigDecimal getBigDecimal(String colName) {
        this.checkRecordRead();
        return this.row.getBigDecimal(colName);
    }

    @Override
    public int getInt(String colName) {
        this.checkRecordRead();
        return this.row.getInt(colName);
    }

    @Override
    public Object getOriginalValue(String colName) {
        this.checkRecordRead();
        return this.row.getOriginalValue(colName);
    }

    @Override
    public Row getRow() {
        if (!this.hasNextRow) {
            throw new RuntimeException("cursor is last,not more record");
        }
        return this.row;
    }

    @Override
    public void close() {
        this.row = null;
        if (this.cs.getOlapDataReader() != null) {
            this.cs.getOlapDataReader().close();
        }
        if (this.cs.getConnection() != null) {
            this.cs.getConnection().Close();
        }
    }

    @Override
    public MDResultSetMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public boolean isEmpty() {
        return (Boolean)this.notSupportException();
    }

    @Override
    public Map<String, Object> asMap() {
        return (Map)this.notSupportException();
    }

    @Override
    public void merger(IMDResultSet rs) {
        this.notSupportException();
    }

    @Override
    public Map<String, Object> asMap(String joinSign, List<String> selectDims) {
        return (Map)this.notSupportException();
    }

    @Override
    public void mergerReduce(IMDResultSet rs) {
        this.notSupportException();
    }

    @Override
    public void makeup(SQLBuilder sql, List<String> carsdim) {
        ArrayList<String> list = new ArrayList<String>();
        List<String> dims = Arrays.asList(sql.getSelectField());
        list.addAll(dims);
        list.addAll(Arrays.asList(sql.getMeasures()));
        this.metaData = new MDResultSetMetaData();
        list.forEach(c -> this.metaData.addColumnMeta((String)c));
        ArrayList makerows = new ArrayList(10);
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        sql.getFilters().forEach(f -> {
            if (carsdim.contains(f.p1)) {
                map.put((String)f.p1, (String[])f.p2);
            } else {
                map.put((String)f.p1, new String[]{((String[])f.p2)[0]});
            }
        });
        this.addAllMembers(dims, map, sql.getCubecatalog());
        ArrayList<String[]> mems = new ArrayList<String[]>(dims.size());
        for (String dim : dims) {
            mems.add(map.get(dim));
        }
        List<List<Object>> result = CartesianUtil.cartesianProduct((Object[][])mems.toArray((T[])new String[mems.size()][]));
        result.forEach(r -> {
            Row row = new Row(this.metaData, this.memberMetaDic);
            r.forEach(row::addColumnValue);
            row.addMeasureValue("");
            makerows.add(row);
        });
    }

    @Override
    public void addAllMembers(List<String> dims, HashMap<String, String[]> map, String cubeNum) {
    }
}

