/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.olap.bean;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.epm.epbs.business.olap.bean.MDResultSet;
import kd.epm.epbs.business.olap.bean.MDResultSetMetaData;
import kd.epm.epbs.common.util.TypeConversionUtils;

public class Row
implements Serializable {
    private List<Object> values = new ArrayList<Object>();
    private MDResultSetMetaData metaData = new MDResultSetMetaData();
    private Map<MDResultSet.MemberMeta, MDResultSet.MemberMeta> memberMetaDic;

    public Row(MDResultSetMetaData metaData, Map<MDResultSet.MemberMeta, MDResultSet.MemberMeta> memberMetaDic) {
        this.metaData = metaData;
        this.memberMetaDic = memberMetaDic;
    }

    public boolean addColumnValue(Object val) {
        return this.values.add(this.packMemberMeta(val));
    }

    public void replaceColumnValue(int index, Object val) {
        this.values.set(index, this.packMemberMeta(val));
    }

    private MDResultSet.MemberMeta packMemberMeta(Object val) {
        MDResultSet.MemberMeta key = new MDResultSet.MemberMeta(val);
        return this.memberMetaDic.computeIfAbsent(key, v -> key);
    }

    public boolean addMeasureValue(Object val) {
        return this.values.add(val);
    }

    public void replaceMeasureValue(int index, Object val) {
        this.values.set(index, val);
    }

    public Object getValue(int index) {
        if (index < 0) {
            return null;
        }
        Object v = this.values.get(index);
        return v instanceof MDResultSet.MemberMeta ? ((MDResultSet.MemberMeta)MDResultSet.MemberMeta.class.cast(v)).get() : v;
    }

    public String getString(String colName) {
        Object obj = this.getValue(this.metaData.getColIndex(colName));
        return TypeConversionUtils.objToString((Object)obj);
    }

    public Date getDate(String colName) {
        Object obj = this.getValue(this.metaData.getColIndex(colName));
        return TypeConversionUtils.objToDate((Object)obj);
    }

    public BigDecimal getBigDecimal(String colName) {
        Object obj = this.getValue(this.metaData.getColIndex(colName));
        return TypeConversionUtils.objToBigDecimal((Object)obj);
    }

    public int getInt(String colName) {
        Object obj = this.getValue(this.metaData.getColIndex(colName));
        return TypeConversionUtils.objToInt((Object)obj);
    }

    public Object getOriginalValue(String colName) {
        return this.getValue(this.metaData.getColIndex(colName));
    }

    public int getColIndex(String colName) {
        return this.metaData.getColIndex(colName);
    }

    public String toString() {
        return Arrays.toString(this.values.toArray());
    }

    public List<String> getStrValues() {
        return this.values.stream().map(s -> {
            Object data = s instanceof MDResultSet.MemberMeta ? ((MDResultSet.MemberMeta)MDResultSet.MemberMeta.class.cast(s)).get() : s;
            return TypeConversionUtils.objToString((Object)data);
        }).collect(Collectors.toList());
    }
}

