/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.paramsetting;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.epm.epbs.common.enums.AppDBRouteEnum;
import org.apache.commons.lang.StringUtils;

public class KsqlExportUtil {
    private KsqlExportUtil() {
    }

    public static String genKsqlFileName(String appnum, String tableAlis) {
        return "kd_1.5_" + appnum + "_" + tableAlis + "_" + DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(LocalDateTime.now()) + ".sql";
    }

    public static String exportKsql(String table, String field, String whereFilter) {
        String sql = KsqlExportUtil.getKsql(table, field, whereFilter);
        if (StringUtils.isEmpty((String)sql)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25,\u8bf7\u68c0\u67e5\u6570\u636e", (String)"KsqlExportUtil_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        String fileSuffix = ".sql";
        String fileName = table + "_" + DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(LocalDateTime.now()) + fileSuffix;
        return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)new ByteArrayInputStream(sql.getBytes(StandardCharsets.UTF_8)), 5000);
    }

    public static String getKsql(String table, String field, String whereFilter) {
        return KsqlExportUtil.getKsql(AppDBRouteEnum.EPBS.getDbRoute(), table, field, whereFilter);
    }

    public static String getKsql(DBRoute dbRoute, String table, String field, String whereFilter) {
        Map map;
        Objects.requireNonNull(table, "table name cannot be null!");
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        try {
            if ("*".equals(field) || StringUtils.isEmpty((String)field)) {
                List columnNames = DB.getColumnNames((DBRoute)dbRoute, (String)table);
                map = builder.genInsertSQLScript(dbRoute, table, String.join((CharSequence)",", columnNames), whereFilter, null, null);
            } else {
                map = builder.genInsertSQLScript(dbRoute, table, field, whereFilter, null, null);
            }
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u5bfc\u51faKSQL\u5931\u8d25", (String)"KsqlExportUtil_2", (String)"epm-epbs-business", (Object[])new Object[0])), new Object[0]);
        }
        String sql = (String)map.get("sql");
        if (StringUtils.isEmpty((String)sql)) {
            return "";
        }
        return sql;
    }
}

