/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.paramsetting;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.paramsetting.ParamSettingService;
import kd.epm.epbs.business.paramsetting.model.ParamSettingModel;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.bean.OperationTypeInfo;
import kd.epm.epbs.common.cache.helper.GlobalCacheServiceHelper;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.AppDBRouteEnum;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.util.EpbsOperationResult;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.NumberRuleUtils;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.ProjectConstant;
import org.apache.commons.collections4.CollectionUtils;

public class ParamSetSaveOp {
    private boolean isSource = false;
    private ParamSettingModel model;
    private Collection<String> opDescs;

    public ParamSetSaveOp(ParamSettingModel model, Collection<String> opDescs) {
        this.model = model;
        this.opDescs = opDescs;
    }

    public ParamSetSaveOp(boolean isSource, ParamSettingModel model, Collection<String> opDescs) {
        this(model, opDescs);
        this.isSource = isSource;
    }

    protected EpbsOperationResult validator() {
        if (this.isSource) {
            if (StringUtils.isEmpty((String)this.model.getNumber())) {
                return new EpbsOperationResult(false, ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ParamSetSaveOp_1", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            if (!NumberRuleUtils.checkNumber((String)this.model.getNumber())) {
                return new EpbsOperationResult(false, NumberRuleUtils.getMessage());
            }
            if (this.model.getName() == null || StringUtils.isEmpty((String)this.model.getName().getLocaleValue())) {
                return new EpbsOperationResult(false, ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ParamSetSaveOp_2", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            if (this.model.getDesc() == null || StringUtils.isEmpty((String)this.model.getDesc().getLocaleValue())) {
                return new EpbsOperationResult(false, ResManager.loadKDString((String)"\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ParamSetSaveOp_3", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
        }
        return new EpbsOperationResult();
    }

    public EpbsOperationResult save() {
        EpbsOperationResult validator = this.validator();
        if (!validator.isSuccess()) {
            return validator;
        }
        OperationTypeInfo operationTypeInfo = new OperationTypeInfo("updateparamvalue", new MultiLangEnumBridge("\u4fee\u6539\u53c2\u6570\u503c", "ParamSetSaveOp_4", "epm-epbs-business"));
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            DynamicObject old = QueryServiceHelper.queryOne((String)"epbs_preset_param", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.model.getNumber())});
            if (this.isSource) {
                if (this.model.getId() > 0L && (old == null || old.getLong("id") != this.model.getId())) {
                    EpbsOperationResult epbsOperationResult = new EpbsOperationResult(false, ResManager.loadKDString((String)"\u7f16\u7801\u5b9a\u4e49\u4e0d\u5408\u6cd5\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"ParamSetSaveOp_5", (String)"epm-epbs-business", (Object[])new Object[0]));
                    return epbsOperationResult;
                }
                if (this.model.getId() > 0L && old.getLong("id") == this.model.getId()) {
                    DynamicObject update = BusinessDataServiceHelper.loadSingle((String)"epbs_preset_param", (String)"id,name,desc,form,nodeids,defaultparams,formtype,issys,isolate,type,isshow", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.model.getNumber())});
                    update.set("name", (Object)this.model.getName());
                    update.set("desc", (Object)this.model.getDesc());
                    update.set("defaultparams", (Object)this.model.getParams());
                    update.set("formtype", (Object)(this.model.getFormType() + ""));
                    update.set("isshow", (Object)this.model.isShow());
                    update.set("issys", (Object)(this.model.isSys() ? "1" : "0"));
                    update.set("isolate", (Object)(this.model.isIsolate() ? "1" : "0"));
                    update.set("type", (Object)(this.model.getType().getIndex() + ""));
                    if (StringUtils.isNotEmpty((String)this.model.getForm())) {
                        update.set("form", (Object)this.model.getForm());
                    }
                    if (CollectionUtils.isNotEmpty(this.model.getNodes())) {
                        DynamicObjectCollection nodeids = update.getDynamicObjectCollection("nodeids");
                        nodeids.clear();
                        this.model.getNodes().forEach(e -> {
                            DynamicObject node = nodeids.addNew();
                            node.set("fbasedataid_id", e);
                        });
                    }
                    SaveServiceHelper.save((IDataEntityType)update.getDynamicObjectType(), (Object[])new DynamicObject[]{update});
                    this.updateEntryData(old);
                    this.clearParamLocalCache();
                    operationTypeInfo = new OperationTypeInfo("changeParamval", new MultiLangEnumBridge("\u53d8\u66f4\u53c2\u6570", "ParamSetSaveOp_6", "epm-epbs-business"));
                } else {
                    if (this.model.getId() == 0L && old != null) {
                        EpbsOperationResult update = new EpbsOperationResult(false, ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u5b9a\u4e49\u8bbe\u7f6e\u3002", (String)"ParamSetSaveOp_7", (String)"epm-epbs-business", (Object[])new Object[0]));
                        return update;
                    }
                    DynamicObject dy = this.model.genDynamicObject();
                    SaveServiceHelper.save((IDataEntityType)dy.getDataEntityType(), (Object[])new DynamicObject[]{dy});
                    this.clearParamLocalCache();
                    operationTypeInfo = new OperationTypeInfo("addParamValue", new MultiLangEnumBridge("\u65b0\u589e\u53c2\u6570", "ParamSetSaveOp_8", "epm-epbs-business"));
                }
            } else if (old != null) {
                this.updateEntryData(old);
                GlobalCacheServiceHelper.getCommonCache().invalidateByKey(ParamSettingService.getNumberAndModelKey(this.model.getNumber(), this.model.getModelId()));
            }
            if (CollectionUtils.isNotEmpty(this.opDescs)) {
                String modelNumber;
                String string = modelNumber = IDUtils.isNotNull((long)this.model.getModelId()) ? ModelCacheHelper.getModel((long)this.model.getModelId()).getShowNumber() : "null";
                if (this.model.getModelId() == 0L) {
                    OperationLogUtil.writeLog((String)this.model.getFormId(), (IOperationTypeInfo)operationTypeInfo, (MultiLangEnumBridge)new MultiLangEnumBridge("\u7f16\u7801\u3010%1$s\u3011\u4fee\u6539\u4e86\u53c2\u6570\u503c", "ParamSetSaveOp_10", "epm-epbs-business", new Object[]{this.model.getNumber()}));
                } else {
                    OperationLogUtil.writeLog((String)this.model.getFormId(), (IOperationTypeInfo)operationTypeInfo, (MultiLangEnumBridge)new MultiLangEnumBridge("\u7f16\u7801\u3010%1$s\u3011\u4fee\u6539\u4e86\u4f53\u7cfb\u7f16\u7801\u3010%2$s\u3011\u7684\u53c2\u6570\u503c", "ParamSetSaveOp_9", "epm-epbs-business", new Object[]{this.model.getNumber(), modelNumber}));
                }
            }
            EpbsOperationResult epbsOperationResult = new EpbsOperationResult();
            return epbsOperationResult;
        }
        catch (Exception e2) {
            try {
                tx.markRollback();
                throw e2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private void updateEntryData(DynamicObject old) {
        long modelId = this.model.isIsolate() ? this.model.getModelId() : 0L;
        try (DataSet data = DB.queryDataSet((String)"paramset.detail", (DBRoute)ProjectConstant.DB_ROUTE, (String)"select fid,fmodelid from t_epbs_param_set where fid=? and fmodelid=?", (Object[])new Object[]{old.getLong("id"), modelId});){
            String sql;
            if (data.hasNext()) {
                sql = "update t_epbs_param_set set fparams=? ,fmodifierid=?,fmodifytime=? where fid=? and fmodelid=?";
                List<Object> p = Arrays.asList(this.model.getParams(), RequestContext.getOrCreate().getCurrUserId(), TimeServiceHelper.now(), old.getLong("id"), modelId);
                DB.execute((DBRoute)AppDBRouteEnum.EPBS.getDbRoute(), (String)sql, (Object[])p.toArray());
            } else {
                sql = "INSERT INTO t_epbs_param_set(fid, fentryid, fseq, fmodelid, fparams,fmodifierid, fmodifytime)\nVALUES(?, ?, 0, ?, ?, ?, ?);";
                List<Object> p = Arrays.asList(old.getLong("id"), GlobalIdUtil.genGlobalLongId(), modelId, this.model.getParams(), RequestContext.getOrCreate().getCurrUserId(), TimeServiceHelper.now());
                DB.execute((DBRoute)AppDBRouteEnum.EPBS.getDbRoute(), (String)sql, (Object[])p.toArray());
                SaveServiceHelper.clearDataEntityCache((String)"epbs_preset_param");
            }
        }
    }

    private void clearParamLocalCache() {
        GlobalCacheServiceHelper.getCommonCache().invalidateStartsWithKey(this.model.getNumber() + "|");
    }
}

