/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.paramsetting;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.paramsetting.enums.PsDataTypeEnum;
import kd.epm.epbs.business.paramsetting.enums.PsFormTypeEnum;
import kd.epm.epbs.business.paramsetting.pojo.ParamSettingPojo;
import kd.epm.epbs.business.paramsetting.util.ParamSettingUtils;
import kd.epm.epbs.common.cache.helper.GlobalCacheServiceHelper;
import kd.epm.epbs.common.util.JSONUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class ParamSettingService {
    private static final Log LOG = LogFactory.getLog(ParamSettingService.class);

    private ParamSettingService() {
    }

    public static <T> T queryParamSetting(String number) {
        return (T)ParamSettingService.queryParamSetting(new ParamSettingPojo(number), (T k) -> k);
    }

    public static <T> T queryParamSetting(String appNum, String number) {
        return (T)ParamSettingService.queryParamSetting(new ParamSettingPojo(appNum, 0L, number), (T k) -> k);
    }

    public static <T> T queryParamSetting(long modelId, String number) {
        return (T)ParamSettingService.queryParamSetting(modelId, number, k -> k);
    }

    public static <T, R> R queryParamSetting(long modelId, String number, Function<T, R> function) {
        return ParamSettingService.queryParamSetting(new ParamSettingPojo(modelId, number), function);
    }

    private static <T, R> R queryParamSetting(ParamSettingPojo pojo, Function<T, R> function) {
        return (R)((PsModel)GlobalCacheServiceHelper.getCommonCache().getOrLoad(ParamSettingService.getNumberAndModelKey(pojo.getNumber(), pojo.getModelId()), () -> new PsModel(function.apply(ParamSettingService.queryParamSetting(pojo))))).getValue();
    }

    private static Object queryParamSetting(ParamSettingPojo paramSettingPojo) {
        String number = paramSettingPojo.getNumber();
        int isolate = paramSettingPojo.getModelId() == 0L ? 0 : 1;
        QFilter qFilters = QFilter.join((String)"id", (String)"entryentity.id", (QFilter)new QFilter("entryentity.model", "=", (Object)paramSettingPojo.getModelId()), (ORMHint.JoinHint)ORMHint.JoinHint.LEFT, (boolean)true);
        qFilters.and("number", "=", (Object)number);
        if (StringUtils.isNotEmpty((String)paramSettingPojo.getAppNum())) {
            qFilters.and("nodeids.fbasedataid.appnum", "=", (Object)paramSettingPojo.getAppNum());
        }
        QFilter modelFilter = new QFilter("entryentity.model", "=", (Object)paramSettingPojo.getModelId()).or("entryentity.model", "is null", null);
        qFilters.and(modelFilter);
        DynamicObjectCollection params = QueryServiceHelper.query((String)"epbs_preset_param", (String)"number,isolate,type,formtype,form,defaultparams,entryentity.params,entryentity.model", (QFilter[])qFilters.toArray(), (String)"entryentity.model desc");
        if (CollectionUtils.isEmpty((Collection)params)) {
            return null;
        }
        if (isolate != ((DynamicObject)params.get(0)).getInt("isolate")) {
            LOG.error(String.format("\u67e5\u8be2\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u7f16\u7801[%s]\u4f53\u7cfb[%s]\u3002\u8fd4\u56de\u8be5\u53c2\u6570\u9ed8\u8ba4\u503c", number, paramSettingPojo.getModelId()));
        }
        return ParamSettingService.getParamValue((DynamicObject)params.get(0));
    }

    public static String getNumberAndModelKey(String number, Long modelId) {
        return String.format("%s|%s", number, ParamSettingService.getStringModelId(modelId));
    }

    private static Object getParamValue(DynamicObject param) {
        PsDataTypeEnum psDataTypeEnum = PsDataTypeEnum.getByIndex(param.getInt("type"));
        int formType = param.getInt("formtype");
        String params = psDataTypeEnum == PsDataTypeEnum.JSON && PsFormTypeEnum.COMMON.getIndex() == formType ? ParamSettingService.readDefaultParams(param) : ParamSettingService.getParams(param);
        LOG.info(String.format("\u53c2\u6570\u7f16\u7801[%s]\u4f53\u7cfb[%s]\u503c[%s]", param.getString("number"), param.getString("entryentity.model"), StringUtils.isEmpty((String)params) ? "" : (params.length() > 2000 ? params.substring(0, 2000) : params)));
        return ParamSettingUtils.convertParams2Object(psDataTypeEnum, params);
    }

    private static String getParams(DynamicObject param) {
        return StringUtils.isNotEmpty((String)param.getString("entryentity.params")) ? param.getString("entryentity.params") : param.getString("defaultparams");
    }

    private static String readDefaultParams(DynamicObject param) {
        if (StringUtils.isEmpty((String)param.getString("entryentity.params"))) {
            return ParamSettingService.getParams(param);
        }
        JSONObject defaultparamsJson = (JSONObject)JSONUtils.parse((String)param.getString("defaultparams"), JSONObject.class);
        JSONObject paramJson = (JSONObject)JSONUtils.parse((String)param.getString("entryentity.params"), JSONObject.class);
        defaultparamsJson.forEach((arg_0, arg_1) -> paramJson.putIfAbsent(arg_0, arg_1));
        return paramJson.toJSONString();
    }

    private static String getStringModelId(Long modelId) {
        return modelId == null ? "0" : "" + modelId;
    }

    static class PsModel<T> {
        protected T value;

        public PsModel(T t) {
            this.value = t;
        }

        public T getValue() {
            return this.value;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("value", this.value).toString();
        }
    }
}

