/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.paramsetting.enums;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.epm.epbs.business.paramsetting.enums.PsControlTypeEnum;

public enum PsDataTypeEnum {
    BOOL(0),
    TEXT(1),
    JSON(2),
    DATE(3),
    DECIMAL(4),
    INT(5);

    private int index;

    private PsDataTypeEnum(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public static PsDataTypeEnum getByIndex(int index) {
        for (PsDataTypeEnum ps : PsDataTypeEnum.values()) {
            if (ps.getIndex() != index) continue;
            return ps;
        }
        return BOOL;
    }

    public Set<String> getControlRange() {
        switch (this) {
            case BOOL: {
                return Sets.newHashSet((Object[])new String[]{PsControlTypeEnum.CHECKBOX.getIndex() + ""});
            }
            case TEXT: {
                return Sets.newHashSet((Object[])new String[]{PsControlTypeEnum.TEXT.getIndex() + "", PsControlTypeEnum.TEXTAREA.getIndex() + "", PsControlTypeEnum.RADIOGROUP.getIndex() + "", PsControlTypeEnum.COMBO.getIndex() + "", PsControlTypeEnum.MULCOMBO.getIndex() + "", PsControlTypeEnum.TELEPHONE.getIndex() + "", PsControlTypeEnum.EMAIL.getIndex() + ""});
            }
            case INT: {
                return Sets.newHashSet((Object[])new String[]{PsControlTypeEnum.INT.getIndex() + "", PsControlTypeEnum.BIGINT.getIndex() + "", PsControlTypeEnum.TIME.getIndex() + ""});
            }
            case DATE: {
                return Sets.newHashSet((Object[])new String[]{PsControlTypeEnum.DATETIME.getIndex() + "", PsControlTypeEnum.DATE.getIndex() + ""});
            }
            case DECIMAL: {
                return Sets.newHashSet((Object[])new String[]{PsControlTypeEnum.DECIMAL.getIndex() + ""});
            }
        }
        return Arrays.stream(PsControlTypeEnum.values()).map(e -> e.getIndex() + "").collect(Collectors.toSet());
    }

    public boolean isSingleParam() {
        return this != JSON;
    }
}

