/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.business.paramsetting.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.paramsetting.enums.PsDataTypeEnum;
import kd.epm.epbs.business.paramsetting.enums.PsFormTypeEnum;
import kd.epm.epbs.business.paramsetting.model.ParamSetFormModel;
import kd.epm.epbs.business.paramsetting.util.ParamSettingUtils;
import kd.epm.epbs.business.paramsetting.util.PsControlFieldUtils;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.AppTypeEnum;
import org.apache.commons.collections4.CollectionUtils;

public class ParamSettingModel
implements Serializable {
    public static final long serialVersionUID = -1L;
    private long id;
    private String number;
    private ILocaleString name;
    private boolean isolate = true;
    private long modelId;
    private int formType;
    private String params;
    private ILocaleString desc;
    private boolean isSys = true;
    private String form;
    private PsDataTypeEnum type;
    private List<Long> nodes;
    private boolean isShow;

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public ILocaleString getName() {
        return this.name;
    }

    public void setName(ILocaleString name) {
        this.name = name;
    }

    public boolean isIsolate() {
        return this.isolate;
    }

    public void setIsolate(boolean isolate) {
        this.isolate = isolate;
    }

    public long getModelId() {
        return this.modelId;
    }

    public void setModelId(long modelId) {
        this.modelId = modelId;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public void setParamsWithDateType(Object v) {
        this.params = ParamSettingUtils.convertParams2String(this.type, v);
    }

    public Object getParamsWithDateType() {
        return ParamSettingUtils.convertParams2Object(this.type, this.params);
    }

    public ILocaleString getDesc() {
        return this.desc;
    }

    public void setDesc(ILocaleString desc) {
        this.desc = desc;
    }

    public PsDataTypeEnum getType() {
        return this.type;
    }

    public void setType(PsDataTypeEnum type) {
        this.type = type;
    }

    public boolean isSys() {
        return this.isSys;
    }

    public void setSys(boolean sys) {
        this.isSys = sys;
    }

    public String getForm() {
        return this.form;
    }

    public String getFormId() {
        if (org.apache.commons.lang.StringUtils.isEmpty((String)this.getForm()) || PsFormTypeEnum.DEFAULT.getIndex() == this.getFormType()) {
            if (ParamSettingModel.existEntity("bcm_param_set") && this.isCmApp()) {
                return "bcm_param_set";
            }
            if (ParamSettingModel.existEntity("eb_param_set") && this.isEbApp()) {
                return "eb_param_set";
            }
            return "epbs_param_set_defaulttpl";
        }
        if (PsFormTypeEnum.CUSTOM.getIndex() == this.getFormType()) {
            return this.getFormModel().getFormId();
        }
        if (ParamSettingModel.existEntity("bcm_param_set_dynamic") && this.isCmApp()) {
            return "bcm_param_set_dynamic";
        }
        if (ParamSettingModel.existEntity("eb_param_set_dynamic") && this.isEbApp()) {
            return "eb_param_set_dynamic";
        }
        return "epbs_param_set_dynamictpl";
    }

    private boolean isEbApp() {
        try {
            if (this.modelId == 0L) {
                DynamicObjectCollection nodes = QueryServiceHelper.query((String)"epbs_paramsettree", (String)"appnum", (QFilter[])new QFilter[]{new QFilter("id", "in", this.nodes)});
                if (CollectionUtils.isEmpty((Collection)nodes)) {
                    return false;
                }
                return AppTypeEnum.isEbApp((String)((DynamicObject)nodes.get(0)).getString("appnum"));
            }
            return AppTypeEnum.isEbApp((String)ModelCacheHelper.getModel((long)this.modelId).getSrcAppNum());
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isCmApp() {
        try {
            if (this.modelId == 0L) {
                DynamicObjectCollection nodes = QueryServiceHelper.query((String)"epbs_paramsettree", (String)"appnum", (QFilter[])new QFilter[]{new QFilter("id", "in", this.nodes)});
                if (CollectionUtils.isEmpty((Collection)nodes)) {
                    return false;
                }
                return AppTypeEnum.isCMApp((String)((DynamicObject)nodes.get(0)).getString("appnum"));
            }
            return AppTypeEnum.isCMApp((String)ModelCacheHelper.getModel((long)this.modelId).getSrcAppNum());
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean existEntity(String entityNumber) {
        try {
            if (EntityMetadataCache.getDataEntityType((String)entityNumber) != null) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public ParamSetFormModel getFormModel() {
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)this.form)) {
            return PsControlFieldUtils.castJson2Form(this.form);
        }
        return new ParamSetFormModel();
    }

    public void setForm(String form) {
        this.form = form;
    }

    public void setFormWithFormModel(ParamSetFormModel form) {
        this.form = PsControlFieldUtils.toJsonString(form);
    }

    public List<Long> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<Long> nodes) {
        this.nodes = nodes;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getFormType() {
        return this.formType;
    }

    public void setFormType(int formType) {
        this.formType = formType;
    }

    public DynamicObject genDynamicObject() {
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"epbs_preset_param");
        dy.set("number", (Object)this.getNumber());
        dy.set("name", (Object)this.getName());
        dy.set("desc", (Object)this.getDesc());
        dy.set("formtype", (Object)(this.getFormType() + ""));
        dy.set("issys", (Object)(this.isSys() ? "1" : "0"));
        dy.set("isshow", (Object)(this.isShow() ? "1" : "0"));
        dy.set("isolate", (Object)(this.isIsolate() ? "1" : "0"));
        dy.set("type", (Object)(this.getType().getIndex() + ""));
        dy.set("defaultparams", (Object)this.getParams());
        dy.set("createtime", (Object)new Date());
        if (this.getForm() != null) {
            dy.set("form", (Object)this.getForm());
        }
        if (CollectionUtils.isNotEmpty(this.getNodes())) {
            this.getNodes().forEach(e -> {
                DynamicObject node = dy.getDynamicObjectCollection("nodeids").addNew();
                node.set("fbasedataid_id", e);
            });
        }
        return dy;
    }

    public static ParamSettingModel createInstance(DynamicObject dy, long modelId) {
        ParamSettingModel paramSettingModel = new ParamSettingModel();
        paramSettingModel.setType(PsDataTypeEnum.getByIndex(dy.getInt("type")));
        String form = dy.getString("form");
        if (StringUtils.isNotEmpty((CharSequence)form)) {
            paramSettingModel.setForm(form);
        }
        paramSettingModel.setId(dy.getLong("id"));
        paramSettingModel.setNumber(dy.getString("number"));
        paramSettingModel.setIsolate(dy.getBoolean("isolate"));
        paramSettingModel.setName(dy.getLocaleString("name"));
        paramSettingModel.setSys(dy.getBoolean("issys"));
        paramSettingModel.setShow(dy.getBoolean("isshow"));
        paramSettingModel.setDesc(dy.getLocaleString("desc"));
        paramSettingModel.setFormType(dy.getInt("formtype"));
        paramSettingModel.setParams(dy.getString("defaultparams"));
        paramSettingModel.setModelId(paramSettingModel.isIsolate() ? modelId : 0L);
        if (dy.getDynamicObjectType().getProperties().stream().anyMatch(e -> e.getName().equals("nodeids"))) {
            paramSettingModel.setNodes(dy.getDynamicObjectCollection("nodeids").stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList()));
        }
        if (dy.getDynamicObjectType().getProperties().stream().anyMatch(e -> e.getName().equals("entryentity"))) {
            DynamicObjectCollection entryentity = dy.getDynamicObjectCollection("entryentity");
            Optional<DynamicObject> re = entryentity.stream().filter(e -> e.getLong("model_id") == paramSettingModel.getModelId()).findFirst();
            paramSettingModel.setParams(re.isPresent() ? re.get().getString("params") : dy.getString("defaultparams"));
        }
        return paramSettingModel;
    }

    public boolean isShow() {
        return this.isShow;
    }

    public void setShow(boolean show) {
        this.isShow = show;
    }
}

